# coding: UTF-8
module RDGC
  module Character
    module PlayerStatus
      include Status

      def job
        @job
      end

      def job_name
        job.job_name
      end

      def change_job(new_job)
        @job = new_job
        status_update
      end

      def exp
        @exp ||= 0
        @exp
      end

      def rest_exp
        next_lv_exp - exp
      end

      def next_lv_exp
        job.next_lv_exp(lv)
      end

      def add_exp(val)
        @exp ||= 0
        add_val = (val * exp_ratio).ceil
        @exp += add_val
        add_val
      end

      def exp_ratio
        @exp_ratio ||= 1.0
        @exp_ratio
      end

      def auto_heal_hp
        @auto_heal_hp ||= 1.0
        @auto_heal_hp
      end

      def auto_heal_sp
        @auto_heal_sp ||= 1.0
        @auto_heal_sp
      end

      def auto_heal
        heal_hp(auto_heal_hp)
        heal_sp(auto_heal_sp)
      end

      def lvup?
        exp >= next_lv_exp ? true : false
      end

      def lvup
        @lv ||= 1
        @lv += 1
        status_update
        full_heal_hp
        full_heal_sp
      end

      def set_wep_atk(a)
        @wep_atk = a
      end

      def set_arm_def(d)
        @arm_def = d
      end

      def status_update
        # TODO 装備やbuff、カード効果を考慮するやり方に変更
        @raw_str = job.status_from_lv(:str, lv)
        @raw_agi = job.status_from_lv(:agi, lv)
        @raw_vit = job.status_from_lv(:vit, lv)
        @raw_int = job.status_from_lv(:int, lv)
        @raw_dex = job.status_from_lv(:dex, lv)
        @raw_luk = job.status_from_lv(:luk, lv)

        @raw_max_hp = calc_max_hp
        @raw_max_sp = calc_max_sp

        @auto_heal_hp = (@raw_max_hp * 0.01).ceil
        @auto_heal_sp = (@raw_max_sp * 0.01).ceil

        update_timer_status
      end

      private

      def calc_max_hp
        job.hp_base + lv + (lv.to_f * job.hp_up_ratio * (1+vit*0.01)).ceil
      end

      def calc_max_sp
        job.sp_base + lv + (lv.to_f * job.sp_up_ratio * (1+int*0.01)).ceil
      end

    end
  end
end
