# coding: UTF-8
module RDGC
  module Character
    class Base < Article::Base

      def overlapable?
        false
      end

      def move(dir)
        return unless floor

        # 新しい座標
        nx = self.x + dir.x
        ny = self.y + dir.y
        return unless floor.movable?(nx, ny)

        # 衝突する対象がいるか？
        cols = floor.collision_articles_for(nx, ny).reject{|c| c == self}
        unless cols.empty?
          # 衝突判定
          cols.each do |c|
            c.reaction_to(self)
            break if disable?
          end
          # 衝突した => 移動できない
          return (disable? ? :disabled : :not_move)
        end

        # 移動
        set(nx, ny)

        # 設置物からの反応
        overs = floor.overlap_articles_for(self)
        overs.each do |o|
          o.reaction_to(self)
          break if disable?
        end
        return :disabled if disable?

        :moved
      end

    end
  end
end
