# coding: UTF-8
module RDGC
  module Article
    module TimeControlled

      def next_count
        timer.next_count
      end

      def next_time
        timer.next_time
      end

      def update_time(count)
        timer.update(count)
      end

      def action_ok?
        timer.action_ok?
      end

      def action
      end

      def act_cycle
      end

      def act_ratio
      end

      def act_limit
      end

      def timer
        create_timer unless @timer
        @timer
      end

      def update_timer_status
        timer.cycle = act_cycle
        timer.update_ratio = act_ratio
        timer.limit = act_limit if act_limit
      end

      private

      def create_timer
        @timer = Timer::CallbackTimer.new
        @timer.target = self
        @timer.call_method = :action
        @timer
      end

    end
  end
end
