/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLTableColElement.h"

#include <wtf/GetPtr.h>

#include "HTMLTableColElement.h"
#include "PlatformString.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSHTMLTableColElementTableEntries[] =
{
    { 0, 0, 0, 0, 0 },
    { "width", JSHTMLTableColElement::WidthAttrNum, DontDelete, 0, 0 },
    { "chOff", JSHTMLTableColElement::ChOffAttrNum, DontDelete, 0, &JSHTMLTableColElementTableEntries[7] },
    { 0, 0, 0, 0, 0 },
    { "ch", JSHTMLTableColElement::ChAttrNum, DontDelete, 0, 0 },
    { "align", JSHTMLTableColElement::AlignAttrNum, DontDelete, 0, &JSHTMLTableColElementTableEntries[8] },
    { 0, 0, 0, 0, 0 },
    { "span", JSHTMLTableColElement::SpanAttrNum, DontDelete, 0, &JSHTMLTableColElementTableEntries[9] },
    { "vAlign", JSHTMLTableColElement::VAlignAttrNum, DontDelete, 0, 0 },
    { "constructor", JSHTMLTableColElement::ConstructorAttrNum, DontDelete|DontEnum|ReadOnly, 0, 0 }
};

static const HashTable JSHTMLTableColElementTable = 
{
    2, 10, JSHTMLTableColElementTableEntries, 7
};

/* Hash table for constructor */

static const HashEntry JSHTMLTableColElementConstructorTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableColElementConstructorTable = 
{
    2, 1, JSHTMLTableColElementConstructorTableEntries, 1
};

class JSHTMLTableColElementConstructor : public DOMObject {
public:
    JSHTMLTableColElementConstructor(ExecState* exec)
    {
        setPrototype(exec->lexicalInterpreter()->builtinObjectPrototype());
        putDirect(exec->propertyNames().prototype, JSHTMLTableColElementPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    JSValue* getValueProperty(ExecState*, int token) const;
    virtual const ClassInfo* classInfo() const { return &info; }
    static const ClassInfo info;

    virtual bool implementsHasInstance() const { return true; }
};

const ClassInfo JSHTMLTableColElementConstructor::info = { "HTMLTableColElementConstructor", 0, &JSHTMLTableColElementConstructorTable, 0 };

bool JSHTMLTableColElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableColElementConstructor, DOMObject>(exec, &JSHTMLTableColElementConstructorTable, this, propertyName, slot);
}

JSValue* JSHTMLTableColElementConstructor::getValueProperty(ExecState*, int token) const
{
    // The token is the numeric value of its associated constant
    return jsNumber(token);
}

/* Hash table for prototype */

static const HashEntry JSHTMLTableColElementPrototypeTableEntries[] =
{
    { 0, 0, 0, 0, 0 }
};

static const HashTable JSHTMLTableColElementPrototypeTable = 
{
    2, 1, JSHTMLTableColElementPrototypeTableEntries, 1
};

const ClassInfo JSHTMLTableColElementPrototype::info = { "HTMLTableColElementPrototype", 0, &JSHTMLTableColElementPrototypeTable, 0 };

JSObject* JSHTMLTableColElementPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLTableColElementPrototype>(exec, "[[JSHTMLTableColElement.prototype]]");
}

const ClassInfo JSHTMLTableColElement::info = { "HTMLTableColElement", &JSHTMLElement::info, &JSHTMLTableColElementTable, 0 };

JSHTMLTableColElement::JSHTMLTableColElement(ExecState* exec, HTMLTableColElement* impl)
    : JSHTMLElement(exec, impl)
{
    setPrototype(JSHTMLTableColElementPrototype::self(exec));
}

bool JSHTMLTableColElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTableColElement, JSHTMLElement>(exec, &JSHTMLTableColElementTable, this, propertyName, slot);
}

JSValue* JSHTMLTableColElement::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AlignAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        return jsString(imp->align());
    }
    case ChAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        return jsString(imp->ch());
    }
    case ChOffAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        return jsString(imp->chOff());
    }
    case SpanAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        return jsNumber(imp->span());
    }
    case VAlignAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        return jsString(imp->vAlign());
    }
    case WidthAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        return jsString(imp->width());
    }
    case ConstructorAttrNum:
        return getConstructor(exec);
    }
    return 0;
}

void JSHTMLTableColElement::put(ExecState* exec, const Identifier& propertyName, JSValue* value, int attr)
{
    lookupPut<JSHTMLTableColElement, JSHTMLElement>(exec, propertyName, value, attr, &JSHTMLTableColElementTable, this);
}

void JSHTMLTableColElement::putValueProperty(ExecState* exec, int token, JSValue* value, int /*attr*/)
{
    switch (token) {
    case AlignAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        imp->setAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ChAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        imp->setCh(valueToStringWithNullCheck(exec, value));
        break;
    }
    case ChOffAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        imp->setChOff(valueToStringWithNullCheck(exec, value));
        break;
    }
    case SpanAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        imp->setSpan(value->toInt32(exec));
        break;
    }
    case VAlignAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        imp->setVAlign(valueToStringWithNullCheck(exec, value));
        break;
    }
    case WidthAttrNum: {
        HTMLTableColElement* imp = static_cast<HTMLTableColElement*>(impl());

        imp->setWidth(valueToStringWithNullCheck(exec, value));
        break;
    }
    }
}

JSValue* JSHTMLTableColElement::getConstructor(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSHTMLTableColElementConstructor>(exec, "[[HTMLTableColElement.constructor]]");
}

}
