<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */

/**
 * RA Base Controller
 */
abstract class RaController {
/* ------------------------------------------------------------------------ */

/* -- Protected Property -- */
  /**
   * request
   * @var RaRequest
   */
  protected $request = null;
  /**
   * session
   * @var RaSession
   */
  protected $session = null;
  /**
   * message
   * @var RaMessage
   */
  protected $message = null;
  /**
   * result
   * @var RaResult
   */
  protected $result = null;
  /**
   * controller
   * @var string
   */
  protected $controller = null;
  /**
   * action
   * @var string
   */
  protected $action = null;
/* ------------------------------------------------------------------------ */

/* -- Public Method -- */
  /**
   * Constructer
   * @param RaRequest $request Request
   * @param RaSession $session Session
   * @param RaMessage $message Message
   * @param RaResult $result Result
   * @param string $controller controllerName
   * @param string $action actionName
   */
  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result, $controller, $action) {
    $this->_checkPhpVersion();
    $this->_checkPhpExtensions();
    $this->request = $request;
    $this->session = $session;
    $this->message = $message;
    $this->result = $result;
    $this->controller = $controller;
    $this->action = $action;
  }
/* ------------------------------------------------------------------------ */
  
/* -- Protected Method -- */
  /**
   * checkSession
   * @param string $key Session Key Name
   */
  protected final function checkSession($key) {
    $rtn = true;
    $this->session->reGenerateId();
    if (is_null($this->session->get($key))) $rtn = false;
    return $rtn;
  }

  /**
   * checkPost
   * @return boolean checkResult
   */
  protected final function checkPost() {
    return isset($_SERVER['REQUEST_METHOD']) && $_SERVER['REQUEST_METHOD'] != 'POST' ? false : true; 
  }

  /**
   * checkOwnPost
   * @param string $necessaryInputId Necessary InputType Id
   * @return boolean checkResult
   */
  protected final function checkOwnPost($necessaryInputId) {
    $rtn = false;
    $controller = $this->controller;
    $action = $this->action;
    $refererController = null;
    $refererAction = null;
    if ($this->checkPost()) {
      $referers = @parse_url($_SERVER['HTTP_REFERER']);
      if ($referers !== false && isset($referers['query'])) {
        $referer = $referers['query'];
        $params = explode('&', $referer);
        foreach ($params as $value) {
          $param = explode('=', $value);
          if (count($param) == 2) {
            if ($param[0] == 'controller') $refererController = $param[1];
            if ($param[0] == 'action') $refererAction = $param[1];
          }
        }
        if ((!is_null($refererController) && !is_null($refererAction)) &&
            ($refererController == $controller && $refererAction == $action)) {
          if (!is_null($this->request->get($necessaryInputId))) $rtn = true;
        }
      }
    }
    return $rtn; 
  }

  /**
   * checkRedirect
   * @return boolean checkResult
   */
  protected final function checkRedirect() {
    return $this->request->get('controller') != $this->controller || $this->request->get('action') != $this->action ? true : false; 
  }

  /**
   * checkRequest
   * @param array or string $keys Request Key Name
   * @return boolean checkResult
   */
  protected final function checkRequest($keys) {
    $rtn = true;
    $request = $this->request;
    if (is_array($keys)) {
      foreach($keys as $key) {
        if (is_null($request->get($key))) {
          $rtn = false;
          break;
        }
      }
    }
    if (is_string($keys)) if (is_null($request->get($keys))) $rtn = false;
    return $rtn; 
  }
/* ------------------------------------------------------------------------ */

/* -- Private Method -- */
  /**
   * _checkPhpVersion
   * @return boolean checkResult
   */
  private function _checkPhpVersion() {
    if (RaUtil::versionComparePhp(PHP_VERSION, RaConfig::SUPPORT_PHPVERSION, '<'))
      throw new RaException(RaConfig::PHP_NOTSUPPORT_VERSION_ERR_MSG. ' => '. PHP_VERSION, RaConfig::PHP_NOTSUPPORT_VERSION_ERR_CODE, true);     
  }

  /**
   * _checkPhpExtensions
   * @return boolean checkResult
   */
  private function _checkPhpExtensions() {
    $check = true;
    $extensionString = '';
    $loadExtensions = get_loaded_extensions();
    $phpExtensions = RaConfig::$phpExtensions;
    foreach ($phpExtensions as $phpExtension) {
      if (!in_array($phpExtension, $loadExtensions)) {
        $extensionString .= $phpExtension. ',';
        $check = false;
      }
    }
    if (!$check) throw new RaException(RaConfig::PHP_EXTENSION_NOTFOUND_ERR_MSG. ' => '. substr($extensionString, 0, strlen($extensionString) - 1),
                                                  RaConfig::PHP_EXTENSION_NOTFOUND_ERR_CODE,
                                                  true);     
  }
/* ------------------------------------------------------------------------ */

}
?>
