<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class ResearchController extends BaseController {

  private $_yyyyFrom = null;
  private $_mmFrom = null;
  private $_ddFrom = null;
  private $_yyyyTo = null;
  private $_mmTo = null;
  private $_ddTo = null;

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
    if (!is_null($this->session->get('yyyyFrom'))) $this->_yyyyFrom = $this->session->get('yyyyFrom');
    if (!is_null($this->session->get('mmFrom'))) $this->_mmFrom = $this->session->get('mmFrom');
    if (!is_null($this->session->get('ddFrom'))) $this->_ddFrom = $this->session->get('ddFrom');
    if (!is_null($this->session->get('yyyyTo'))) $this->_yyyyTo = $this->session->get('yyyyTo');
    if (!is_null($this->session->get('mmTo'))) $this->_mmTo = $this->session->get('mmTo');
    if (!is_null($this->session->get('ddTo'))) $this->_ddTo = $this->session->get('ddTo');
    if (SystemUtil::checkPhpMemoryLimit()) {
      $title = new Title();
      $titleData = $title->findAll();
    } else {
      $titleData = array();
    }
    $this->result->set('titleData', $titleData);
  }

  public function brow() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND browser <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND browser LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function brow_ver() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND brow_ver LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $conditions[0] .= ' AND browser = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function brow_user() {
    $this->checkUrl(array('select', 'browser'));
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND brow_ver = ?';
    array_push($conditions, $this->request->get('select'));
    $conditions[0] .= ' AND browser = ?';
    array_push($conditions, $this->request->get('browser'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function btnrank() {
    $conditions = $this->_initConditions(Config::CLICK_BTN);
    $conditions[0] .= ' AND url <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND url LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function btnrank_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::CLICK_BTN);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND url = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function clickrank() {
    $conditions = $this->_initConditions(Config::CLICK_LINK);
    $conditions[0] .= ' AND url <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND url LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function clickrank_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::CLICK_LINK);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND url = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsenseip() {
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    $conditions[0] .= ' AND remote_addr <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND remote_addr LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsenseip_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND remote_addr = ?';
    array_push($conditions, $this->request->get('select'));
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND uid LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsenserank() {
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    $conditions[0] .= ' AND title <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsenserank_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND title = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsensepagerank() {
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    $conditions[0] .= ' AND referer_title <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND referer_title LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function adsensepagerank_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND referer_title = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND referer_title = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function host() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND referer_host <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND referer_host <> ?';
    array_push($conditions, Config::FROM_BOOKMARK);
    $conditions[0] .= ' AND engine = ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND referer_host LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function host_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND referer_host = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function referer() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND referer_title <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND engine = ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND referer_host <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND referer_title LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function referer_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND referer_title = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function crawler() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND crawler <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND crawler LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function crawler_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND crawler = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function key() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND keyword <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND keyword LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function key_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND keyword = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function os() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND os <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND os LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function os_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND os = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function pagein() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND url <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('search'));
  }

  public function pagein_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('select'));
  }

  public function pageout() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND url <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('search'));
  }

  public function pageout_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('select'));
  }

  public function ip() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND remote_addr <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND remote_addr LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function ip_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND remote_addr = ?';
    array_push($conditions, $this->request->get('select'));
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND uid LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function remotehost() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND remote_host <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND remote_host <> ?';
    array_push($conditions, Config::NO_DATA);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND remote_host LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function remotehost_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND remote_host = ?';
    array_push($conditions, $this->request->get('select'));
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND uid LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function domain() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND domain <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND domain <> ?';
    array_push($conditions, Config::NO_DATA);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND domain LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function domain_user() {
    $this->checkUrl('select');
    if (!is_null($this->request->get('logtype'))) {
      $conditions = $this->_initConditions(Config::CLICK_ADSENSE);
    } else {
      $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    }
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND domain = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function jpdomain() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND jpdomain <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND jpdomain LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function jpdomain_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND jpdomain = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function pref() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND pref <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND pref <> ?';
    array_push($conditions, Config::NO_DATA);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND pref LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function pref_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND pref = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function country() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND country <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND country <> ?';
    array_push($conditions, Config::NO_DATA);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND country LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function country_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND country = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function rank() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND url <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND url LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function rank_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND url = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function rate() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function rate_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('select'));
  }

  public function screencol() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND screencol <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function screencol_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND screencol = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function screenwh() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND screenwh <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function screenwh_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND screenwh = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function jsck() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND jsck <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function jsck_user() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND jsck = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function term() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions);
  }

  public function time() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions);
  }

  public function time_detail() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions();
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions, $this->request->get('select'));
  }

  public function uid() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND uid LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function uid_detail() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions();
    $conditions[0] .= ' AND uid = ?';
    array_push($conditions, $this->request->get('select'));
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions, $this->request->get('select'));
  }

  public function week() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions);
  }

  public function word() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND keyword <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND keyword LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions, $this->request->get('search'));
  }

  public function engine() {
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND engine <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    if (!is_null($this->request->get('search'))) {
      $conditions[0] .= ' AND engine LIKE ?';
      array_push($conditions, '%' . $this->request->get('search') . '%');
    }
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function engine_key() {
    $this->checkUrl('select');
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    $conditions[0] .= ' AND engine <> ?';
    array_push($conditions, '');
    $conditions[0] .= ' AND keyword <> ?';
    array_push($conditions, '');
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND engine = ?';
    array_push($conditions, $this->request->get('select'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function engine_user() {
    $this->checkUrl(array('select', 'engine'));
    $conditions = $this->_initConditions(Config::NORMAL_ACCESS);
    if (!is_null($this->session->get('selectPage'))) {
      $conditions[0] .= ' AND url = ?';
      array_push($conditions, $this->session->get('selectPage'));
    }
    $conditions[0] .= ' AND keyword = ?';
    array_push($conditions, $this->request->get('select'));
    $conditions[0] .= ' AND engine = ?';
    array_push($conditions, $this->request->get('engine'));
    $findOptions = array('condition' => $conditions);
    return $this->_doResearch($findOptions);
  }

  public function download() {
    return $this->result;
  }

  public function log() {
    $result = $this->result;
    if (!$this->checkPost()) {
      $result->setNextController('research');
      $result->setNextAction('download');
      return $result;
    }
    if (!$this->checkParamYyyyMmDd($this->request->get('yyyy_from'), $this->request->get('mm_from'), $this->request->get('dd_from'),
                                   $this->request->get('yyyy_to'), $this->request->get('mm_to'), $this->request->get('dd_to'))) {
      $this->message->setMessage('期間を正しく設定してください。');
      $result->setNextController('research');
      $result->setNextAction('download');
      return $result;
    }
    if (is_null($this->request->get('charset'))) {
      $this->message->setMessage('文字コードを選択してください。');
      $result->setNextController('research');
      $result->setNextAction('download');
      return $result;
    }
    $result->setCharset($this->request->get('charset'));
    $conditions = $this->_initConditions();
    $order = 'dd ASC, hh ASC, mi ASC, ss ASC';
    $findOptions = array('condition' => $conditions, 'order' => $order);
    return $this->_doResearch($findOptions);
  }

  public function sendmail() {
    $result = $this->result;

    $id = $this->session->get('login');

    $mail = new Mail();
    $mailData = $mail->find(array('condition' => array('site_id = ?', $id)));
    $result->set('mailData', $mailData);

    if (!$this->checkPost()) {
      return $result;
    }

    $mailview = $this->request->get('mailview');
    $email_from = $this->request->get('email_from');
    $email_from = $this->request->get('email_from');
    $emails_to = $this->request->get('emails_to');
    $smtp = $this->request->get('smtp');
    $port = $this->request->get('port');
    $userid = $this->request->get('userid');
    $pswd = $this->request->get('pswd');
    if (!$this->checkParamYyyyMmDd($this->request->get('yyyy_from'), $this->request->get('mm_from'), $this->request->get('dd_from'),
                                   $this->request->get('yyyy_to'), $this->request->get('mm_to'), $this->request->get('dd_to'))) {
      $this->message->setMessage('期間を正しく設定してください。');
      return $result;
    }
    if (trim($emails_to) == '') {
      $this->message->setMessage('メールアドレス (to)を入力してください。');
      return $result;
    } 
    if (RaUtil::strLen($emails_to) > 255) {
      $this->message->setMessage('メールアドレス (to)は255文字以内で入力してください。');
      return $result;
    } 
    $toErr = false;
    if (strpos($emails_to, ',') !== false) {
      $emails = explode(',', $emails_to);
      if (is_array($emails)) {
        foreach ($emails as $email) {
          if (!Track::checkEmail($email)) {
            $toErr = true;
            break;
          } 
        }
      }
    } else {
      if (!Track::checkEmail($emails_to)) {
        $toErr = true;
      } 
    }
    if ($toErr) {
      $this->message->setMessage('メールアドレス (to)は、&quot;〜@〜&quot;の形で正しく入力してください。');
      return $result;
    } 
    if (trim($email_from) == '') {
      $this->message->setMessage('メールアドレス (from)を入力してください。');
      return $result;
    } 
    if (RaUtil::strLen($email_from) > 255) {
      $this->message->setMessage('メールアドレス (from)は255文字以内で入力してください。');
      return $result;
    } 
    if (!Track::checkEmail($email_from)) {
      $this->message->setMessage('メールアドレス (from)は、&quot;〜@〜&quot;の形で正しく入力してください。');
      return $result;
    } 
    if (trim($smtp) == '') {
      $this->message->setMessage('SMTPサーバー名を入力してください。');
      return $result;
    } 
    if (RaUtil::strLen($smtp) > 255) {
      $this->message->setMessage('SMTPサーバー名は255文字以内で入力してください。');
      return $result;
    } 
    if (trim($port) == '') {
      $this->message->setMessage('SMTPポート番号を入力してください。');
      return $result;
    } 
    if (RaUtil::strLen($port) > 5) {
      $this->message->setMessage('SMTPポート番号は5文字以内で入力してください。');
      return $result;
    } 
    if (!preg_match('/^[0-9]*$/', $port)) {
      $this->message->setMessage('SMTPポート番号は半角数字で入力してください。');
      return $result;
    } 
    if (trim($pswd) != '') {
      if (trim($userid) == '') {
        $this->message->setMessage('SMTP認証を使用する場合は、認証用のユーザーIDを入力してください。');
        return $result;
      } 
      if (RaUtil::strLen($userid) > 255) {
        $this->message->setMessage('ユーザーIDは255文字以内で入力してください。');
        return $result;
      } 
    } 
    if (trim($userid) != '') {
      if (trim($pswd) == '') {
        $this->message->setMessage('SMTP認証を使用する場合は、認証用のパスワードを入力してください。');
        return $result;
      } 
      if (RaUtil::strLen($pswd) > 255) {
        $this->message->setMessage('パスワードは255文字以内で入力してください。');
        return $result;
      } 
    } 

    $mail->setValue('site_id', $id);
    $mail->setValue('mailview', $mailview);
    $mail->setValue('email_from', $email_from);
    $mail->setValue('emails_to', $emails_to);
    $mail->setValue('smtp', $smtp);
    $mail->setValue('port', $port);
    $mail->setValue('userid', $userid);
    $mail->setValue('pswd', $pswd);
    $mail->save();

    $site = new Site();
    $site->find(array('condition' => array('id = ?', $id)));

    if ($this->_sendMail($mail, $site)) {
      $this->setNormalMessage('メールを送信しました。');
    } else {
      $this->message->setMessage('メール送信に失敗しました。入力内容を確認してください。<br />エラーの詳細は以下のアプリケーションログファイルを確認してください。<br />'. RaLog::getFilePath());
    }

    $mail = new Mail();
    $mailData = $mail->find(array('condition' => array('site_id = ?', $id)));
    $result->set('mailData', $mailData);

    return $result;
  }

  public function dailymail() {
    $result = $this->result;
    $result->setLayout(null);

    if (RaUtil::isHttp()) {
      $result->setNextController('research');
      $result->setNextAction('sendmail');
      return $result;
    }

    $yyyyMmDd = Calendar::getNextDate(-1);
    $yyyyFrom = substr($yyyyMmDd, 0, 4);
    $mmFrom = substr($yyyyMmDd, 4, 2);
    $ddFrom = substr($yyyyMmDd, 6, 4);
    $result = $this->_cronMail($yyyyFrom, $mmFrom, $ddFrom, $yyyyFrom, $mmFrom, $ddFrom);

    return $result;
  }

  public function monthlymail() {
    $result = $this->result;
    $result->setLayout(null);

    if (RaUtil::isHttp()) {
      $result->setNextController('research');
      $result->setNextAction('sendmail');
      return $result;
    }

    $yyyyMm = Calendar::getNextMonth(-1);
    $yyyyFrom = substr($yyyyMm, 0, 4);
    $mmFrom = substr($yyyyMm, 4, 2);
    $ddFrom = '01';
    $yyyyTo = $yyyyFrom;
    $mmTo = $mmFrom;
    $ddTo = strval(Calendar::getLastDay($yyyyFrom, $mmFrom));
    $result = $this->_cronMail($yyyyFrom, $mmFrom, $ddFrom, $yyyyTo, $mmTo, $ddTo);

    return $result;
  }

  public function specifiedmail() {
    $result = $this->result;
    $result->setLayout(null);

    if (RaUtil::isHttp()) {
      $result->setNextController('research');
      $result->setNextAction('sendmail');
      return $result;
    }

    $request = $this->request;
    $ymdFrom = $request->get('0');
    $ymdTo = $request->get('1');
    $yyyyFrom = substr($ymdFrom, 0, 4);
    $mmFrom = substr($ymdFrom, 4, 2);
    $ddFrom = substr($ymdFrom, 6, 2);
    $yyyyTo = substr($ymdTo, 0, 4);
    $mmTo = substr($ymdTo, 4, 2);
    $ddTo = substr($ymdTo, 6, 2);
    if ((is_null($yyyyFrom) || trim($yyyyFrom) == '') ||
        (is_null($mmFrom) || trim($mmFrom) == '') ||
        (is_null($ddFrom) || trim($ddFrom) == '') ||
        (is_null($yyyyTo) || trim($yyyyTo) == '') ||
        (is_null($mmTo) || trim($mmTo) == '') ||
        (is_null($ddTo) || trim($ddTo) == '')) {
      $errMsg = 'パラメータの指定に誤りがあります。:'. 
                ' yyyyFrom='. $yyyyFrom.
                ' mmFrom='. $mmFrom.
                ' ddFrom='. $ddFrom.
                ' yyyyTo='. $yyyyTo.
                ' mmTo='. $mmTo.
                ' ddTo='. $ddTo;
      $this->message->setMessage($errMsg. Mailer::NEWLINE);
      RaLog::write($errMsg, RaLog::LEVEL_FATAL);
      return $result;
    }
    $result = $this->_cronMail($yyyyFrom, $mmFrom, $ddFrom, $yyyyTo, $mmTo, $ddTo);

    return $result;
  }

  private function _initConditions($logtype = null) {
    $conditions = array('');
    if (!is_null($logtype)) {
      $conditions[0] .= ' AND logtype = ?';
      array_push($conditions, $logtype);
    }
    if (!is_null($this->session->get('selectUid'))) {
      $conditions[0] .= ' AND uid = ?';
      array_push($conditions, $this->session->get('selectUid'));
    }
    $conditions = $this->_checkNoCrawler($conditions);
    $conditions = $this->_checkfilter($this->_getFilters(), $conditions);
    return $conditions;
  }

  private function _getFilters() {
    $siteData = $this->session->get('siteData');
    $filter = $siteData['filter'];
    if (strlen(trim($filter)) == 0) return null;
    $filter = File::replaceCrlf($filter, "/r");
    return explode("/r" , $filter);
  }

  private function _checkfilter($filters, $conditions) {
    if (is_array($filters)) {
      foreach ($filters as $filter) {
        if (trim($filter) <> '') {
          $conditions[0] .= ' AND (';
          $conditions[0] .= ' remote_host NOT LIKE ?';
          array_push($conditions, '%' . $filter . '%');
          $conditions[0] .= ' AND';
          $conditions[0] .= ' remote_addr NOT LIKE ?';
          array_push($conditions, '%' . $filter . '%');
          $conditions[0] .= ' )';
        }
      }
    }
    return $conditions; 
  }

  private function _checkNoCrawler($conditions) {
    $id = !is_null($this->session->get('login')) ? $this->session->get('login') : Config::SYSTEM_DEFAULT_ID;
    $site = new Site();
    $site->find(array('condition' => array('id = ?', $id)));
    $nocrawler = $site->getValue('nocrawler');
    if ($nocrawler == Config::ON) {
      $conditions[0] .= ' AND crawler = \'\'';
    }
    return $conditions; 
  }

  private function _doResearch($findOptions, $compareValue=null) {
    $dbg = debug_backtrace();
    $method = $dbg[1]['function'];
    $yyyyFrom = $this->_yyyyFrom;
    $mmFrom = $this->_mmFrom;
    $ddFrom = $this->_ddFrom;
    $yyyyTo = $this->_yyyyTo;
    $mmTo = $this->_mmTo;
    $ddTo = $this->_ddTo;
    $yyyyMmOptions = array('yyyyFrom' => $yyyyFrom,
                           'mmFrom' => $mmFrom,
                           'ddFrom' => $ddFrom,
                           'yyyyTo' => $yyyyTo,
                           'mmTo' => $mmTo,
                           'ddTo' => $ddTo);
    $now = $_SERVER['REQUEST_TIME'];
    $yyyy = date('Y', $now);
    $mm = date('m', $now);
    if ($yyyyFrom. $mmFrom == $yyyy. $mm ||
        $yyyyFrom. $mmFrom == Calendar::getNextMonth(1)) {
      $log = new Log();
    } else {
      $log = new Log(true);
    }
    $log->setKeys();
    $results = $log->findSummary($findOptions, $method, $yyyyMmOptions, $compareValue);
    $result = $this->result;
    foreach($results as $k => $v) {
      $result->set($k, $v);
    }
    return $result;
  }

  private function _sendMail(Mail $mail, Site $site) {
    $subject = '';
    $mailBody = '';
    $result = null;

    $mailview = $mail->getValue('mailview');
    $email_from = $mail->getValue('email_from');
    $emails_to = $mail->getValue('emails_to');
    $smtp = $mail->getValue('smtp');
    $port = $mail->getValue('port');
    $userid = $mail->getValue('userid');
    $pswd = $mail->getValue('pswd');

    if (SystemUtil::checkPhpMemoryLimit()) {
      $alias = new Alias();
      $aliasData = $alias->findAll();
      $domain = new domain();
      $domainData = $domain->findAll();
    } else {
      $aliasData = array();
      $domainData = array();
    }
    $this->result->set('aliasData', $aliasData);
    $this->result->set('domainData', $domainData);

    $yyyyFrom = $this->_yyyyFrom;
    $mmFrom = $this->_mmFrom;
    $ddFrom = $this->_ddFrom;
    $yyyyTo = $this->_yyyyTo;
    $mmTo = $this->_mmTo;
    $ddTo = $this->_ddTo;

    $term =  $yyyyFrom. $mmFrom. $ddFrom != $yyyyTo. $mmTo. $ddTo ? true : false;

    if (!$term) {
      $ymd = $yyyyFrom. '年'. $mmFrom. '月'. $ddFrom. '日';
    } else {
      $ymd = $yyyyFrom. '年'. $mmFrom. '月'. $ddFrom. '日'. ' 〜 ';
      $ymd .= $yyyyTo. '年'. $mmTo. '月'. $ddTo. '日';
    }
    $subject .= $ymd. 'のサイトアクセス状況 : '. RaConfig::RA_NAME;

    $mailBody .= $ymd . 'の「' . $site->getValue('sitename') .  '」のアクセス状況をお知らせします。'. Mailer::NEWLINE. Mailer::NEWLINE;

    $mailBody .= '●サイト名: '. $site->getValue('sitename'). Mailer::NEWLINE;
    $mailBody .= '●URL: '. $site->getValue('url'). Mailer::NEWLINE. Mailer::NEWLINE;

    foreach (MenuConfig::$sendMailActions as $action) {
      if (method_exists($this, $action)) {
        $mailBody .= $this->_getMailBody($this->$action(), $mailview, $action, $term);
      } else {
        throw new RaException('Undefined This Method => '. $action. ' In MenuConfig::$sendMailActions');
      }
    } 

    $mailBody .= '--'. Mailer::NEWLINE;
    $mailBody .= RaConfig::RA_NAME. Mailer::NEWLINE;
    $mailBody .= RaConfig::RA_URL. Mailer::NEWLINE;

    $sendMail = new Mailer($smtp, $port, $userid, $pswd);
    return $sendMail->send($email_from, $emails_to, $subject, $mailBody);

  }

  private function _getMailBody(RaResult $result, $mailview, $action, $term) {
    $i = 0;
    $mailBody = '';

    $summaryData = $result->get('summaryData');
    $uniqueData = $result->get('uniqueData');
    $totalData = $result->get('totalData');
    $uniqueCount = $result->get('uniqueCount');
    $totalCount = $result->get('totalCount');

    $titleData = $result->get('titleData');
    $aliasData = $result->get('aliasData');
    $domainData = $result->get('domainData');

    if ($action == 'time') {
      $mailBody .= '◆ユニークアクセス総数: ' . number_format($uniqueCount) . 'pv'. Mailer::NEWLINE;
      $mailBody .= '◆アクセス総数: ' . number_format($totalCount) . 'pv'. Mailer::NEWLINE. Mailer::NEWLINE;
    }

    foreach(MenuConfig::$titles as $titles) {
      foreach ($titles as $key => $value) {
        if ($action == 'week' && !$term) continue; 
        if ($key == $action) {
          $mailBody .= '■'. $value;
          if ($key == 'time' || $key == 'week') $mailBody .= '（ユニークアクセス数, アクセス数）'; 
          $mailBody .= Mailer::NEWLINE;
          break; 
        }
      }
    }
    switch ($action) {
      case 'time' :
        for ($i = 0; $i <= 23; $i++) {
          $uCnt = 0;
          $tCnt = 0;
          if (isset($uniqueData[$i])) $uCnt = $uniqueData[$i];
          if (isset($totalData[$i])) $tCnt = $totalData[$i];
          $mailBody .= $i . '時 -> ' . number_format($uCnt) . 'pv,  ' . number_format($tCnt) . 'pv'. Mailer::NEWLINE;
        }
        break;
      case 'week' :
        if ($term) {
          for ($i = 0; $i <= 6; $i++) {
            $uCnt = 0;
            $tCnt = 0;
            if (isset($uniqueData[$i])) $uCnt = $uniqueData[$i];
            if (isset($totalData[$i])) $tCnt = $totalData[$i];
            $mailBody .= Calendar::getWeekday($i) . ' -> ' . number_format($uCnt) . 'pv,  ' . number_format($tCnt) . 'pv'. Mailer::NEWLINE;
          }
        }
        break;
      default :
        foreach ($summaryData as $key => $value) {
          $mailBody .= number_format($value) . 'pv -> ';
          switch ($action) {
            case 'rank' :
            case 'pagein':
            case 'pageout':
            case 'adsensepagerank':
            case 'btnrank':
            case 'clickrank':
              $mailBody .= $this->_getValue($titleData, $key, 'url', 'title');
              break;
            case 'uid' :
              $mailBody .= $this->_getValue($aliasData, $key, 'uid', 'name');
              break;
            case 'domain' :
            case 'jpdomain' :
              $mailBody .= $this->_getValue($domainData, $key, 'domain', 'name');
              break;
            default :
              $mailBody .= $key;
              break;
          }
          $mailBody .= '（' . round($value * 100 / $totalCount, 2) . '%）'. Mailer::NEWLINE;
          $i++;
          if ($i == $mailview) break;
        }
        break;
    }
    $mailBody .= Mailer::NEWLINE;

    return $mailBody;
  }

  private function _getValue($data, $key, $compColumn, $getColumn) {
    $rtn = $key;
    if (is_array($data)) {
      foreach($data as $value) {
        if ($value[$compColumn]==$key) {
          $rtn = $value[$getColumn];
          break;
        }
      }
    }
    return $rtn;
  }

  private function _cronMail($yyyyFrom, $mmFrom, $ddFrom, $yyyyTo, $mmTo, $ddTo) {
    $result = $this->result;

    $site = new Site();
    $site->find(array('order' => 'id DESC'));
    $id = $site->getValue('id');
    $mail = new Mail();
    $mail->find(array('condition' => array('site_id = ?', $id)));
    if ($this->_checkMailSetting($mail) == false) {
      return $result;
    }

    $this->_yyyyFrom = $yyyyFrom;
    $this->_mmFrom = $mmFrom;
    $this->_ddFrom = $ddFrom;
    $this->_yyyyTo = $yyyyTo;
    $this->_mmTo = $mmTo;
    $this->_ddTo = $ddTo;

    if ($this->_sendMail($mail, $site)) {
      $this->message->setMessage('メールを送信しました。'. RaLog::NEWLINE);
    } else {
      $this->message->setMessage('メール送信に失敗しました。エラーの詳細は以下のアプリケーションログファイルを確認してください。'. RaLog::NEWLINE. RaLog::getFilePath(). Mailer::NEWLINE);
    }

    return $result;
  }

  private function _checkMailSetting(Mail $mail) {
    $rtn = true;
    $checkValues = array();
    array_push($checkValues, $mail->getValue('email_from'));
    array_push($checkValues, $mail->getValue('emails_to'));
    array_push($checkValues, $mail->getValue('smtp'));
    array_push($checkValues, $mail->getValue('port'));
    foreach ($checkValues as $value) {
      if (is_null($value) || trim($value) == '') {
        $rtn = false;
        break;
      }
    }
    if (!$rtn) {
      $errMsg = 'メール送信画面でメール設定を行ってください。';
      $this->message->setMessage($errMsg. RaLog::NEWLINE);
      RaLog::write($errMsg, RaLog::LEVEL_FATAL);
    }
    return $rtn;
  }

}
?>
