<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class Log extends RaModel {

  private $_options = array();

  private $_uniqueCount = 0;
  private $_totalCount = 0;
  private $_clickLinkCount = 0;
  private $_clickBtnCount = 0;
  private $_clickAdsenseCount = 0;

  private $_summaryData = array();
  private $_uniqueData = array();
  private $_totalData = array();
  private $_textData = '';

  private $_remoteAddr = array();
  private $_remoteHost = array();
  private $_domain = array();
  private $_pref = array();
  private $_country = array();
  private $_os = array();
  private $_browser = array();
  private $_clickLink = array();
  private $_clickBtn = array();
  private $_clickAdsense = array();
  private $_keywordEngine = array();

  private $_compareValue = null;

  private $_forExtractData = array();
  private $_workData = array();
  private $_backupData = array();

  public function __construct($noCreate=false, $yyyymm=null) {
    if (is_null($yyyymm)) {
      $now = $_SERVER['REQUEST_TIME'];
      $yyyymm = date('Y', $now). date('m', $now);
    }
    parent::__construct(strtolower(__CLASS__) . '_' . $yyyymm, $noCreate, strtolower(__CLASS__));
  }

  public function __destruct() {
    parent::__destruct();
  }

  public function setKeys() {
    $this->setKey('yyyy');
    $this->setKey('mm');
    $this->setKey('newflg');
  }

  public function findSummary($options, $method, $yyyyMmOptions, $compareValue=null) {

    $this->_options = $options;
    $this->_compareValue = $compareValue;
    $terms = $this->_getTerms($yyyyMmOptions['yyyyFrom'], $yyyyMmOptions['mmFrom'], $yyyyMmOptions['ddFrom'], 
                              $yyyyMmOptions['yyyyTo'], $yyyyMmOptions['mmTo'], $yyyyMmOptions['ddTo']);
    foreach($terms as $term) {
      $this->setTable(strtolower(__CLASS__) . '_' . $term['yyyy'] . $this->_getFormatMmDd($term['mm']));
      try {
        $options = $this->_options;
        $conditions = array();
        array_push($conditions, 'dd >= ? AND dd <= ?'. $options['condition'][0]);
        array_push($conditions, $term['ddFrom']);
        array_push($conditions, $term['ddTo']);
        foreach($options['condition'] as $key => $value) {
          if ($key != 0)  array_push($conditions, $value);
        }
        $options['condition'] = $conditions;
        $rs = $this->findQuery($options);
        while ($row = $this->fetchRow($rs)) {
          $this->clearData();
          $data = $this->getData();
          foreach($data as $column => $value) {
            if (isset($row[$column])) $this->setValue($column, $row[$column]);
          }
          $this->setValue('yyyy', $term['yyyy']);
          $this->setValue('mm', $term['mm']);
          $function = '_'. $method;
          if (method_exists($this, $function)) {
            $this->$function();
          }
        }
        $this->freeResult($rs);
      } catch (Exception $ex) {
        if ($ex->getCode() == RaConfig::CONTINUE_ERR_CODE ||
            $ex->getCode() == RaModel::TABLE_NOTFOUND_ERR_CODE) {
          continue;
        } else {
          throw $ex;
        }
      }
    }

    $function = '_' . $method . 'After';
    if (method_exists($this, $function)) {
      $this->$function();
    }

    switch($method) {
    case 'time':
    case 'term':
    case 'week':
    case 'log':
      break;
    case 'time_detail':
    case 'uid_detail':
      krsort($this->_summaryData, SORT_STRING);
      break;
    case 'rate':
      array_multisort($this->_summaryData, SORT_DESC, SORT_NUMERIC,  $this->_forExtractData, SORT_DESC, SORT_NUMERIC);
      break;
    default:
      array_multisort($this->_summaryData, SORT_DESC, SORT_NUMERIC,  $this->_forExtractData, SORT_ASC, SORT_STRING);
      break;
    }

    $results = array();

    $results['uniqueCount'] = $this->_uniqueCount;
    $results['totalCount'] = $this->_totalCount;
    $results['clickLinkCount'] = $this->_clickLinkCount;
    $results['clickBtnCount'] = $this->_clickBtnCount;
    $results['clickAdsenseCount'] = $this->_clickAdsenseCount;

    $results['summaryData'] = $this->_summaryData;
    $results['uniqueData'] = $this->_uniqueData;
    $results['totalData'] = $this->_totalData;
    $results['textData'] = $this->_textData;

    $results['remoteAddr'] = $this->_remoteAddr;
    $results['remoteHost'] = $this->_remoteHost;
    $results['domain'] = $this->_domain;
    $results['pref'] = $this->_pref;
    $results['country'] = $this->_country;
    $results['os'] = $this->_os;
    $results['browser'] = $this->_browser;
    $results['clickLink'] = $this->_clickLink;
    $results['clickBtn'] = $this->_clickBtn;
    $results['clickAdsense'] = $this->_clickAdsense;
    $results['keywordEngine'] = $this->_keywordEngine;

    return $results;
  }

  private function _brow() {
    $this->_extractData($this->getValue('browser'));
  }

  private function _brow_ver() {
    $this->_extractData($this->getValue('brow_ver'));
  }

  private function _brow_user() {
    $this->_extractUidData();
  }

  private function _btnrank() {
    $this->_extractData($this->getValue('url'));
  }

  private function _btnrank_user() {
    $this->_extractUidData();
  }

  private function _clickrank() {
    $this->_extractData($this->getValue('url'));
  }

  private function _clickrank_user() {
    $this->_extractUidData();
  }

  private function _adsenseip() {
    $key = $this->getValue('remote_addr');
    $this->_extractData($key);
    if (!isset($this->_remoteHost[$key])) $this->_remoteHost[$key] = $this->getValue('remote_host');
    if (!isset($this->_domain[$key])) $this->_domain[$key] = $this->getValue('domain');
  }

  private function _adsenseip_user() {
    $this->_extractUidData();
  }

  private function _adsenserank() {
    $this->_extractData($this->getValue('title'));
  }

  private function _adsenserank_user() {
    $this->_extractUidData();
  }

  private function _adsensepagerank() {
    $this->_extractData($this->getValue('referer_title'));
  }

  private function _adsensepagerank_user() {
    $this->_extractUidData();
  }

  private function _host() {
    $this->_extractData($this->getValue('referer_host'));
  }

  private function _host_user() {
    $this->_extractUidData();
  }

  private function _referer() {
    $this->_extractData($this->getValue('referer_title'));
  }

  private function _referer_user() {
    $this->_extractUidData();
  }

  private function _crawler() {
    $this->_extractData($this->getValue('crawler'));
  }

  private function _crawler_user() {
    $this->_extractUidData();
  }

  private function _key() {
    $key1 = $this->getValue('keyword');
    $key2 = $this->getValue('engine');
    if (is_numeric($key1)) $key1 .= ' ';
    if (is_numeric($key2)) $key2 .= ' ';
    $this->_extractData($key1);
    if (trim($key1) != '' && trim($key2) != '') {
      if (!isset($this->_keywordEngine[$key1][$key2])) {
        $this->_keywordEngine[$key1][$key2] = 1;
      } else {
        ++$this->_keywordEngine[$key1][$key2];
      }
    }
  }

  private function _key_user() {
    $this->_extractUidData();
  }

  private function _os() {
    $this->_extractData($this->getValue('os'));
  }

  private function _os_user() {
    $this->_extractUidData();
  }

  private function _pagein() {
    $key = $this->getValue('uid') . $this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd');
    $url = $this->getValue('url');
    if (trim($this->_compareValue) != '') 
      if (strpos(RaUtil::strToLower($url), RaUtil::strToLower($this->_compareValue)) === false) 
        return;	
    if (!isset($this->_workData[$key])) {
      $this->_workData[$key] = true;
      $this->_extractData($url);
    }
  }

  private function _pagein_user() {
    $key = $this->getValue('uid') . $this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd');
    if (!isset($this->_workData[$key])) {
      $this->_workData[$key] = true;
      if ($this->getValue('url') == $this->_compareValue) {
        $this->_extractUidData();
      }
    }
  }

  private function _pageout() {
    $key = $this->getValue('uid') . $this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd');
    $url = $this->getValue('url');
    if (trim($this->_compareValue) != '') 
      if (strpos(RaUtil::strToLower($url), RaUtil::strToLower($this->_compareValue)) === false) 
        return;	
    if (!isset($this->_workData[$key])) {
      $this->_workData[$key] = true;
      $this->_backupData[$key] = $url;
      $this->_extractData($url);
    } else {
      $url = $this->_backupData[$key];
      $this->_unsetExtractData($url);
      $this->_backupData[$key] = $this->getValue('url');
      $this->_extractData($this->getValue('url'));
    }
  }

  private function _pageout_user() {
    $key = $this->getValue('uid') . $this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd');
    if (!isset($this->_workData[$key])) {
      $this->_workData[$key] = true;
      if ($this->getValue('url') == $this->_compareValue) {
        $this->_backupData[$key] = $this->getValue('uid');
        $this->_extractUidData();
      }
    } else {
      if ($this->getValue('url') == $this->_compareValue) {
        if (!isset($this->_backupData[$key])) {
          $this->_backupData[$key] = $this->getValue('uid');
          $this->_extractUidData();
        }
      } else {
        if (isset($this->_backupData[$key])) {
          $uid = $this->_backupData[$key];
          $this->_unsetExtractUidData();
          unset($this->_backupData[$key]);
        }
      }
    }
  }

  private function _ip() {
    $key = $this->getValue('remote_addr');
    $this->_extractData($key);
    if (!isset($this->_remoteHost[$key])) $this->_remoteHost[$key] = $this->getValue('remote_host');
    if (!isset($this->_domain[$key])) $this->_domain[$key] = $this->getValue('domain');
  }

  private function _ip_user() {
    $this->_extractUidData();
    $key = $this->getValue('uid');
    if (!isset($this->_domain[$key])) $this->_domain[$key] = $this->getValue('domain');
    if (!isset($this->_clickLink[$key])) $this->_clickLink[$key] = 0;
    if (!isset($this->_clickBtn[$key])) $this->_clickBtn[$key] = 0;
    if (!isset($this->_clickAdsense[$key])) $this->_clickAdsense[$key] = 0;
    switch($this->getValue('logtype')) {
    case Config::CLICK_LINK:
      ++$this->_clickLink[$key];
      break;
    case Config::CLICK_BTN:
      ++$this->_clickBtn[$key];
      break;
    case Config::CLICK_ADSENSE:
      ++$this->_clickAdsense[$key];
      break;
    }
    if ($this->getValue('logtype') != Config::NORMAL_ACCESS) {
      --$this->_summaryData[$key];
      --$this->_allCount;
      if (!isset($this->_forExtractData[$key])) {
        --$this->_count;
      }
    }
  }

  private function _remotehost() {
    $key = $this->getValue('remote_host');
    $this->_extractData($key);
    if (!isset($this->_remoteAddr[$key])) $this->_remoteAddr[$key] = $this->getValue('remote_addr');
    if (!isset($this->_domain[$key])) $this->_domain[$key] = $this->getValue('domain');
  }

  private function _remotehost_user() {
    $this->_extractUidData();
    $key = $this->getValue('uid');
    if (!isset($this->_domain[$key])) $this->_domain[$key] = $this->getValue('domain');
    if (!isset($this->_clickLink[$key])) $this->_clickLink[$key] = 0;
    if (!isset($this->_clickBtn[$key])) $this->_clickBtn[$key] = 0;
    if (!isset($this->_clickAdsense[$key])) $this->_clickAdsense[$key] = 0;
    switch($this->getValue('logtype')) {
    case Config::CLICK_LINK:
      ++$this->_clickLink[$key];
      break;
    case Config::CLICK_BTN:
      ++$this->_clickBtn[$key];
      break;
    case Config::CLICK_ADSENSE:
      ++$this->_clickAdsense[$key];
      break;
    }
    if ($this->getValue('logtype') != Config::NORMAL_ACCESS) {
      --$this->_summaryData[$key];
      --$this->_allCount;
      if (!isset($this->_forExtractData[$key])) {
        --$this->_count;
      }
    }
  }

  private function _domain() {
    $this->_extractData($this->getValue('domain'));
  }

  private function _domain_user() {
    $this->_extractUidData();
  }

  private function _jpdomain() {
    $this->_extractData($this->getValue('jpdomain'));
  }

  private function _jpdomain_user() {
    $this->_extractUidData();
  }

  private function _pref() {
    $this->_extractData($this->getValue('pref'));
  }

  private function _pref_user() {
    $this->_extractUidData();
  }

  private function _country() {
    $this->_extractData($this->getValue('country'));
  }

  private function _country_user() {
    $this->_extractUidData();
  }

  private function _rank() {
    $this->_extractData($this->getValue('url'));
  }

  private function _rank_user() {
    $this->_extractUidData();
  }

  private function _rate() {
    $key = $this->getValue('uid') . $this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd');
    if (!isset($this->_workData[$key])) {
      $this->_workData[$key] = 1;
    } else {
      ++$this->_workData[$key];
    }
  }

  private function _rateAfter() {
    foreach ($this->_workData as $key => $value) {
      $value = $value . '回';
      $this->_extractData($value);
    }
  }

  private function _rate_user() {
    $key1 = $this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd');
    $key2 = $this->getValue('uid');
    if (!isset($this->_workData[$key1][$key2])) {
      $this->_workData[$key1][$key2] = 1;
      $this->_extractUidData();
    } else {
      ++$this->_workData[$key1][$key2];
    }
  }

  private function _rate_userAfter() {
    $this->_forExtractData = array();
    $this->_summaryData = array();
    $this->_uniqueCount = 0;
    $this->_totalCount = 0;
    $compareValue = substr($this->_compareValue, 0, strpos($this->_compareValue, '回'));
    foreach ($this->_workData as $data) {
      foreach ($data as $key => $value) {
        if ($value == $compareValue) {
          $this->_extractData($key);
        }
      }
    }
  }

  private function _screencol() {
    $this->_extractData($this->getValue('screencol'));
  }

  private function _screencol_user() {
    $this->_extractUidData();
  }

  private function _screenwh() {
    $this->_extractData($this->getValue('screenwh'));
  }

  private function _screenwh_user() {
    $this->_extractUidData();
  }

  private function _jsck() {
    $this->_extractData($this->getValue('jsck'));
  }

  private function _jsck_user() {
    $this->_extractUidData();
  }

  private function _term() {
    $this->_extractTimeData($this->getValue('uid') . $this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd'), $this->getValue('dd'));
  }

  private function _time() {
    $this->_extractTimeData($this->getValue('uid') . $this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd'), $this->getValue('hh'));
  }
  
  private function _time_detail() {
    $newflg = Config::OFF;
    $wValue = $this->getValue('uid') . $this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd');
    if (!isset($this->_forExtractData[$wValue])) {
      $this->_forExtractData[$wValue] = $wValue;
      $newflg = Config::ON;
    }
    if ($this->_compareValue == $this->getValue('hh')) {
      $this->_extractDetailCount();
      if ($newflg == Config::ON) {
        ++$this->_uniqueCount;
      }
      $this->setValue('newflg', $newflg);
      $this->_summaryData[$this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd') . $this->getValue('hh') . $this->getValue('mi') . $this->getValue('ss') . microtime() . rand(0, 100)] = $this->getData();
    }
  }

  private function _uid() {
    $this->_extractUidData();
    $key = $this->getValue('uid');
    if (!isset($this->_clickLink[$key])) $this->_clickLink[$key] = 0;
    if (!isset($this->_clickBtn[$key])) $this->_clickBtn[$key] = 0;
    if (!isset($this->_clickAdsense[$key])) $this->_clickAdsense[$key] = 0;
    switch($this->getValue('logtype')) {
    case Config::CLICK_LINK:
      ++$this->_clickLink[$key];
      break;
    case Config::CLICK_BTN:
      ++$this->_clickBtn[$key];
      break;
    case Config::CLICK_ADSENSE:
      ++$this->_clickAdsense[$key];
      break;
    }
    if ($this->getValue('logtype') != Config::NORMAL_ACCESS) {
      --$this->_summaryData[$key];
      --$this->_allCount;
      if (!isset($this->_forExtractData[$key])) {
        --$this->_count;
      }
    }
  }

  private function _uid_detail() {
    $this->_summaryData[$this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd') . $this->getValue('hh') . $this->getValue('mi') . $this->getValue('ss') . microtime() . rand(0, 100)] = $this->getData();
    $this->_extractDetailCount();
  }

  private function _week() {
    $this->_extractTimeData($this->getValue('uid') . $this->getValue('yyyy') . $this->getValue('mm') . $this->getValue('dd'), $this->getValue('weekday'));
  }

  private function _word() {
    $keyword = RaUtil::convertKana(RaUtil::strToLower($this->getValue('keyword')), 'KVas');
    $words = preg_split('/[\s]/', $keyword);
    foreach ($words as $word) {
      if (trim($word) != '') {
        if (trim($this->_compareValue) != '') if (strpos(RaUtil::strToLower($word), RaUtil::strToLower($this->_compareValue)) === false) continue;
        if (is_numeric($word)) $word .= ' ';
        $this->_extractData($word);
      }
    }
  }

  private function _engine() {
    $key = $this->getValue('engine');
    if (is_numeric($key)) $key .= ' ';
    $this->_extractData($key);
  }

  private function _engine_key() {
    $key = $this->getValue('keyword');
    if (is_numeric($key)) $key .= ' ';
    $this->_extractData($key);
  }

  private function _engine_user() {
    $this->_extractUidData();
  }

  private function _log() {
    $this->_textData .= '"'. $this->getValue('yyyy'). '/'. $this->getValue('mm'). '/'. $this->getValue('dd'). '",';
    $this->_textData .= '"'. $this->getValue('hh'). ':'. $this->getValue('mi'). ':'. $this->getValue('ss'). '",';
    $this->_textData .= '"'. Calendar::getWeekday($this->getValue('weekday')). '",';
    $this->_textData .= '"'. $this->getValue('logtype'). '",';
    $this->_textData .= '"'. $this->getValue('uid'). '",';
    $this->_textData .= '"'. $this->getValue('remote_addr'). '",';
    $this->_textData .= '"'. $this->getValue('remote_host'). '",';
    $this->_textData .= '"'. $this->getValue('domain'). '",';
    $this->_textData .= '"'. $this->getValue('country'). '",';
    $this->_textData .= '"'. $this->getValue('pref'). '",';
    $this->_textData .= '"'. $this->getValue('title'). '",';
    $this->_textData .= '"'. $this->getValue('url'). '",';
    $this->_textData .= '"'. $this->getValue('screenwh'). '",';
    $this->_textData .= '"'. $this->getValue('screencol'). '",';
    $this->_textData .= '"'. $this->getValue('jsck'). '",';
    $this->_textData .= '"'. $this->getValue('os'). '",';
    $this->_textData .= '"'. $this->getValue('browser'). '",';
    $this->_textData .= '"'. $this->getValue('brow_ver'). '",';
    $this->_textData .= '"'. $this->getValue('crawler'). '",';
    $this->_textData .= '"'. $this->getValue('keyword'). '",';
    $this->_textData .= '"'. $this->getValue('engine'). '",';
    $this->_textData .= '"'. $this->getValue('referer_title'). '",';
    $this->_textData .= '"'. $this->getValue('referer_host'). '",';
    $this->_textData .= '"'. $this->getValue('http_user_agent'). '",';
    $this->_textData .= '"'. $this->getValue('http_referer'). '"';
    $this->_textData .= "\r\n";
  }

  private function _getTerms($yyyyFrom, $mmFrom, $ddFrom, $yyyyTo, $mmTo, $ddTo) {

    $terms = array();
    $params = array();
    $count = 1;

    $yyyy = $yyyyFrom;
    $mm = $mmFrom;
    while ($yyyy . $mm <= $yyyyTo . $mmTo) {
      $params['yyyy'] = $yyyy;
      $params['mm'] = $mm;
      if ($count == 1) {
        $params['ddFrom'] = $ddFrom;
        if ($yyyy . $mm == $yyyyTo . $mmTo) {
          $params['ddTo'] = $ddTo;
        } else {
          $params['ddTo'] = Calendar::getLastDay($yyyy, $mm);
        }
      }
      if ($count > 1 && $yyyy . $mm < $yyyyTo . $mmTo) {
        $params['ddFrom'] = '01';
        $params['ddTo'] = Calendar::getLastDay($yyyy, $mm);
      }
      if ($count > 1 && $yyyy . $mm == $yyyyTo . $mmTo) {
        $params['ddFrom'] = '01';
        $params['ddTo'] = $ddTo;
      }
      $mm = $this->_getZeroSuppress($mm);
      array_push($terms, $params);
      if ($mm == 12) {
        $yyyy = $yyyy + 1;
        $mm = 1;
      } else {
        $yyyy = $yyyy;
        $mm = $mm + 1;
      }
      $mm = $this->_getZeroPadding($mm, 1);
      $count++;
    }
    return $terms;
  }

  private function _getZeroPadding($value, $cnt) {
    return str_pad($value, $cnt+1, '0', STR_PAD_LEFT);
  }

  private function _getZeroSuppress($value) {
    return is_numeric($value) ? intval($value) : $value;
  }

  private function _getFormatMmDd($value) {
    return strlen($value) == 1 ? '0' . $value : $value;
  }

  private function _extractData($key) {
    if (!isset($this->_forExtractData[$key])) {
      $this->_forExtractData[$key] = $key;
      $this->_summaryData[$key] = 1;
      ++$this->_uniqueCount;
    } else {
      ++$this->_summaryData[$key];
    }
    ++$this->_totalCount;
  }

  private function _extractUidData() {
    $key = $this->getValue('uid');
    if (!isset($this->_forExtractData[$key])) {
      $this->_forExtractData[$key] = $key;
      $this->_summaryData[$key] = 1;
      ++$this->_uniqueCount;
    } else {
      ++$this->_summaryData[$key];
    }
    $remoteAddr = $this->getValue('remote_addr');
    $remoteHost = $this->getValue('remote_host');
    $domain = $this->getValue('domain');
    $pref = $this->getValue('pref');
    $country = $this->getValue('country');
    $os = $this->getValue('os');
    $browser = $this->getValue('browser');
    if (!isset($this->_remoteAddr[$key. $remoteAddr])) $this->_remoteAddr[$key . $remoteAddr] = $remoteAddr;
    if (!isset($this->_remoteHost[$key. $remoteHost])) $this->_remoteHost[$key . $remoteHost] = $remoteHost;
    if (!isset($this->_domain[$key. $domain])) $this->_domain[$key . $domain] = $domain;
    if (!isset($this->_pref[$key. $pref])) $this->_pref[$key . $pref] = $pref;
    if (!isset($this->_domain[$key. $country])) $this->_country[$key . $country] = $country;
    if (!isset($this->_os[$key])) $this->_os[$key] = $os;
    if (!isset($this->_browser[$key])) $this->_browser[$key] = $browser;
    ++$this->_totalCount;
  }

  private function _extractTimeData($key1, $key2) {
    $key2 = round($key2);
    if (!isset($this->_forExtractData[$key1])) {
      $this->_forExtractData[$key1] = $key1;
      if (isset($this->_uniqueData[$key2])) {
        ++$this->_uniqueData[$key2];
      } else {
        $this->_uniqueData[$key2] = 1;
      }
      ++$this->_uniqueCount;
    }
    if (isset($this->_totalData[$key2])) {
      ++$this->_totalData[$key2];
    } else {
      $this->_totalData[$key2] = 1;
    }
    ++$this->_totalCount;
  }

  private function _extractDetailCount() {
    switch($this->getValue('logtype')) {
    case Config::NORMAL_ACCESS:
      ++$this->_totalCount;
      break;
    case Config::CLICK_LINK:
      ++$this->_clickLinkCount;
      break;
    case Config::CLICK_BTN:
      ++$this->_clickBtnCount;
      break;
    case Config::CLICK_ADSENSE:
      ++$this->_clickAdsenseCount;
      break;
    }
  }

  private function _unsetExtractData($key) {
    if (isset($this->_forExtractData[$key])) {
      --$this->_summaryData[$key];
      if ($this->_summaryData[$key] == 0) {
        unset($this->_summaryData[$key]);
        unset($this->_forExtractData[$key]);
        --$this->_uniqueCount;
      }
      --$this->_totalCount;
    }
  }

  private function _unsetExtractUidData() {
    $key = $this->getValue('uid');
    if (isset($this->_forExtractData[$key])) {
      --$this->_summaryData[$key];
      if ($this->_summaryData[$key] == 0) {
        unset($this->_summaryData[$key]);
        unset($this->_forExtractData[$key]);
        unset($this->_remoteAddr[$key. $this->getValue('remote_addr')]);
        unset($this->_remoteHost[$key. $this->getValue('remote_host')]);
        unset($this->_domain[$key. $this->getValue('domain')]);
        unset($this->_os[$key]);
        unset($this->_brow[$key]);
        --$this->_uniqueCount;
      }
      --$this->_totalCount;
    }
  }

}
?>
