<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */

/**
 * RA Config
 */
class RaConfig {
/* ------------------------------------------------------------------------ */

/* -- Define -- */
  /**
   * RA_NAME
   * @var string
   */
  const RA_NAME = 'Research Artisan Lite';
  /**
   * RA_URL
   * @var string
   */
  const RA_URL = 'http://lite.research-artisan.com/';
  /**
   * RA_PROJECT
   * @var string
   */
  const RA_PROJECT = 'Research Artisan Project';
  /**
   * SUPPORT_PHPVERSION
   * @var string
   */
  const SUPPORT_PHPVERSION = '5.1';
  /**
   * SUPPORT_MYSQLVERSION
   * @var float
   */
  const SUPPORT_MYSQLVERSION = 4.0;
  /**
   * CHARSET
   * @var string
   */
  const CHARSET = 'UTF-8';
  /**
   * MYSQL_CHARSET
   * @var string
   */
  const MYSQL_CHARSET = 'utf8';
  /**
   * CONTINUE_ERR_CODE
   * @var int
   */
  const CONTINUE_ERR_CODE = 0;
  /**
   * DEFAULT_ERR_CODE
   * @var int
   */
  const DEFAULT_ERR_CODE = 99000;
  /**
   * LIMIT_NEXT_CONTROLL_ERR_CODE
   * @var int
   */
  const LIMIT_NEXT_CONTROLL_ERR_CODE = 99901;
  /**
   * PHP_NOTSUPPORT_VERSION_ERR_CODE
   * @var int
   */
  const PHP_NOTSUPPORT_VERSION_ERR_CODE = 99902;
  /**
   * PHP_EXTENSION_NOTFOUND_ERR_CODE
   * @var int
   */
  const PHP_EXTENSION_NOTFOUND_ERR_CODE = 99903;
  /**
   * MYSQL_NOTSUPPORT_VERSION_ERR_CODE
   * @var int
   */
  const MYSQL_NOTSUPPORT_VERSION_ERR_CODE = 99904;
  /**
   * URL_NOTFOUND_ERR_CODE
   * @var int
   */
  const URL_NOTFOUND_ERR_CODE = 99905;
  /**
   * SESSION_ERROR_ERR_CODE
   * @var int
   */
  const SESSION_ERROR_ERR_CODE = 99906;
  /**
   * DATABASE_CONFIG_UNDEFINED_ERR_CODE
   * @var int
   */
  const DATABASE_CONFIG_UNDEFINED_ERR_CODE = 99907;
  /**
   * ENCODING_INVALID_ERR_CODE
   * @var int
   */
  const ENCODING_INVALID_ERR_CODE = 99908;
  /**
   * CTRL_RTN_NONE_ERR_CODE
   * @var int
   */
  const CTRL_RTN_NONE_ERR_CODE = 99909;
  /**
   * DATABASE_SET_CHARSET_FAILED_ERR_CODE
   * @var int
   */
  const DATABASE_SET_CHARSET_FAILED_ERR_CODE = 99910;
  /**
   * LIMIT_NEXT_CONTROLL_ERR_MSG
   * @var string
   */
  const LIMIT_NEXT_CONTROLL_ERR_MSG = 'Can Not Call NextController, Reached Critical NextControll limit ';
  /**
   * PHP_NOTSUPPORT_VERSION_ERR_MSG
   * @var string
   */
  const PHP_NOTSUPPORT_VERSION_ERR_MSG = 'Not Support PHP Version';
  /**
   * PHP_EXTENSION_NOTFOUND_ERR_MSG
   * @var string
   */
  const PHP_EXTENSION_NOTFOUND_ERR_MSG = 'PHP Extensions Not Found';
  /**
   * MYSQL_NOTSUPPORT_VERSION_ERR_MSG
   * @var string
   */
  const MYSQL_NOTSUPPORT_VERSION_ERR_MSG = 'Not Support MySQL Version';
  /**
   * URL_NOTFOUND_ERR_MSG
   * @var string
   */
  const URL_NOTFOUND_ERR_MSG = 'URL Not Found';
  /**
   * SESSION_ERROR_ERR_MSG
   * @var string
   */
  const SESSION_ERROR_ERR_MSG = 'Invalid Session';
  /**
   * DATABASE_CONFIG_UNDEFINED_ERR_MSG
   * @var string
   */
  const DATABASE_CONFIG_UNDEFINED_ERR_MSG = 'Undefined Database Configuration';
  /**
   * ENCODING_INVALID_ERR_MSG
   * @var string
   */
  const ENCODING_INVALID_ERR_MSG = 'Encoding Invalid';
  /**
   * CTRL_RTN_NONE_ERR_MSG
   * @var string
   */
  const CTRL_RTN_NONE_ERR_MSG = 'Controller Return Non-Object';
  /**
   * DATABASE_SET_CHARSET_FAILED_ERR_MSG
   * @var string
   */
  const DATABASE_SET_CHARSET_FAILED_ERR_MSG = 'Database Set Charset Failed';
  /**
   * ERR_CTRL_NAME
   * @var string
   */
  const ERR_CTRL_NAME = 'error';
  /**
   * ERR_ACTION_NAME
   * @var string
   */
  const ERR_ACTION_NAME = 'error';
  /**
   * NEXT_CONTROLL_LIMIT_TIME
   * @var int
   */
  const NEXT_CONTROLL_LIMIT_TIME = 10;
  /**
   * DATABASE_DEFINE_HOST
   * @var string
   */
  const DATABASE_DEFINE_HOST = 'DATABASE_CONNECT_HOST';
  /**
   * DATABASE_DEFINE_USER
   * @var string
   */
  const DATABASE_DEFINE_USER = 'DATABASE_CONNECT_USER';
  /**
   * DATABASE_DEFINE_PASS
   * @var string
   */
  const DATABASE_DEFINE_PASS = 'DATABASE_CONNECT_PASS';
  /**
   * DATABASE_DEFINE_DB_NAME
   * @var string
   */
  const DATABASE_DEFINE_DB_NAME = 'DATABASE_DB_NAME';
  /**
   * DATABASE_DEFINE_TABLE_PREFIX
   * @var string
   */
  const DATABASE_DEFINE_TABLE_PREFIX = 'DATABASE_TABLE_PREFIX';
  /**
   * SESSION_NAME
   * @var string
   */
  const SESSION_NAME = '_ra_session_id';
/* ------------------------------------------------------------------------ */

/* -- Public Property -- */
  /**
   * phpExtensions
   * @var array
   */
  public static $phpExtensions = array(
                    'mbstring',
                    'mysql'
  );
/* ------------------------------------------------------------------------ */

}

?>
