<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
abstract class BaseController extends RaController {

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
    $this->result->setCharset(RaConfig::CHARSET);
    $this->result->setLayout('main');
    if ($this->controller == 'research' || $this->controller == 'admin') {
      $this->checkSession('login');
      $this->_systemCheck();
    }
    if ($this->checkParamYyyyMmDd($request->get('yyyy_from'), $request->get('mm_from'), $request->get('dd_from'),
                                   $request->get('yyyy_to'), $request->get('mm_to'), $request->get('dd_to'))) {
      $this->session->set('yyyyFrom', $request->get('yyyy_from'));
      $this->session->set('mmFrom', $request->get('mm_from'));
      $this->session->set('ddFrom', $request->get('dd_from'));
      $this->session->set('yyyyTo', $request->get('yyyy_to'));
      $this->session->set('mmTo', $request->get('mm_to'));
      $this->session->set('ddTo', $request->get('dd_to'));
    }
  }
  
  protected function checkParamYyyyMmDd($yyyyFrom, $mmFrom, $ddFrom, $yyyyTo, $mmTo, $ddTo) {
    $rtn = false;
    if ((!is_null($yyyyFrom) && is_numeric($yyyyFrom) && strlen($yyyyFrom) == 4) &&
        (!is_null($mmFrom) && is_numeric($mmFrom) && strlen($mmFrom) == 2) &&
        (!is_null($ddFrom) && is_numeric($ddFrom) && strlen($ddFrom) == 2) &&
        (!is_null($yyyyTo) && is_numeric($yyyyTo) && strlen($yyyyTo) == 4) &&
        (!is_null($mmTo) && is_numeric($mmTo) && strlen($mmTo) == 2) &&
        (!is_null($ddTo) && is_numeric($ddTo) && strlen($ddTo) == 2)) {
      if (($yyyyFrom. $mmFrom. $ddFrom) <= ($yyyyTo. $mmTo. $ddTo)) {
        $rtn = true;
      }
    }
    return $rtn; 
  }

  protected function defineSiteurl($url) {
    $define = '';
    $define .= '<?php'. "\r\n";
    $define .= 'define(\''. Config::DEFINE_SITEURL. '\',\''. $url. '\');'. "\r\n";
    $define .= '?>';
    return File::writeFile(SETTING_SITEURL_FILE, $define);
  }

  private function _systemCheck() {
    SystemUtil::clearSystemMessage();
    if (is_writable(SETTING_DIR) && !$this->_isWindows()) {
      SystemUtil::setSystemMessage('※セキュリティ警告：以下の「setting」ディレクトリのアクセス権（パーミッション）が書き込み可能になっています。');
      SystemUtil::setSystemMessage(SETTING_DIR);
    }
    if (!SystemUtil::checkPhpMemoryLimit()) {
      SystemUtil::setSystemMessage('※注意：PHPが利用できる最大メモリ量が'. Config::MINIMUM_MEMORY_LIMIT. 'M以下に設定されているため、以下の制限があります。');
      SystemUtil::setSystemMessage('・アクセス数が多い場合、メモリエラーが発生する可能性があります。');
      SystemUtil::setSystemMessage('・ドメイン名、訪問者名を表示できません。');
      SystemUtil::setSystemMessage('・各ページのタイトルを表示できません。');
    }
  }

  private function _isWindows() {
    return (PHP_OS=='WINNT'||PHP_OS=='WIN32'||PHP_OS=='Windows') ? true : false;
  }

}
?>
