<?php
/**
 * Research Artisan Lite: Website Access Analyzer
 * Copyright (C) 2009 Research Artisan Project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * @copyright Copyright (C) 2009 Research Artisan Project
 * @license GNU General Public License (see license.txt)
 * @author ossi
 */
class UpgradeController extends BaseController {

  public function __construct(RaRequest $request, RaSession $session, RaMessage $message, RaResult $result, $controller, $action) {
    parent::__construct($request, $session, $message, $result, $controller, $action);
  }

  public function disp() {
    $result = $this->result;
    $this->session->destroy();

    if (!file_exists(UPGRADE_DIR)) {
      $result->setNextController('install');
      $result->setNextAction('step0');
      return $result;
    }

    $system = new System();
    $systemData = $system->find(array('condition' => array('id = 1')));
    $result->set('version', $systemData['version']);

    return $result;
  }

  public function upgrade() {
    $result = $this->result;

    if (!$this->checkPost()) {
      $result->setNextController('upgrade');
      $result->setNextAction('disp');
      return $result;
    }

    $select = $this->request->get('select');
    $upgradeVersions = array();
    foreach(glob(UPGRADE_DIR. '*') as $upgradeDir) {
      $dirs = array_reverse(explode(DIRECTORY_SEPARATOR, $upgradeDir));
      if (isset($dirs[0])) $version = $dirs[0]; 
      if (SystemUtil::versionCompareRa($version, $select, '<=')) array_push($upgradeVersions, $version);
    }
    sort($upgradeVersions);
    $version = null;

    if (!in_array($select, $upgradeVersions)) 
      throw new RaException('アップグレードは行なわれませんでした。<br />バージョン'. $select. '用のアップグレードファイルが設置されていません。');
   
    $className = null;
    $methodName = __FUNCTION__;
    $upgradeCount = 0;
    foreach ($upgradeVersions as $version) {
      $upgradeSuccess = false;
      $upgradeFileName = __CLASS__. Config::UPGRADE_FILECHAR. str_replace('.', '', $version). '.php';
      if (file_exists(UPGRADE_DIR. $version. DIRECTORY_SEPARATOR. $upgradeFileName)) {
        require UPGRADE_DIR. $version. DIRECTORY_SEPARATOR. $upgradeFileName;
        $file = explode('.', $upgradeFileName);
        if (isset($file[0])) $className = $file[0]; 
        if (!is_null($className) && class_exists($className)) {
          $upgradeClass = new $className($this->request, $this->session, $this->message, $this->result, $this->controller, $this->action);
          if (method_exists($upgradeClass, $methodName)) {
            $rtn = $upgradeClass->$methodName();
            if ($rtn) {
              $upgradeSuccess = true;
              $upgradeCount++;
            } else {
              throw new RaException($version. 'バージョンへのアップグレード中にエラーが発生したため、アップグレードは行なわれませんでした。');
            }
          }
        }
      }
      if (!$upgradeSuccess)
        throw new RaException('バージョン'. $version. 'へのアップグレードは行なわれませんでした。<br />以下のファイルが存在しない、もしくは内容に誤りがあります。<br />'. $upgradeFileName);
    }
    if ($upgradeCount > 0) {
      $system = new System();
      $system->find(array('condition' => array('id = 1')));
      $system->setValue('version', $select);
      $system->save();
      $this->message->setMessage($select. 'バージョンへのアップグレードが完了しました。<br />アップロードしたアップグレード用ファイルを削除してからログインしてください。');
      return $result;
    }
    throw new RaException('アップグレードは行なわれませんでした。<br />アップグレードファイルが正しく設置されているか確認してください。');
  }

}
?>
