/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.util;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String protocol = "";
    private String host = "";
    private int port = 80;
    private String path = "";
    private String url = "";
    private String file = "";

    public UrlHelper(String string) throws MalformedURLException {
        this.url = string;
        if (!this.checkURL(string)) {
            throw new MalformedURLException();
        }
        String[] stringArray = this.url.split("://");
        this.protocol = stringArray[0].toLowerCase();
        this.file = stringArray[1];
        String[] stringArray2 = this.file.split("/");
        String[] stringArray3 = stringArray2[0].split(":");
        this.host = stringArray3[0];
        try {
            if (stringArray3.length > 1) {
                this.port = Integer.parseInt(stringArray3[1]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedURLException();
        }
        int n = 0;
        for (String string2 : stringArray2) {
            if (n > 0) {
                this.path = this.path + "/" + string2;
            }
            ++n;
        }
        if (this.path.isEmpty()) {
            this.path = "/";
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String string) {
        this.file = string;
    }

    public String toString() {
        return this.url;
    }

    private boolean checkURL(String string) {
        String string2 = "(https?|mms|file|rtsp|rsp)(:\\/\\/[-_.!~*\\'()a-zA-Z0-9;\\/?:\\@&=+\\$,%#]+)";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }
}

