/*
 * Decompiled with CFR 0.152.
 */
package bl.radio;

import bl.radio.AbsRadioKaras;
import bl.radio.ConfigBox;
import bl.radio.DjPlayer;
import bl.radio.StatusBox;
import bl.radio.channel.ChannelFactory;
import bl.radio.channel.ChannelModel;
import bl.radio.channel.Top5Factory;
import bl.radio.config.ListedProperty;
import bl.radio.config.MessageFactory;
import bl.radio.config.Property;
import bl.radio.config.StationModel;
import bl.radio.engine.PlayerEvent;
import bl.radio.engine.PlayerStreamer;
import bl.radio.engine.meta.MetaEvent;
import bl.radio.task.ChannelUpdateTask;
import bl.radio.task.ShutDownTask;
import bl.radio.task.UpdateEvent;
import bl.radio.ui.AboutDialog;
import bl.radio.ui.AppendixDialog;
import bl.radio.ui.CocoaUIEnhancer;
import bl.radio.ui.IconAnimeter;
import bl.radio.ui.ListenLoggerDialog;
import bl.radio.ui.SplashScreen;
import bl.radio.util.SystemUtil;
import bl.radio.util.TwitterHelper;
import ch.qos.logback.classic.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.slf4j.LoggerFactory;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import uk.co.caprica.vlcj.player.MediaPlayerFactory;

public class RadioKaras
extends AbsRadioKaras {
    private static Logger logger = (Logger)LoggerFactory.getLogger(RadioKaras.class);
    private TrayItem trayItem;
    private Map<String, Menu> mainMenu;
    private List<MenuItem> toggleMenu;
    private Menu menu;
    private MenuItem swItem;
    private MenuItem ytItem;
    private MenuItem dispItem;
    private MenuItem copyItem;
    private MenuItem djItem;
    private MenuItem twitter;
    private MenuItem twItem;
    private MenuItem timerItem;
    private Menu topParent;
    private boolean doTweet;
    private boolean updateMode;
    private Timer sleepTimer;
    private boolean onSleepTimer;
    private int[] timerTimes = new int[]{30, 60, 90, 120};
    private int selectTime = this.timerTimes[0];
    private String version;
    IconAnimeter ia = null;

    public RadioKaras(String string) {
        this.version = string;
    }

    private void createPopupMenu(Shell shell) throws Exception {
        Property property2;
        if (this.trayItem == null) {
            return;
        }
        ConfigBox configBox = ConfigBox.getInstance();
        this.toggleMenu = new ArrayList<MenuItem>();
        this.menu = new Menu((Decorations)shell, 8);
        this.menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent menuEvent) {
                RadioKaras.this.resetLastedOperation();
            }

            public void menuShown(MenuEvent menuEvent) {
                RadioKaras.this.resetLastedOperation();
            }
        });
        this.swItem = new MenuItem(this.menu, 8);
        this.swItem.setText(MessageFactory.getFormatMessage("Menu.Toggle", this.channelModel.getTitle(), MessageFactory.getMessage("Menu.Toggle.Play")));
        this.swItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
                RadioKaras.this.toggleRadio();
            }
        });
        this.toggleMenu.add(this.swItem);
        new MenuItem(this.menu, 2);
        MenuItem menuItem = new MenuItem(this.menu, 64);
        menuItem.setText(MessageFactory.getMessage("Menu.Top5"));
        this.topParent = new Menu(menuItem);
        menuItem.setMenu(this.topParent);
        this.toggleMenu.add(menuItem);
        this.setTop5Menu(this.topParent);
        new MenuItem(this.menu, 2);
        this.setChannelMenu();
        new MenuItem(this.menu, 2);
        MenuItem menuItem2 = new MenuItem(this.menu, 64);
        menuItem2.setText(MessageFactory.getMessage("Menu.Appendix"));
        final Menu menu = new Menu(menuItem2);
        menuItem2.setMenu(menu);
        this.toggleMenu.add(menuItem2);
        this.setAppendixMenu(menu);
        MenuItem menuItem3 = new MenuItem(this.menu, 8);
        menuItem3.setText(MessageFactory.getMessage("Menu.Appendix.Edit"));
        menuItem3.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
                RadioKaras.this.stopAll();
                RadioKaras.this.toggleControls(false);
                RadioKaras.this.updateMode = true;
                AppendixDialog appendixDialog = new AppendixDialog(Display.getDefault().getActiveShell(), RadioKaras.this.dbPath.getPath());
                appendixDialog.open();
                RadioKaras.this.updateMode = false;
                try {
                    for (MenuItem menuItem : menu.getItems()) {
                        menuItem.dispose();
                        menuItem = null;
                    }
                    System.gc();
                    RadioKaras.this.appendixMemory = ChannelFactory.getChannels(RadioKaras.this.dbPath.getPath(), "Appendix", "appendix");
                    RadioKaras.this.setAppendixMenu(menu);
                    if (RadioKaras.this.channelModel.getRadioKey().equals("appendix")) {
                        RadioKaras.this.channelModel = RadioKaras.this.getDefaultData("sky.fm");
                    }
                    RadioKaras.this.swItem.setText(MessageFactory.getFormatMessage("Menu.Toggle", RadioKaras.this.channelModel.getTitle(), MessageFactory.getMessage("Menu.Toggle.Play")));
                }
                catch (Exception exception) {
                    logger.error("System Error !!", (Throwable)exception);
                    System.exit(1);
                }
                finally {
                    RadioKaras.this.toggleControls(true);
                }
            }
        });
        this.toggleMenu.add(menuItem3);
        new MenuItem(this.menu, 2);
        this.djItem = new MenuItem(this.menu, 64);
        this.djItem.setText(MessageFactory.getMessage("Menu.Dj"));
        Menu menu2 = new Menu(this.djItem);
        this.djItem.setMenu(menu2);
        ListedProperty listedProperty = configBox.getListedProperty("radioKaras", "categories");
        for (Property property2 : listedProperty.getProperties()) {
            MenuItem menuItem4 = new MenuItem(menu2, 16);
            menuItem4.setText(property2.getName());
            menuItem4.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    RadioKaras.this.resetLastedOperation();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RadioKaras.this.resetLastedOperation();
                    try {
                        MenuItem menuItem = (MenuItem)selectionEvent.getSource();
                        if (menuItem.getSelection()) {
                            RadioKaras.this.djItem.setEnabled(false);
                            logger.debug("DJ Mode Selected..." + menuItem.getText());
                            List<ChannelModel> list = RadioKaras.this.getCategories(menuItem.getText());
                            RadioKaras.this.djRadio(list, selectionEvent.stateMask);
                        }
                    }
                    catch (Exception exception) {
                        logger.error("DjMode Error !", (Throwable)exception);
                    }
                }
            });
        }
        this.toggleMenu.add(this.djItem);
        new MenuItem(this.menu, 2);
        this.dispItem = new MenuItem(this.menu, 8);
        this.dispItem.setText(MessageFactory.getMessage("Menu.Display"));
        this.dispItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
                RadioKaras.this.displaySong();
            }
        });
        this.dispItem.setEnabled(false);
        this.copyItem = new MenuItem(this.menu, 8);
        this.copyItem.setText(MessageFactory.getMessage("Menu.Copy"));
        this.copyItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
                RadioKaras.this.copySong();
            }
        });
        this.copyItem.setEnabled(false);
        this.ytItem = new MenuItem(this.menu, 8);
        this.ytItem.setText(MessageFactory.getMessage("Menu.Youtube"));
        this.ytItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
                RadioKaras.this.callYoutube();
            }
        });
        this.ytItem.setEnabled(false);
        this.twItem = new MenuItem(this.menu, 8);
        this.twItem.setText(MessageFactory.getMessage("Menu.Twitter.Pinpoint"));
        this.twItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
                MenuItem menuItem = (MenuItem)selectionEvent.getSource();
                menuItem.setEnabled(false);
                RadioKaras.this.doTweet = true;
                RadioKaras.this.tweetSong();
            }
        });
        this.twItem.setEnabled(false);
        this.twitter = new MenuItem(this.menu, 32);
        this.twitter.setText(MessageFactory.getMessage("Menu.Twitter"));
        this.twitter.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
                RadioKaras.this.menu.setEnabled(false);
                boolean bl = RadioKaras.this.twitter.getSelection();
                if (bl) {
                    bl = RadioKaras.this.authTwitter(RadioKaras.this.twitter.getSelection());
                }
                RadioKaras.this.twitter.setSelection(bl);
                if (bl) {
                    RadioKaras.this.twItem.setEnabled(false);
                } else if (!RadioKaras.this.doTweet) {
                    RadioKaras.this.twItem.setEnabled(true);
                }
                try {
                    ConfigBox configBox = ConfigBox.getInstance();
                    configBox.setConfigValue("radioKaras", "useTwitter", bl);
                    configBox.saveConfig();
                }
                catch (Exception exception) {
                    logger.error("System Error !!", (Throwable)exception);
                    System.exit(1);
                }
                finally {
                    RadioKaras.this.menu.setEnabled(true);
                }
            }
        });
        this.twitter.setSelection(configBox.getBoolVal("radioKaras", "useTwitter"));
        this.toggleMenu.add(this.twitter);
        new MenuItem(this.menu, 2);
        this.timerItem = new MenuItem(this.menu, 64);
        this.timerItem.setText(MessageFactory.getMessage("Menu.Timer"));
        Menu menu3 = new Menu(this.timerItem);
        this.timerItem.setMenu(menu3);
        property2 = new MenuItem(menu3, 32);
        property2.setText(MessageFactory.getMessage("Menu.Timer.Toggle"));
        property2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
                MenuItem menuItem = (MenuItem)selectionEvent.getSource();
                RadioKaras.this.onSleepTimer = menuItem.getSelection();
                if (RadioKaras.this.onSleepTimer) {
                    RadioKaras.this.setSleepTimer();
                } else if (RadioKaras.this.sleepTimer != null) {
                    RadioKaras.this.sleepTimer.cancel();
                    logger.debug("sleepTimer.cancel");
                }
            }
        });
        for (int i = 0; i < 4; ++i) {
            MenuItem menuItem5 = new MenuItem(menu3, 16);
            menuItem5.setData((Object)this.timerTimes[i]);
            menuItem5.setText(MessageFactory.getFormatMessage("Menu.Timer.Unit", this.timerTimes[i]));
            if (i == 0) {
                menuItem5.setSelection(true);
            }
            menuItem5.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    RadioKaras.this.resetLastedOperation();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RadioKaras.this.resetLastedOperation();
                    MenuItem menuItem = (MenuItem)selectionEvent.getSource();
                    if (menuItem.getSelection()) {
                        RadioKaras.this.selectTime = (Integer)menuItem.getData();
                        if (RadioKaras.this.onSleepTimer) {
                            RadioKaras.this.setSleepTimer();
                        }
                    }
                }
            });
        }
        this.toggleMenu.add(this.timerItem);
        new MenuItem(this.menu, 2);
        if (!System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            MenuItem menuItem6 = new MenuItem(this.menu, 8);
            menuItem6.setText(MessageFactory.getFormatMessage("AboutAction.Format", "RadioKaras"));
            menuItem6.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    RadioKaras.this.resetLastedOperation();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RadioKaras.this.resetLastedOperation();
                    MenuItem menuItem = (MenuItem)selectionEvent.getSource();
                    menuItem.setEnabled(false);
                    AboutDialog aboutDialog = new AboutDialog(Display.getDefault().getActiveShell(), RadioKaras.this.version);
                    aboutDialog.open();
                    menuItem.setEnabled(true);
                }
            });
            new MenuItem(this.menu, 2);
        }
        MenuItem menuItem7 = new MenuItem(this.menu, 8);
        menuItem7.setText(MessageFactory.getMessage("Menu.Exit"));
        menuItem7.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
                RadioKaras.shutdown();
            }
        });
    }

    @Override
    public void raidingTray() throws Exception {
        final ChannelUpdateTask channelUpdateTask = new ChannelUpdateTask(this.dbPath, this);
        Thread thread = new Thread(channelUpdateTask);
        thread.start();
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        Tray tray = display.getSystemTray();
        if (tray == null) {
            logger.error("System Tray Not Suport !");
            MessageDialog.openError((Shell)shell, (String)"RadioKaras", (String)MessageFactory.getMessage("Error.System.Tray"));
            System.exit(1);
        }
        this.trayItem = new TrayItem(tray, 0);
        try (InputStream inputStream = this.getClass().getResourceAsStream("/icon/1364800464_songbird_x32.png");){
            Image image = new Image((Device)display, inputStream);
            this.trayItem.setImage(image);
        }
        this.trayItem.setToolTipText("Radio Karas");
        this.trayItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                channelUpdateTask.setStop(true);
            }
        });
        this.trayItem.addListener(22, new Listener(){

            public void handleEvent(Event event) {
                RadioKaras.this.resetLastedOperation();
            }
        });
        this.trayItem.addListener(23, new Listener(){

            public void handleEvent(Event event) {
                RadioKaras.this.resetLastedOperation();
            }
        });
        this.trayItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RadioKaras.this.resetLastedOperation();
                if (RadioKaras.this.menu != null) {
                    RadioKaras.this.menu.setVisible(true);
                }
            }
        });
        this.trayItem.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                RadioKaras.this.resetLastedOperation();
            }
        });
        this.trayItem.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                RadioKaras.this.resetLastedOperation();
            }
        });
        this.createPopupMenu(shell);
        this.trayItem.setVisible(true);
        while (!shell.isDisposed()) {
            if (display == null) {
                logger.error("Display null !!");
                System.exit(0);
            }
            try {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
            catch (Exception exception) {
                logger.error("System Error !!", (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown() {
        try {
            ConfigBox configBox = ConfigBox.getInstance();
            MediaPlayerFactory mediaPlayerFactory = configBox.getMediaPlayerFactory();
            mediaPlayerFactory.release();
            configBox.saveConfig();
            Display display = Display.getDefault();
            if (display != null && !display.isDisposed()) {
                display.dispose();
            }
        }
        catch (Exception exception) {
        }
        finally {
            logger.info(MessageFactory.getMessage("Info.Exit"));
            System.exit(0);
        }
    }

    @Override
    public void notifyUpdateDb(final UpdateEvent updateEvent) {
        if (updateEvent.getStatus() == 0) {
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        Menu menu = (Menu)RadioKaras.this.mainMenu.get(updateEvent.getRadioKey());
                        for (MenuItem menuItem : menu.getItems()) {
                            Menu menu2 = menuItem.getMenu();
                            if (menu2 != null) {
                                for (MenuItem menuItem2 : menu2.getItems()) {
                                    menuItem2.dispose();
                                    menuItem2 = null;
                                }
                                menu2.dispose();
                            }
                            menuItem.dispose();
                            Object object = null;
                        }
                        System.gc();
                        ConfigBox configBox = ConfigBox.getInstance();
                        for (StationModel stationModel : configBox.getStationModels()) {
                            if (!stationModel.getName().equals(updateEvent.getRadioKey())) continue;
                            List list = (List)RadioKaras.this.channelMemory.get(stationModel.getName());
                            RadioKaras.this.setChannelSubMenu(list, menu, stationModel);
                            logger.debug("Update channel mene..." + stationModel.getName() + ":" + list.size());
                        }
                    }
                    catch (Exception exception) {
                        logger.error("System Error !!", (Throwable)exception);
                    }
                }
            });
        }
    }

    @Override
    public void notifyMetadata(final MetaEvent metaEvent) {
        try {
            this.doTweet = false;
            StatusBox statusBox = StatusBox.getInstance();
            statusBox.setSong(metaEvent.getSong());
            statusBox.setStation(metaEvent.getChannelModel().getStation());
            statusBox.setUrl(metaEvent.getChannelModel().getUrls().get(0));
            String string = metaEvent.getSong();
            if (string != null && !this.isSuperDjMode) {
                this.doTweet = TwitterHelper.updateTwitter(metaEvent);
            }
            this.showNotify(metaEvent.getChannelModel().getStation(), statusBox.getFormatSong());
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        File file = new File(RadioKaras.this.dbPath, "listen.log");
                        SystemUtil.listenLog(file, metaEvent, RadioKaras.this.isDjMode);
                        for (MenuItem menuItem : RadioKaras.this.topParent.getItems()) {
                            menuItem.dispose();
                            menuItem = null;
                        }
                        System.gc();
                        RadioKaras.this.setTop5Menu(RadioKaras.this.topParent);
                        ConfigBox configBox = ConfigBox.getInstance();
                        int n = configBox.getBoolVal("radioKaras", "useTwitter") ? 1 : 0;
                        if (TwitterHelper.isEnabledTwitter() && n == 0 && !RadioKaras.this.doTweet) {
                            RadioKaras.this.twItem.setEnabled(true);
                        } else {
                            RadioKaras.this.twItem.setEnabled(false);
                        }
                    }
                    catch (Exception exception) {
                        logger.error("System Error !!", (Throwable)exception);
                    }
                }
            });
        }
        catch (Exception exception) {
            logger.error("System Error !!", (Throwable)exception);
        }
    }

    @Override
    public void notifyPlayer(final PlayerEvent playerEvent) {
        Display display = Display.getDefault();
        String[] stringArray = new String[]{"/anime/1364934174_1_x32_0.png", "/anime/1364934174_1_x32_1.png", "/anime/1364934174_1_x32_2.png", "/anime/1364934174_1_x32_3.png", "/anime/1364934174_1_x32_4.png", "/anime/1364934174_1_x32_5.png"};
        String[] stringArray2 = new String[]{"/anime/1364800404_songbird_x32_0.png", "/anime/1364800404_songbird_x32_1.png", "/anime/1364800404_songbird_x32_2.png", "/anime/1364800404_songbird_x32_3.png", "/anime/1364800404_songbird_x32_4.png", "/anime/1364800404_songbird_x32_5.png"};
        if (playerEvent.isPlay()) {
            if (playerEvent.getStatus() == 1) {
                logger.debug("Player Started..." + playerEvent.getChannelModel().getStation());
                StatusBox statusBox = StatusBox.getInstance();
                statusBox.setPlay(true);
                if (this.ia == null) {
                    this.ia = playerEvent.isDjMode() ? new IconAnimeter(stringArray2) : new IconAnimeter(stringArray);
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String string = "";
                        if (playerEvent.isDjMode()) {
                            RadioKaras.this.isDjMode = true;
                            string = MessageFactory.getFormatMessage("Menu.Toggle", MessageFactory.getFormatMessage("Menu.Dj", new Object[0]), MessageFactory.getMessage("Menu.Toggle.Stop"));
                            RadioKaras.this.trayItem.setToolTipText("Radio Karas - " + MessageFactory.getFormatMessage("Menu.Dj", new Object[0]));
                        } else {
                            RadioKaras.this.isDjMode = false;
                            string = MessageFactory.getFormatMessage("Menu.Toggle", playerEvent.getChannelModel().getTitle(), MessageFactory.getMessage("Menu.Toggle.Stop"));
                            RadioKaras.this.trayItem.setToolTipText("Radio Karas - " + playerEvent.getChannelModel().getTitle());
                        }
                        if (!RadioKaras.this.ia.isDoAnime()) {
                            RadioKaras.this.ia.startAnime(RadioKaras.this.trayItem);
                        }
                        RadioKaras.this.swItem.setText(string);
                        RadioKaras.this.ytItem.setEnabled(true);
                        RadioKaras.this.dispItem.setEnabled(true);
                        RadioKaras.this.copyItem.setEnabled(true);
                        RadioKaras.this.toggleControls(true);
                        try {
                            ConfigBox configBox = ConfigBox.getInstance();
                            boolean bl = configBox.getBoolVal("radioKaras", "useTwitter");
                            if (TwitterHelper.isEnabledTwitter() && !bl) {
                                RadioKaras.this.twItem.setEnabled(true);
                            } else {
                                RadioKaras.this.twItem.setEnabled(false);
                            }
                        }
                        catch (Exception exception) {
                            logger.error("System Error !!", (Throwable)exception);
                        }
                    }
                });
            }
        } else if (playerEvent.getStatus() == 2 || playerEvent.getStatus() == 3 || playerEvent.getStatus() == 5 || playerEvent.getStatus() == 6 || playerEvent.getStatus() == 8 || playerEvent.getStatus() == -1) {
            if (playerEvent.isDjMode() && playerEvent.getStatus() != 6) {
                return;
            }
            logger.debug("Player Finished..." + playerEvent.getChannelModel().getStation());
            StatusBox statusBox = StatusBox.getInstance();
            statusBox.setPlay(false);
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Object object;
                    if (RadioKaras.this.ia != null) {
                        RadioKaras.this.ia.stopAnime(RadioKaras.this.trayItem);
                        RadioKaras.this.ia = null;
                    } else {
                        object = Display.getDefault();
                        object.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Display display = Display.getDefault();
                                try (InputStream inputStream = this.getClass().getResourceAsStream("/icon/1364800464_songbird_x32.png");){
                                    Image image = new Image((Device)display, inputStream);
                                    RadioKaras.this.trayItem.setImage(image);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    object = "";
                    object = playerEvent.getStatus() == 6 ? MessageFactory.getFormatMessage("Menu.Toggle", MessageFactory.getFormatMessage("Menu.Dj", new Object[0]), MessageFactory.getMessage("Menu.Toggle.Play")) : MessageFactory.getFormatMessage("Menu.Toggle", playerEvent.getChannelModel().getTitle(), MessageFactory.getMessage("Menu.Toggle.Play"));
                    if (playerEvent.getStatus() == -1 || playerEvent.getStatus() == 8) {
                        RadioKaras.this.showNotify(MessageFactory.getMessage("Error.Bad.Channle"), playerEvent.getChannelModel().getStation());
                    }
                    RadioKaras.this.swItem.setText((String)object);
                    RadioKaras.this.ytItem.setEnabled(false);
                    RadioKaras.this.dispItem.setEnabled(false);
                    RadioKaras.this.copyItem.setEnabled(false);
                    RadioKaras.this.twItem.setEnabled(false);
                    if (RadioKaras.this.updateMode) {
                        RadioKaras.this.toggleControls(false);
                    } else {
                        RadioKaras.this.toggleControls(true);
                    }
                    RadioKaras.this.isDjMode = false;
                }
            });
        }
    }

    private void toggleControls(boolean bl) {
        for (MenuItem menuItem : this.toggleMenu) {
            menuItem.setEnabled(bl);
        }
    }

    private void toggleRadio() {
        try {
            StatusBox statusBox = StatusBox.getInstance();
            if (this.isDjMode) {
                this.stopDj();
                this.isDjMode = false;
                return;
            }
            if (statusBox.isPlay()) {
                this.stopPlayer();
            } else {
                this.toggleControls(false);
                if (this.swItem.getData() != null) {
                    List list = (List)this.swItem.getData();
                    this.isDjMode = true;
                    this.isSuperDjMode = false;
                    this.djPlayer = new DjPlayer(list, this, this.isSuperDjMode);
                    Thread thread = new Thread(this.djPlayer);
                    thread.start();
                } else {
                    this.player = new PlayerStreamer(this.channelModel, this);
                    Thread thread = new Thread(this.player);
                    thread.start();
                }
            }
        }
        catch (Exception exception) {
            logger.error("Player Error !", (Throwable)exception);
        }
    }

    private void changeRadio() {
        try {
            this.stopAll();
            this.toggleControls(false);
            this.swItem.setData(null);
            this.player = new PlayerStreamer(this.channelModel, this);
            Thread thread = new Thread(this.player);
            thread.start();
            ConfigBox configBox = ConfigBox.getInstance();
            configBox.setConfigValue("radioKaras", "defaultRadio", this.channelModel.getRadioKey());
            configBox.setConfigValue("radioKaras", "defaultChannel", this.channelModel.getStation());
            configBox.saveConfig();
        }
        catch (Exception exception) {
            logger.error("Player Error !!", (Throwable)exception);
        }
    }

    private void djRadio(List<ChannelModel> list, int n) {
        try {
            this.stopAll();
            this.toggleControls(false);
            this.swItem.setData(list);
            this.isDjMode = true;
            this.isSuperDjMode = n == 131072;
            this.djPlayer = new DjPlayer(list, this, this.isSuperDjMode);
            Thread thread = new Thread(this.djPlayer);
            thread.start();
        }
        catch (Exception exception) {
            logger.error("Player Error !!", (Throwable)exception);
        }
    }

    private void stopDj() {
        if (this.djPlayer != null) {
            this.djPlayer.stop();
        }
        this.isSuperDjMode = false;
        System.gc();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (!this.swItem.getEnabled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void stopPlayer() {
        if (this.player != null) {
            this.player.stop();
        }
        System.gc();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (!this.swItem.getEnabled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stopAll() {
        StatusBox statusBox = StatusBox.getInstance();
        if (this.isDjMode) {
            this.stopDj();
            this.isDjMode = false;
            this.isSuperDjMode = false;
        }
        if (statusBox.isPlay()) {
            this.stopPlayer();
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (!this.swItem.getEnabled()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void resetLastedOperation() {
        StatusBox statusBox = StatusBox.getInstance();
        statusBox.resetLastedOperation();
    }

    private void setChannelMenu() throws Exception {
        this.mainMenu = new HashMap<String, Menu>();
        ConfigBox configBox = ConfigBox.getInstance();
        for (StationModel stationModel : configBox.getStationModels()) {
            List list = (List)this.channelMemory.get(stationModel.getName());
            MenuItem menuItem = new MenuItem(this.menu, 64);
            this.toggleMenu.add(menuItem);
            menuItem.setText(stationModel.getDisplayName());
            Menu menu = new Menu(menuItem);
            menuItem.setMenu(menu);
            this.mainMenu.put(stationModel.getName(), menu);
            logger.debug("Setup Channel..." + stationModel.getDisplayName() + ":" + list.size());
            this.setChannelSubMenu(list, menu, stationModel);
        }
    }

    private void setChannelSubMenu(List<ChannelModel> list, Menu menu, final StationModel stationModel) throws Exception {
        File file = new File(this.dbPath, "listen.log");
        Map<String, ChannelModel> map = ChannelFactory.getLoglist(file, false);
        if (stationModel.hasGenre()) {
            Map<String, List<ChannelModel>> map2 = this.getCategoryMap(list);
            for (String string : map2.keySet()) {
                MenuItem menuItem = new MenuItem(menu, 64);
                menuItem.setText(string);
                Menu menu2 = new Menu(menuItem);
                menuItem.setMenu(menu2);
                List<ChannelModel> list2 = map2.get(string);
                for (ChannelModel channelModel : list2) {
                    MenuItem menuItem2 = new MenuItem(menu2, 8);
                    menuItem2.setText(channelModel.getStation());
                    menuItem2.setData((Object)channelModel);
                    Image image = this.getLankImage(map, channelModel);
                    if (image != null) {
                        menuItem2.setImage(image);
                    }
                    menuItem2.addSelectionListener(new SelectionListener(){

                        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                            RadioKaras.this.resetLastedOperation();
                        }

                        public void widgetSelected(SelectionEvent selectionEvent) {
                            RadioKaras.this.resetLastedOperation();
                            MenuItem menuItem = (MenuItem)selectionEvent.getSource();
                            RadioKaras.this.channelModel = (ChannelModel)menuItem.getData();
                            RadioKaras.this.channelModel.setRadioKey(stationModel.getName());
                            try {
                                File file = new File(RadioKaras.this.dbPath, "listen.log");
                                Map<String, ChannelModel> map = ChannelFactory.getLoglist(file, false);
                                Image image = RadioKaras.this.getLankImage(map, RadioKaras.this.channelModel);
                                if (image != null) {
                                    menuItem.setImage(image);
                                }
                            }
                            catch (Exception exception) {
                                logger.error("System Error !!", (Throwable)exception);
                            }
                            RadioKaras.this.changeRadio();
                        }
                    });
                }
            }
        } else {
            for (ChannelModel channelModel : list) {
                MenuItem menuItem = new MenuItem(menu, 8);
                menuItem.setText(channelModel.getStation());
                menuItem.setData((Object)channelModel);
                Image image = this.getLankImage(map, channelModel);
                if (image != null) {
                    menuItem.setImage(image);
                }
                menuItem.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                        RadioKaras.this.resetLastedOperation();
                    }

                    public void widgetSelected(SelectionEvent selectionEvent) {
                        RadioKaras.this.resetLastedOperation();
                        MenuItem menuItem = (MenuItem)selectionEvent.getSource();
                        RadioKaras.this.channelModel = (ChannelModel)menuItem.getData();
                        RadioKaras.this.channelModel.setRadioKey(stationModel.getName());
                        try {
                            File file = new File(RadioKaras.this.dbPath, "listen.log");
                            Map<String, ChannelModel> map = ChannelFactory.getLoglist(file, false);
                            Image image = RadioKaras.this.getLankImage(map, RadioKaras.this.channelModel);
                            if (image != null) {
                                menuItem.setImage(image);
                            }
                        }
                        catch (Exception exception) {
                            logger.error("System Error !!", (Throwable)exception);
                        }
                        RadioKaras.this.changeRadio();
                    }
                });
            }
        }
    }

    private void setAppendixMenu(Menu menu) throws Exception {
        File file = new File(this.dbPath, "listen.log");
        Map<String, ChannelModel> map = ChannelFactory.getLoglist(file, false);
        for (ChannelModel channelModel : this.appendixMemory) {
            MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setText(channelModel.getStation());
            menuItem.setData((Object)channelModel);
            Image image = this.getLankImage(map, channelModel);
            if (image != null) {
                menuItem.setImage(image);
            }
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    RadioKaras.this.resetLastedOperation();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RadioKaras.this.resetLastedOperation();
                    MenuItem menuItem = (MenuItem)selectionEvent.getSource();
                    RadioKaras.this.channelModel = (ChannelModel)menuItem.getData();
                    RadioKaras.this.channelModel.setRadioKey("appendix");
                    try {
                        File file = new File(RadioKaras.this.dbPath, "listen.log");
                        Map<String, ChannelModel> map = ChannelFactory.getLoglist(file, false);
                        Image image = RadioKaras.this.getLankImage(map, RadioKaras.this.channelModel);
                        if (image != null) {
                            menuItem.setImage(image);
                        }
                    }
                    catch (Exception exception) {
                        logger.error("System Error !!", (Throwable)exception);
                    }
                    RadioKaras.this.changeRadio();
                }
            });
        }
    }

    private void setTop5Menu(Menu menu) throws Exception {
        final MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(MessageFactory.getMessage("Menu.ListenLog"));
        menuItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                RadioKaras.this.resetLastedOperation();
                menuItem.setEnabled(false);
                ListenLoggerDialog listenLoggerDialog = new ListenLoggerDialog(Display.getDefault().getActiveShell(), RadioKaras.this.dbPath.getPath());
                listenLoggerDialog.open();
                menuItem.setEnabled(true);
            }
        });
        File file = new File(this.dbPath, "listen.log");
        List<ChannelModel> list = Top5Factory.getChannels(file);
        if (list.size() > 0) {
            new MenuItem(menu, 2);
        }
        for (ChannelModel channelModel : list) {
            MenuItem menuItem2 = new MenuItem(menu, 8);
            menuItem2.setText(channelModel.getStation() + " (" + channelModel.getRadio() + ")");
            menuItem2.setData((Object)channelModel);
            menuItem2.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    RadioKaras.this.resetLastedOperation();
                }

                public void widgetSelected(SelectionEvent selectionEvent) {
                    RadioKaras.this.resetLastedOperation();
                    MenuItem menuItem = (MenuItem)selectionEvent.getSource();
                    RadioKaras.this.channelModel = (ChannelModel)menuItem.getData();
                    RadioKaras.this.changeRadio();
                }
            });
        }
    }

    private Image getLankImage(Map<String, ChannelModel> map, ChannelModel channelModel) throws Exception {
        Image image = null;
        if (map.containsKey(channelModel.getTitle())) {
            ChannelModel channelModel2 = map.get(channelModel.getTitle());
            String string = "";
            if (channelModel2.getCount() >= 1 && channelModel2.getCount() < 5) {
                string = "/icon/bookmark_1.png";
            } else if (channelModel2.getCount() >= 5 && channelModel2.getCount() < 10) {
                string = "/icon/bookmark_2.png";
            } else if (channelModel2.getCount() >= 10) {
                string = "/icon/bookmark_3.png";
            }
            try (InputStream inputStream = this.getClass().getResourceAsStream(string);){
                Image image2 = image = new Image((Device)Display.getDefault(), inputStream);
                return image2;
            }
        }
        return image;
    }

    private void setSleepTimer() {
        this.showNotify(MessageFactory.getFormatMessage("Info.Timer", this.selectTime), "\u2606GOODNIGHT\u2606(\uff1b\u0434\uff1b\uff09\uff89~\u25bd''\uff61\uff65\uff9f\uff9f\uff65");
        if (this.sleepTimer != null) {
            this.sleepTimer.cancel();
            this.sleepTimer = null;
        }
        this.sleepTimer = new Timer("sleep.timer");
        this.sleepTimer.schedule((TimerTask)new ShutDownTask(this), TimeUnit.MINUTES.toMillis(this.selectTime));
    }

    public static void main(String[] stringArray) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Display.setAppName((String)"RadioKaras");
        Display.setAppVersion((String)"1.4.2");
        hashMap.put("Version", Display.getAppVersion());
        Display display = Display.getDefault();
        if (System.getProperty("os.name").toLowerCase().startsWith("mac")) {
            hashMap.put("AboutAction.Format", MessageFactory.getFormatMessage("AboutAction.Format", "RadioKaras"));
            hashMap.put("HideAction.Format", MessageFactory.getFormatMessage("HideAction.Format", "RadioKaras"));
            hashMap.put("QuitAction.Format", MessageFactory.getFormatMessage("QuitAction.Format", "RadioKaras"));
            object = new CocoaUIEnhancer(hashMap);
            object.earlyStartup();
        } else {
            object = new SplashScreen();
            ((SplashScreen)object).open();
        }
        display.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                RadioKaras.shutdown();
            }
        });
        object = null;
        File file = null;
        try {
            object = ConfigBox.getInstance();
            file = new File(((ConfigBox)object).getApplicationPath(), ((ConfigBox)object).getStringVal("radioKaras", "channelDbDir"));
        }
        catch (Exception exception) {
            logger.error("loadConfig...", (Throwable)exception);
            throw new RuntimeException(exception);
        }
        RadioKaras radioKaras = new RadioKaras((String)hashMap.get("Version"));
        try {
            try {
                Twitter twitter = TwitterFactory.getSingleton();
                twitter.setOAuthConsumer("Vi7GLiuoJyEmOMqTJVjDGw", "x5FyXAQXIeQG8Gks7xKyXMstmvEGRowVvVRwbqo5oVY");
                TwitterHelper.initTwitter();
            }
            catch (Exception exception) {
                logger.error("initTwitter...", (Throwable)exception);
                throw new RuntimeException(exception);
            }
            radioKaras.setDbPath(file);
            logger.info(MessageFactory.getMessage("Info.Launch"));
            radioKaras.boot(radioKaras);
        }
        catch (Exception exception) {
            logger.error(MessageFactory.getMessage("Error.Launch"), (Throwable)exception);
            MessageDialog.openError(null, (String)"RadioKaras", (String)MessageFactory.getMessage("Error.Launch"));
            System.exit(1);
        }
    }
}

