/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.DoctypeToken;
import org.htmlcleaner.HtmlNode;
import org.htmlcleaner.ProxyTagNode;
import org.htmlcleaner.Serializer;
import org.htmlcleaner.TagNodeVisitor;
import org.htmlcleaner.TagToken;
import org.htmlcleaner.XPather;
import org.htmlcleaner.XPatherException;
import org.htmlcleaner.conditional.ITagNodeCondition;
import org.htmlcleaner.conditional.TagAllCondition;
import org.htmlcleaner.conditional.TagNodeAttExistsCondition;
import org.htmlcleaner.conditional.TagNodeAttValueCondition;
import org.htmlcleaner.conditional.TagNodeNameCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagNode
extends TagToken
implements HtmlNode {
    private TagNode parent;
    private Map<String, String> attributes = new LinkedHashMap<String, String>();
    private List children = new ArrayList();
    private DoctypeToken docType;
    private List itemsToMove;
    private Map<String, String> nsDeclarations = null;
    private transient boolean isFormed;
    private boolean autoGenerated;
    private boolean pruned;

    public TagNode(String name) {
        super(name == null ? null : name.toLowerCase());
    }

    public String getAttributeByName(String attName) {
        return attName != null ? this.attributes.get(attName.toLowerCase()) : null;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean hasAttribute(String attName) {
        return attName != null ? this.attributes.containsKey(attName.toLowerCase()) : false;
    }

    @Override
    public void addAttribute(String attName, String attValue) {
        if (attName != null) {
            String value;
            String trim = attName.trim().toLowerCase();
            String string = value = attValue == null ? "" : attValue.trim().replaceAll("\\p{Cntrl}", " ");
            if (trim.length() != 0) {
                this.attributes.put(trim, value);
            }
        }
    }

    public void removeAttribute(String attName) {
        if (attName != null && !"".equals(attName.trim())) {
            this.attributes.remove(attName.toLowerCase());
        }
    }

    @Deprecated
    public List<TagNode> getChildren() {
        return this.getChildTagList();
    }

    void setChildren(List children) {
        this.children = children;
    }

    public List getAllChildren() {
        return this.children;
    }

    public List<TagNode> getChildTagList() {
        ArrayList<TagNode> childTagList = new ArrayList<TagNode>();
        for (Object item : this.children) {
            if (!(item instanceof TagNode)) continue;
            childTagList.add((TagNode)item);
        }
        return childTagList;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public TagNode[] getChildTags() {
        List<TagNode> childTagList = this.getChildTagList();
        TagNode[] childrenArray = new TagNode[childTagList.size()];
        for (int i = 0; i < childTagList.size(); ++i) {
            childrenArray[i] = childTagList.get(i);
        }
        return childrenArray;
    }

    public CharSequence getText() {
        StringBuilder text = new StringBuilder();
        for (Object item : this.children) {
            if (item instanceof ContentNode) {
                text.append(((ContentNode)item).getContent());
                continue;
            }
            if (!(item instanceof TagNode)) continue;
            CharSequence subtext = ((TagNode)item).getText();
            text.append(subtext);
        }
        return text;
    }

    public int getChildIndex(HtmlNode child) {
        int index = 0;
        for (Object curr : this.children) {
            if (curr == child) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void insertChild(int index, HtmlNode childToAdd) {
        this.children.add(index, childToAdd);
    }

    public void insertChildBefore(HtmlNode node, HtmlNode nodeToInsert) {
        int index = this.getChildIndex(node);
        if (index >= 0) {
            this.insertChild(index, nodeToInsert);
        }
    }

    public void insertChildAfter(HtmlNode node, HtmlNode nodeToInsert) {
        int index = this.getChildIndex(node);
        if (index >= 0) {
            this.insertChild(index + 1, nodeToInsert);
        }
    }

    public TagNode getParent() {
        return this.parent;
    }

    public DoctypeToken getDocType() {
        return this.docType;
    }

    public void setDocType(DoctypeToken docType) {
        this.docType = docType;
    }

    public void addChild(Object child) {
        if (child == null) {
            return;
        }
        if (child instanceof List) {
            this.addChildren((List)child);
        } else if (child instanceof ProxyTagNode) {
            this.children.add(((ProxyTagNode)child).getToken());
        } else {
            this.children.add(child);
            if (child instanceof TagNode) {
                TagNode childTagNode = (TagNode)child;
                childTagNode.parent = this;
            }
        }
    }

    public void addChildren(List newChildren) {
        if (newChildren != null) {
            for (Object child : newChildren) {
                this.addChild(child);
            }
        }
    }

    private TagNode findElement(ITagNodeCondition condition, boolean isRecursive) {
        if (condition != null) {
            for (Object item : this.children) {
                TagNode inner;
                if (!(item instanceof TagNode)) continue;
                TagNode currNode = (TagNode)item;
                if (condition.satisfy(currNode)) {
                    return currNode;
                }
                if (!isRecursive || (inner = currNode.findElement(condition, isRecursive)) == null) continue;
                return inner;
            }
        }
        return null;
    }

    public List getElementList(ITagNodeCondition condition, boolean isRecursive) {
        LinkedList<TagNode> result = new LinkedList<TagNode>();
        if (condition == null) {
            return result;
        }
        for (Object item : this.children) {
            List innerList;
            if (!(item instanceof TagNode)) continue;
            TagNode currNode = (TagNode)item;
            if (condition.satisfy(currNode)) {
                result.add(currNode);
            }
            if (!isRecursive || (innerList = currNode.getElementList(condition, isRecursive)) == null || innerList.size() <= 0) continue;
            result.addAll(innerList);
        }
        return result;
    }

    private TagNode[] getElements(ITagNodeCondition condition, boolean isRecursive) {
        List list = this.getElementList(condition, isRecursive);
        TagNode[] array = list == null ? new TagNode[]{} : list.toArray(new TagNode[list.size()]);
        return array;
    }

    public List getAllElementsList(boolean isRecursive) {
        return this.getElementList(new TagAllCondition(), isRecursive);
    }

    public TagNode[] getAllElements(boolean isRecursive) {
        return this.getElements(new TagAllCondition(), isRecursive);
    }

    public TagNode findElementByName(String findName, boolean isRecursive) {
        return this.findElement(new TagNodeNameCondition(findName), isRecursive);
    }

    public List getElementListByName(String findName, boolean isRecursive) {
        return this.getElementList(new TagNodeNameCondition(findName), isRecursive);
    }

    public TagNode[] getElementsByName(String findName, boolean isRecursive) {
        return this.getElements(new TagNodeNameCondition(findName), isRecursive);
    }

    public TagNode findElementHavingAttribute(String attName, boolean isRecursive) {
        return this.findElement(new TagNodeAttExistsCondition(attName), isRecursive);
    }

    public List getElementListHavingAttribute(String attName, boolean isRecursive) {
        return this.getElementList(new TagNodeAttExistsCondition(attName), isRecursive);
    }

    public TagNode[] getElementsHavingAttribute(String attName, boolean isRecursive) {
        return this.getElements(new TagNodeAttExistsCondition(attName), isRecursive);
    }

    public TagNode findElementByAttValue(String attName, String attValue, boolean isRecursive, boolean isCaseSensitive) {
        return this.findElement(new TagNodeAttValueCondition(attName, attValue, isCaseSensitive), isRecursive);
    }

    public List getElementListByAttValue(String attName, String attValue, boolean isRecursive, boolean isCaseSensitive) {
        return this.getElementList(new TagNodeAttValueCondition(attName, attValue, isCaseSensitive), isRecursive);
    }

    public TagNode[] getElementsByAttValue(String attName, String attValue, boolean isRecursive, boolean isCaseSensitive) {
        return this.getElements(new TagNodeAttValueCondition(attName, attValue, isCaseSensitive), isRecursive);
    }

    public Object[] evaluateXPath(String xPathExpression) throws XPatherException {
        return new XPather(xPathExpression).evaluateAgainstNode(this);
    }

    public boolean removeFromTree() {
        return this.parent != null ? this.parent.removeChild(this) : false;
    }

    public boolean removeChild(Object child) {
        return this.children.remove(child);
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    void addItemForMoving(Object item) {
        if (this.itemsToMove == null) {
            this.itemsToMove = new ArrayList();
        }
        this.itemsToMove.add(item);
    }

    List getItemsToMove() {
        return this.itemsToMove;
    }

    void setItemsToMove(List itemsToMove) {
        this.itemsToMove = itemsToMove;
    }

    boolean isFormed() {
        return this.isFormed;
    }

    void setFormed(boolean isFormed) {
        this.isFormed = isFormed;
    }

    void setFormed() {
        this.setFormed(true);
    }

    public void setAutoGenerated(boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public boolean isPruned() {
        return this.pruned;
    }

    public void setPruned(boolean pruned) {
        this.pruned = pruned;
    }

    public boolean isEmpty() {
        if (!this.isPruned()) {
            for (Object child : this.children) {
                if (child instanceof TagNode) {
                    if (((TagNode)child).isPruned()) continue;
                    return false;
                }
                if (child instanceof ContentNode) {
                    if (((ContentNode)child).isBlank()) continue;
                    return false;
                }
                if (child instanceof CommentNode) {
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public void addNamespaceDeclaration(String nsPrefix, String nsURI) {
        if (this.nsDeclarations == null) {
            this.nsDeclarations = new TreeMap<String, String>();
        }
        this.nsDeclarations.put(nsPrefix, nsURI);
    }

    void collectNamespacePrefixesOnPath(Set<String> prefixes) {
        Map<String, String> nsDeclarations = this.getNamespaceDeclarations();
        if (nsDeclarations != null) {
            for (String prefix : nsDeclarations.keySet()) {
                prefixes.add(prefix);
            }
        }
        if (this.parent != null) {
            this.parent.collectNamespacePrefixesOnPath(prefixes);
        }
    }

    String getNamespaceURIOnPath(String nsPrefix) {
        if (this.nsDeclarations != null) {
            for (Map.Entry<String, String> nsEntry : this.nsDeclarations.entrySet()) {
                String currName = nsEntry.getKey();
                if (!currName.equals(nsPrefix) && (!"".equals(currName) || nsPrefix != null)) continue;
                return nsEntry.getValue();
            }
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURIOnPath(nsPrefix);
        }
        return null;
    }

    public Map<String, String> getNamespaceDeclarations() {
        return this.nsDeclarations;
    }

    @Override
    public void serialize(Serializer serializer, Writer writer) throws IOException {
        serializer.serialize(this, writer);
    }

    public TagNode makeCopy() {
        TagNode copy = new TagNode(this.name);
        copy.attributes.putAll(this.attributes);
        return copy;
    }

    public void traverse(TagNodeVisitor visitor) {
        this.traverseInternally(visitor);
    }

    private boolean traverseInternally(TagNodeVisitor visitor) {
        if (visitor != null) {
            boolean hasParent = this.parent != null;
            boolean toContinue = visitor.visit(this.parent, this);
            if (!toContinue) {
                return false;
            }
            if (hasParent && this.parent == null) {
                return true;
            }
            for (Object child : this.children.toArray()) {
                if (child instanceof TagNode) {
                    toContinue = ((TagNode)child).traverseInternally(visitor);
                } else if (child instanceof ContentNode) {
                    toContinue = visitor.visit(this, (ContentNode)child);
                } else if (child instanceof CommentNode) {
                    toContinue = visitor.visit(this, (CommentNode)child);
                }
                if (toContinue) continue;
                return false;
            }
        }
        return true;
    }
}

