/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.BelongsTo;
import org.htmlcleaner.CloseTag;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.ContentType;
import org.htmlcleaner.Display;
import org.htmlcleaner.TagToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagInfo {
    private String name;
    private ContentType contentType;
    private Set<String> mustCloseTags = new HashSet<String>();
    private Set<String> higherTags = new HashSet<String>();
    private Set<String> childTags = new HashSet<String>();
    private Set<String> permittedTags = new HashSet<String>();
    private Set<String> copyTags = new HashSet<String>();
    private Set<String> continueAfterTags = new HashSet<String>();
    private BelongsTo belongsTo = BelongsTo.BODY;
    private String requiredParent;
    private String fatalTag;
    private boolean deprecated;
    private boolean unique;
    private boolean ignorePermitted;
    private CloseTag closeTag;
    private Display display;

    public TagInfo(String name, ContentType contentType, BelongsTo belongsTo, boolean deprecated, boolean unique, boolean ignorePermitted, CloseTag closeTag, Display display) {
        this.name = name;
        this.contentType = contentType;
        this.belongsTo = belongsTo;
        this.deprecated = deprecated;
        this.unique = unique;
        this.ignorePermitted = ignorePermitted;
        this.closeTag = closeTag;
        this.display = display;
    }

    public void defineFatalTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag;
            this.fatalTag = currTag = tokenizer.nextToken();
            this.higherTags.add(currTag);
        }
    }

    public void defineRequiredEnclosingTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag;
            this.requiredParent = currTag = tokenizer.nextToken();
            this.higherTags.add(currTag);
        }
    }

    public void defineForbiddenTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.permittedTags.add(currTag);
        }
    }

    public void defineAllowedChildrenTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.childTags.add(currTag);
        }
    }

    public void defineHigherLevelTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.higherTags.add(currTag);
        }
    }

    public void defineCloseBeforeCopyInsideTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.copyTags.add(currTag);
            this.mustCloseTags.add(currTag);
        }
    }

    public void defineCloseInsideCopyAfterTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.continueAfterTags.add(currTag);
        }
    }

    public void defineCloseBeforeTags(String commaSeparatedListOfTags) {
        StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListOfTags.toLowerCase(), ",");
        while (tokenizer.hasMoreTokens()) {
            String currTag = tokenizer.nextToken();
            this.mustCloseTags.add(currTag);
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public Set<String> getMustCloseTags() {
        return this.mustCloseTags;
    }

    public void setMustCloseTags(Set<String> mustCloseTags) {
        this.mustCloseTags = mustCloseTags;
    }

    public Set<String> getHigherTags() {
        return this.higherTags;
    }

    public void setHigherTags(Set<String> higherTags) {
        this.higherTags = higherTags;
    }

    public Set<String> getChildTags() {
        return this.childTags;
    }

    public void setChildTags(Set<String> childTags) {
        this.childTags = childTags;
    }

    public Set<String> getPermittedTags() {
        return this.permittedTags;
    }

    public void setPermittedTags(Set<String> permittedTags) {
        this.permittedTags = permittedTags;
    }

    public Set<String> getCopyTags() {
        return this.copyTags;
    }

    public void setCopyTags(Set<String> copyTags) {
        this.copyTags = copyTags;
    }

    public Set<String> getContinueAfterTags() {
        return this.continueAfterTags;
    }

    public void setContinueAfterTags(Set<String> continueAfterTags) {
        this.continueAfterTags = continueAfterTags;
    }

    public String getRequiredParent() {
        return this.requiredParent;
    }

    public void setRequiredParent(String requiredParent) {
        this.requiredParent = requiredParent;
    }

    public BelongsTo getBelongsTo() {
        return this.belongsTo;
    }

    public void setBelongsTo(BelongsTo belongsTo) {
        this.belongsTo = belongsTo;
    }

    public String getFatalTag() {
        return this.fatalTag;
    }

    public void setFatalTag(String fatalTag) {
        this.fatalTag = fatalTag;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isIgnorePermitted() {
        return this.ignorePermitted;
    }

    public boolean isEmptyTag() {
        return ContentType.none == this.contentType;
    }

    public void setIgnorePermitted(boolean ignorePermitted) {
        this.ignorePermitted = ignorePermitted;
    }

    boolean allowsBody() {
        return ContentType.none != this.contentType;
    }

    boolean isHigher(String tagName) {
        return this.higherTags.contains(tagName);
    }

    boolean isCopy(String tagName) {
        return this.copyTags.contains(tagName);
    }

    boolean hasCopyTags() {
        return !this.copyTags.isEmpty();
    }

    boolean isContinueAfter(String tagName) {
        return this.continueAfterTags.contains(tagName);
    }

    boolean hasPermittedTags() {
        return !this.permittedTags.isEmpty();
    }

    boolean isHeadTag() {
        return this.belongsTo == BelongsTo.HEAD;
    }

    boolean isHeadAndBodyTag() {
        return this.belongsTo == BelongsTo.HEAD || this.belongsTo == BelongsTo.HEAD_AND_BODY;
    }

    boolean isMustCloseTag(TagInfo tagInfo) {
        if (tagInfo != null) {
            return this.mustCloseTags.contains(tagInfo.getName()) || tagInfo.contentType == ContentType.text;
        }
        return false;
    }

    boolean allowsItem(BaseToken token) {
        TagToken tagToken;
        String tagName;
        if (this.contentType != ContentType.none && token instanceof TagToken && "script".equals(tagName = (tagToken = (TagToken)token).getName())) {
            return true;
        }
        switch (this.contentType) {
            case all: {
                if (!this.childTags.isEmpty()) {
                    if (token instanceof TagToken) {
                        return this.childTags.contains(((TagToken)token).getName());
                    }
                } else if (!this.permittedTags.isEmpty() && token instanceof TagToken) {
                    return !this.permittedTags.contains(((TagToken)token).getName());
                }
                return true;
            }
            case text: {
                return !(token instanceof TagToken);
            }
            case none: {
                if (token instanceof ContentNode) {
                    return ((ContentNode)token).isBlank();
                }
                if (token instanceof TagToken) break;
                return true;
            }
        }
        return false;
    }

    boolean allowsAnything() {
        return ContentType.all == this.contentType && this.childTags.isEmpty();
    }

    public boolean isMinimizedTagPermitted() {
        return this.closeTag.isMinimizedTagPermitted();
    }
}

