/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.DefaultTagProvider;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.HtmlCleanerException;
import org.htmlcleaner.HtmlTokenizer;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.ProxyTagNode;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;
import org.htmlcleaner.audit.ErrorType;
import org.htmlcleaner.conditional.ITagNodeCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlCleaner {
    private static final String MARKER_ATTRIBUTE = "htmlcleaner_marker";
    private CleanerProperties properties;
    private CleanerTransformations transformations;
    private transient Stack<NestingState> nestingStates = new Stack();
    private transient boolean _headOpened;
    private transient boolean _bodyOpened;
    private transient Set<TagNode> _headTags = new LinkedHashSet<TagNode>();
    private Set<String> allTags = new TreeSet<String>();
    private TagNode htmlNode;
    private TagNode bodyNode;
    private TagNode headNode;
    private TagNode rootNode;
    private Set<TagNode> pruneNodeSet = new HashSet<TagNode>();
    private Set<ITagNodeCondition> pruneTagSet;
    private Set<ITagNodeCondition> allowTagSet;

    public HtmlCleaner() {
        this(null, null);
    }

    public HtmlCleaner(ITagInfoProvider tagInfoProvider) {
        this(tagInfoProvider, null);
    }

    public HtmlCleaner(CleanerProperties properties) {
        this(null, properties);
    }

    public HtmlCleaner(ITagInfoProvider tagInfoProvider, CleanerProperties properties) {
        this.properties = properties == null ? new CleanerProperties() : properties;
        this.properties.setTagInfoProvider(tagInfoProvider == null ? DefaultTagProvider.INSTANCE : tagInfoProvider);
    }

    public TagNode clean(String htmlContent) {
        try {
            return this.clean(new StringReader(htmlContent));
        }
        catch (IOException e) {
            throw new HtmlCleanerException(e);
        }
    }

    public TagNode clean(File file, String charset) throws IOException {
        FileInputStream in = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)in, charset);
        return this.clean(reader);
    }

    public TagNode clean(File file) throws IOException {
        return this.clean(file, this.properties.getCharset());
    }

    public TagNode clean(URL url, String charset) throws IOException {
        StringBuffer content = Utils.readUrl(url, charset);
        StringReader reader = new StringReader(content.toString());
        return this.clean(reader);
    }

    public TagNode clean(URL url) throws IOException {
        return this.clean(url, this.properties.getCharset());
    }

    public TagNode clean(InputStream in, String charset) throws IOException {
        return this.clean(new InputStreamReader(in, charset));
    }

    public TagNode clean(InputStream in) throws IOException {
        return this.clean(in, this.properties.getCharset());
    }

    public TagNode clean(Reader reader) throws IOException {
        this.pushNesting();
        this._headOpened = false;
        this._bodyOpened = false;
        this._headTags.clear();
        this.allTags.clear();
        this.pruneTagSet = new HashSet<ITagNodeCondition>(this.properties.getPruneTagSet());
        this.allowTagSet = new HashSet<ITagNodeCondition>(this.properties.getAllowTagSet());
        this.transformations = this.properties.getCleanerTransformations();
        this.pruneNodeSet.clear();
        this.htmlNode = this.newTagNode("html");
        this.bodyNode = this.newTagNode("body");
        this.headNode = this.newTagNode("head");
        this.rootNode = null;
        this.htmlNode.addChild(this.headNode);
        this.htmlNode.addChild(this.bodyNode);
        HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this, reader);
        htmlTokenizer.start();
        List<BaseToken> nodeList = htmlTokenizer.getTokenList();
        this.closeAll(nodeList);
        this.createDocumentNodes(nodeList);
        this.calculateRootNode(htmlTokenizer.getNamespacePrefixes());
        while (this.markNodesToPrune(nodeList)) {
        }
        if (this.pruneNodeSet != null && !this.pruneNodeSet.isEmpty()) {
            for (TagNode tagNode : this.pruneNodeSet) {
                TagNode parent = tagNode.getParent();
                if (parent == null) continue;
                parent.removeChild(tagNode);
            }
        }
        this.rootNode.setDocType(htmlTokenizer.getDocType());
        this.popNesting();
        return this.rootNode;
    }

    private boolean markNodesToPrune(List nodeList) {
        boolean nodesPruned = false;
        for (Object next : nodeList) {
            if (!(next instanceof TagNode) || this.pruneNodeSet.contains(next)) continue;
            TagNode node = (TagNode)next;
            if (this.addIfNeededToPruneSet(node)) {
                nodesPruned = true;
                continue;
            }
            if (node.isEmpty()) continue;
            nodesPruned |= this.markNodesToPrune(node.getAllChildren());
        }
        return nodesPruned;
    }

    private void calculateRootNode(Set<String> namespacePrefixes) {
        this.rootNode = this.htmlNode;
        if (this.properties.isOmitHtmlEnvelope()) {
            List bodyChildren = this.bodyNode.getAllChildren();
            this.rootNode = new TagNode(null);
            if (bodyChildren != null) {
                for (String currChild : bodyChildren) {
                    this.rootNode.addChild(currChild);
                }
            }
        }
        Map<String, String> atts = this.rootNode.getAttributes();
        if (this.properties.isNamespacesAware() && namespacePrefixes != null) {
            for (String prefix : namespacePrefixes) {
                String xmlnsAtt = "xmlns:" + prefix;
                if (atts.containsKey(xmlnsAtt)) continue;
                this.rootNode.addAttribute(xmlnsAtt, prefix);
            }
        }
    }

    private void addAttributesToTag(TagNode tag, Map<String, String> attributes) {
        if (attributes != null) {
            Map<String, String> tagAttributes = tag.getAttributes();
            for (Map.Entry<String, String> currEntry : attributes.entrySet()) {
                String attName = currEntry.getKey();
                if (tagAttributes.containsKey(attName)) continue;
                String attValue = currEntry.getValue();
                tag.addAttribute(attName, attValue);
            }
        }
    }

    private boolean isFatalTagSatisfied(TagInfo tag) {
        if (tag != null) {
            String fatalTagName = tag.getFatalTag();
            return fatalTagName == null ? true : this.getOpenTags().tagExists(fatalTagName);
        }
        return true;
    }

    private boolean mustAddRequiredParent(TagInfo tag) {
        String requiredParent;
        if (tag != null && (requiredParent = tag.getRequiredParent()) != null) {
            TagPos tagPos;
            String fatalTag = tag.getFatalTag();
            int fatalTagPositon = -1;
            if (fatalTag != null && (tagPos = this.getOpenTags().findTag(fatalTag)) != null) {
                fatalTagPositon = tagPos.position;
            }
            ListIterator it = this.getOpenTags().list.listIterator(this.getOpenTags().list.size());
            while (it.hasPrevious()) {
                TagPos currTagPos = (TagPos)it.previous();
                if (!tag.isHigher(currTagPos.name)) continue;
                return currTagPos.position <= fatalTagPositon;
            }
            return true;
        }
        return false;
    }

    private TagNode newTagNode(String tagName) {
        TagNode tagNode = new TagNode(tagName);
        return tagNode;
    }

    private TagNode createTagNode(TagNode startTagToken) {
        startTagToken.setFormed();
        return startTagToken;
    }

    private boolean isAllowedInLastOpenTag(BaseToken token) {
        TagPos last = this.getOpenTags().getLastTagPos();
        if (last != null && last.info != null) {
            return last.info.allowsItem(token);
        }
        return true;
    }

    private void saveToLastOpenTag(List nodeList, Object tokenToAdd) {
        TagPos last = this.getOpenTags().getLastTagPos();
        if (last != null && last.info != null && last.info.isIgnorePermitted()) {
            return;
        }
        TagPos rubbishPos = this.getOpenTags().findTagToPlaceRubbish();
        if (rubbishPos != null) {
            TagNode startTagToken = (TagNode)nodeList.get(rubbishPos.position);
            startTagToken.addItemForMoving(tokenToAdd);
        }
    }

    private boolean isStartToken(Object o) {
        return o instanceof TagNode && !((TagNode)o).isFormed();
    }

    void makeTree(List nodeList, ListIterator<BaseToken> nodeIterator) {
        while (nodeIterator.hasNext()) {
            TagInfo tag;
            String tagName;
            BaseToken token = nodeIterator.next();
            if (token instanceof EndTagToken) {
                EndTagToken endTagToken = (EndTagToken)token;
                tagName = endTagToken.getName();
                tag = this.getTagInfoProvider().getTagInfo(tagName);
                if (tag == null && this.properties.isOmitUnknownTags() || tag != null && tag.isDeprecated() && this.properties.isOmitDeprecatedTags()) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && !tag.allowsBody()) {
                    nodeIterator.set(null);
                    continue;
                }
                TagPos matchingPosition = this.getOpenTags().findTag(tagName);
                if (matchingPosition == null) continue;
                List<TagNode> closed = this.closeSnippet(nodeList, matchingPosition, endTagToken);
                nodeIterator.set(null);
                for (int i = closed.size() - 1; i >= 0; --i) {
                    TagNode closedTag = closed.get(i);
                    if (i <= 0 || tag == null || !tag.isContinueAfter(closedTag.getName())) continue;
                    TagNode cloned = closedTag.makeCopy();
                    cloned.setAutoGenerated(true);
                    nodeIterator.add(cloned);
                    nodeIterator.previous();
                }
                if (!this.getChildBreaks().isEmpty()) {
                    while (matchingPosition.position < this.getChildBreaks().getLastBreakingTagPosition()) {
                        this.getChildBreaks().pop();
                    }
                }
                while (!this.getChildBreaks().isEmpty() && tagName.equals(this.getChildBreaks().getLastBreakingTag()) && matchingPosition.position == this.getChildBreaks().getLastBreakingTagPosition()) {
                    if (nodeList.get(((TagPos)this.getChildBreaks().closedByChildBreak.peek()).position) != null) {
                        int position = this.getChildBreaks().pop().position;
                        Object toReopen = nodeList.get(position);
                        if (toReopen instanceof TagNode) {
                            this.reopenBrokenNode(nodeIterator, (TagNode)toReopen);
                            continue;
                        }
                        if (!(toReopen instanceof List)) continue;
                        List tagNodes = (List)toReopen;
                        for (TagNode n : tagNodes) {
                            nodeIterator.add(n);
                            this.makeTree(nodeList, nodeList.listIterator(nodeList.size() - 1));
                        }
                        nodeList.set(position, null);
                        continue;
                    }
                    this.getChildBreaks().pop();
                }
                continue;
            }
            if (this.isStartToken(token)) {
                TagNode startTagToken = (TagNode)token;
                tagName = startTagToken.getName();
                tag = this.getTagInfoProvider().getTagInfo(tagName);
                TagPos lastTagPos = this.getOpenTags().isEmpty() ? null : this.getOpenTags().getLastTagPos();
                TagInfo lastTagInfo = lastTagPos == null ? null : this.getTagInfoProvider().getTagInfo(lastTagPos.name);
                this.allTags.add(tagName);
                if ("html".equals(tagName)) {
                    this.addAttributesToTag(this.htmlNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if ("body".equals(tagName)) {
                    this._bodyOpened = true;
                    this.addAttributesToTag(this.bodyNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if ("head".equals(tagName)) {
                    this._headOpened = true;
                    this.addAttributesToTag(this.headNode, startTagToken.getAttributes());
                    nodeIterator.set(null);
                    continue;
                }
                if (tag == null && this.properties.isOmitUnknownTags()) {
                    nodeIterator.set(null);
                    this.properties.fireUglyHtml(true, startTagToken, ErrorType.Unknown);
                    continue;
                }
                if (tag != null && tag.isDeprecated() && this.properties.isOmitDeprecatedTags()) {
                    nodeIterator.set(null);
                    this.properties.fireUglyHtml(true, startTagToken, ErrorType.Deprecated);
                    continue;
                }
                if (tag == null && lastTagInfo != null && !lastTagInfo.allowsAnything()) {
                    this.closeSnippet(nodeList, lastTagPos, startTagToken);
                    nodeIterator.previous();
                    continue;
                }
                if (tag != null && tag.hasPermittedTags() && this.getOpenTags().someAlreadyOpen(tag.getPermittedTags())) {
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && tag.isUnique() && this.getOpenTags().tagEncountered(tagName)) {
                    nodeIterator.set(null);
                    this.properties.fireHtmlError(true, startTagToken, ErrorType.UniqueTagDuplicated);
                    continue;
                }
                if (!this.isFatalTagSatisfied(tag)) {
                    nodeIterator.set(null);
                    this.properties.fireHtmlError(true, startTagToken, ErrorType.FatalTagMissing);
                    continue;
                }
                if (this.mustAddRequiredParent(tag)) {
                    String requiredParent = tag.getRequiredParent();
                    TagNode requiredParentStartToken = this.newTagNode(requiredParent);
                    requiredParentStartToken.setAutoGenerated(true);
                    nodeIterator.previous();
                    nodeIterator.add(requiredParentStartToken);
                    nodeIterator.previous();
                    this.properties.fireHtmlError(true, startTagToken, ErrorType.RequiredParentMissing);
                    continue;
                }
                if (tag != null && lastTagPos != null && tag.isMustCloseTag(lastTagInfo)) {
                    this.getChildBreaks().addBreak(lastTagPos, new TagPos(nodeIterator.previousIndex(), tag.getName()));
                    boolean certainty = !startTagToken.hasAttribute("id");
                    this.properties.fireHtmlError(certainty, (TagNode)nodeList.get(lastTagPos.position), ErrorType.UnpermittedChild);
                    List<TagNode> closed = this.closeSnippet(nodeList, lastTagPos, startTagToken);
                    int closedCount = closed.size();
                    if (tag.hasCopyTags() && closedCount > 0) {
                        TagNode currStartToken;
                        ListIterator<TagNode> closedIt = closed.listIterator(closedCount);
                        ArrayList<TagNode> toBeCopied = new ArrayList<TagNode>();
                        while (closedIt.hasPrevious() && tag.isCopy((currStartToken = closedIt.previous()).getName())) {
                            toBeCopied.add(0, currStartToken);
                        }
                        if (toBeCopied.size() > 0) {
                            for (TagNode currStartToken2 : toBeCopied) {
                                nodeIterator.add(currStartToken2.makeCopy());
                            }
                            for (int i = 0; i < toBeCopied.size(); ++i) {
                                nodeIterator.previous();
                            }
                        }
                    }
                    nodeIterator.previous();
                    continue;
                }
                if (!this.isAllowedInLastOpenTag(token)) {
                    this.saveToLastOpenTag(nodeList, token);
                    nodeIterator.set(null);
                    continue;
                }
                if (tag != null && !tag.allowsBody()) {
                    TagNode newTagNode = this.createTagNode(startTagToken);
                    this.addPossibleHeadCandidate(tag, newTagNode);
                    nodeIterator.set(newTagNode);
                    continue;
                }
                this.getOpenTags().addTag(tagName, nodeIterator.previousIndex());
                continue;
            }
            if (this._headOpened && !this._bodyOpened && this.properties.isKeepWhitespaceAndCommentsInHead()) {
                BaseToken lastTok;
                ContentNode contentNode;
                if (token instanceof CommentNode) {
                    if (this.getOpenTags().getLastTagPos() == null) {
                        this._headTags.add(new ProxyTagNode((CommentNode)token, this.bodyNode));
                    }
                } else if (token instanceof ContentNode && (contentNode = (ContentNode)token).isBlank() && (lastTok = (BaseToken)nodeList.get(nodeList.size() - 1)) == token) {
                    this._headTags.add(new ProxyTagNode(contentNode, this.bodyNode));
                }
            }
            if (this.isAllowedInLastOpenTag(token)) continue;
            this.saveToLastOpenTag(nodeList, token);
            nodeIterator.set(null);
        }
    }

    private void reopenBrokenNode(ListIterator<BaseToken> nodeIterator, TagNode toReopen) {
        TagNode closedByPresidence = toReopen;
        TagNode copy = closedByPresidence.makeCopy();
        copy.setAutoGenerated(true);
        copy.removeAttribute("id");
        nodeIterator.add(copy);
        this.getOpenTags().addTag(closedByPresidence.getName(), nodeIterator.previousIndex());
    }

    protected boolean isRemovingNodeReasonablySafe(TagNode startTagToken) {
        return !startTagToken.hasAttribute("id") && !startTagToken.hasAttribute("name") && !startTagToken.hasAttribute("class");
    }

    private void createDocumentNodes(List listNodes) {
        for (Object child : listNodes) {
            if (child == null) continue;
            boolean toAdd = true;
            if (child instanceof TagNode) {
                TagNode node = (TagNode)child;
                TagInfo tag = this.getTagInfoProvider().getTagInfo(node.getName());
                this.addPossibleHeadCandidate(tag, node);
            } else if (child instanceof ContentNode) {
                boolean bl = toAdd = !"".equals(child.toString());
            }
            if (!toAdd) continue;
            this.bodyNode.addChild(child);
        }
        for (TagNode headCandidateNode : this._headTags) {
            boolean toMove = true;
            for (TagNode parent = headCandidateNode.getParent(); parent != null; parent = parent.getParent()) {
                if (!this._headTags.contains(parent)) continue;
                toMove = false;
                break;
            }
            if (!toMove) continue;
            headCandidateNode.removeFromTree();
            this.headNode.addChild(headCandidateNode);
        }
    }

    private List<TagNode> closeSnippet(List nodeList, TagPos tagPos, Object toNode) {
        ArrayList<TagNode> closed = new ArrayList<TagNode>();
        ListIterator<Object> it = nodeList.listIterator(tagPos.position);
        TagNode tagNode = null;
        Object item = it.next();
        boolean isListEnd = false;
        while (toNode == null && !isListEnd || toNode != null && item != toNode) {
            if (this.isStartToken(item)) {
                TagNode startTagToken = (TagNode)item;
                closed.add(startTagToken);
                List itemsToMove = startTagToken.getItemsToMove();
                if (itemsToMove != null) {
                    this.pushNesting();
                    this.makeTree(itemsToMove, itemsToMove.listIterator(0));
                    this.closeAll(itemsToMove);
                    startTagToken.setItemsToMove(null);
                    this.popNesting();
                }
                TagNode newTagNode = this.createTagNode(startTagToken);
                TagInfo tag = this.getTagInfoProvider().getTagInfo(newTagNode.getName());
                this.addPossibleHeadCandidate(tag, newTagNode);
                if (tagNode != null) {
                    tagNode.addChildren(itemsToMove);
                    tagNode.addChild(newTagNode);
                    it.set(null);
                } else if (itemsToMove != null) {
                    itemsToMove.add(newTagNode);
                    it.set(itemsToMove);
                } else {
                    it.set(newTagNode);
                }
                this.getOpenTags().removeTag(newTagNode.getName());
                tagNode = newTagNode;
            } else if (tagNode != null) {
                it.set(null);
                if (item != null) {
                    tagNode.addChild(item);
                }
            }
            if (it.hasNext()) {
                item = it.next();
                continue;
            }
            isListEnd = true;
        }
        return closed;
    }

    private void closeAll(List nodeList) {
        TagPos firstTagPos = this.getOpenTags().findFirstTagPos();
        for (TagPos pos : this.getOpenTags().list) {
            this.properties.fireHtmlError(true, (TagNode)nodeList.get(pos.position), ErrorType.UnclosedTag);
        }
        if (firstTagPos != null) {
            this.closeSnippet(nodeList, firstTagPos, null);
        }
    }

    private void addPossibleHeadCandidate(TagInfo tagInfo, TagNode tagNode) {
        if (tagInfo != null && tagNode != null && (tagInfo.isHeadTag() || tagInfo.isHeadAndBodyTag() && this._headOpened && !this._bodyOpened)) {
            this._headTags.add(tagNode);
        }
    }

    public CleanerProperties getProperties() {
        return this.properties;
    }

    public Set<ITagNodeCondition> getPruneTagSet() {
        return this.pruneTagSet;
    }

    public Set<ITagNodeCondition> getAllowTagSet() {
        return this.allowTagSet;
    }

    public void addPruneNode(TagNode node) {
        node.setPruned(true);
        this.pruneNodeSet.add(node);
    }

    private boolean addIfNeededToPruneSet(TagNode tagNode) {
        if (this.pruneTagSet != null) {
            for (ITagNodeCondition condition : this.pruneTagSet) {
                if (!condition.satisfy(tagNode)) continue;
                this.addPruneNode(tagNode);
                this.properties.fireConditionModification(condition, tagNode);
                return true;
            }
        }
        if (this.allowTagSet != null && !this.allowTagSet.isEmpty()) {
            for (ITagNodeCondition condition : this.allowTagSet) {
                if (!condition.satisfy(tagNode)) continue;
                return false;
            }
            if (!tagNode.isAutoGenerated()) {
                this.properties.fireUserDefinedModification(true, tagNode, ErrorType.NotAllowedTag);
            }
            this.addPruneNode(tagNode);
            return true;
        }
        return false;
    }

    public Set<String> getAllTags() {
        return this.allTags;
    }

    public ITagInfoProvider getTagInfoProvider() {
        return this.properties.getTagInfoProvider();
    }

    public CleanerTransformations getTransformations() {
        return this.transformations;
    }

    public String getInnerHtml(TagNode node) {
        if (node != null) {
            String content = new SimpleXmlSerializer(this.properties).getAsString(node);
            int index1 = content.indexOf("<" + node.getName());
            index1 = content.indexOf(62, index1 + 1);
            int index2 = content.lastIndexOf(60);
            return index1 >= 0 && index1 <= index2 ? content.substring(index1 + 1, index2) : null;
        }
        throw new HtmlCleanerException("Cannot return inner html of the null node!");
    }

    public void setInnerHtml(TagNode node, String content) {
        if (node != null) {
            String nodeName = node.getName();
            StringBuilder html = new StringBuilder();
            html.append("<").append(nodeName).append(" htmlcleaner_marker=''>").append(content).append("</").append(nodeName).append(">");
            for (TagNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                String parentName = parent.getName();
                html.insert(0, "<" + parentName + ">");
                html.append("</").append(parentName).append(">");
            }
            TagNode innerRootNode = this.clean(html.toString());
            TagNode cleanedNode = innerRootNode.findElementHavingAttribute(MARKER_ATTRIBUTE, true);
            if (cleanedNode != null) {
                node.setChildren(cleanedNode.getAllChildren());
            }
        }
    }

    public void initCleanerTransformations(Map transInfos) {
        this.transformations = new CleanerTransformations(transInfos);
    }

    private OpenTags getOpenTags() {
        return this.nestingStates.peek().getOpenTags();
    }

    private ChildBreaks getChildBreaks() {
        return this.nestingStates.peek().getChildBreaks();
    }

    private NestingState pushNesting() {
        return this.nestingStates.push(new NestingState());
    }

    private NestingState popNesting() {
        return this.nestingStates.pop();
    }

    protected class NestingState {
        private OpenTags openTags;
        private ChildBreaks childBreaks;

        protected NestingState() {
            this.openTags = new OpenTags();
            this.childBreaks = new ChildBreaks();
        }

        public OpenTags getOpenTags() {
            return this.openTags;
        }

        public ChildBreaks getChildBreaks() {
            return this.childBreaks;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OpenTags {
        private List<TagPos> list = new ArrayList<TagPos>();
        private TagPos last;
        private Set<String> set = new HashSet<String>();

        private OpenTags() {
        }

        private boolean isEmpty() {
            return this.list.isEmpty();
        }

        private void addTag(String tagName, int position) {
            this.last = new TagPos(position, tagName);
            this.list.add(this.last);
            this.set.add(tagName);
        }

        private void removeTag(String tagName) {
            ListIterator<TagPos> it = this.list.listIterator(this.list.size());
            while (it.hasPrevious()) {
                TagPos currTagPos = it.previous();
                if (!tagName.equals(currTagPos.name)) continue;
                it.remove();
                break;
            }
            this.last = this.list.isEmpty() ? null : this.list.get(this.list.size() - 1);
        }

        private TagPos findFirstTagPos() {
            return this.list.isEmpty() ? null : this.list.get(0);
        }

        private TagPos getLastTagPos() {
            return this.last;
        }

        private TagPos findTag(String tagName) {
            if (tagName != null) {
                ListIterator<TagPos> it = this.list.listIterator(this.list.size());
                String fatalTag = null;
                TagInfo fatalInfo = HtmlCleaner.this.getTagInfoProvider().getTagInfo(tagName);
                if (fatalInfo != null) {
                    fatalTag = fatalInfo.getFatalTag();
                }
                while (it.hasPrevious()) {
                    TagPos currTagPos = it.previous();
                    if (tagName.equals(currTagPos.name)) {
                        return currTagPos;
                    }
                    if (fatalTag == null || !fatalTag.equals(currTagPos.name)) continue;
                    return null;
                }
            }
            return null;
        }

        private boolean tagExists(String tagName) {
            TagPos tagPos = this.findTag(tagName);
            return tagPos != null;
        }

        private TagPos findTagToPlaceRubbish() {
            TagPos result = null;
            TagPos prev = null;
            if (!this.isEmpty()) {
                ListIterator<TagPos> it = this.list.listIterator(this.list.size());
                while (it.hasPrevious()) {
                    result = it.previous();
                    if ((result.info == null || result.info.allowsAnything()) && prev != null) {
                        return prev;
                    }
                    prev = result;
                }
            }
            return result;
        }

        private boolean tagEncountered(String tagName) {
            return this.set.contains(tagName);
        }

        private boolean someAlreadyOpen(Set<String> tags) {
            for (TagPos curr : this.list) {
                if (!tags.contains(curr.name)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ChildBreaks {
        private Stack<TagPos> closedByChildBreak = new Stack();
        private Stack<TagPos> breakingTags = new Stack();

        private ChildBreaks() {
        }

        public void addBreak(TagPos closedPos, TagPos breakPos) {
            this.closedByChildBreak.add(closedPos);
            this.breakingTags.add(breakPos);
        }

        public boolean isEmpty() {
            return this.closedByChildBreak.isEmpty();
        }

        public String getLastBreakingTag() {
            return this.breakingTags.peek().name;
        }

        public TagPos pop() {
            this.breakingTags.pop();
            return this.closedByChildBreak.pop();
        }

        public int getLastBreakingTagPosition() {
            return this.breakingTags.isEmpty() ? -1 : this.breakingTags.peek().position;
        }
    }

    private class TagPos {
        private int position;
        private String name;
        private TagInfo info;

        TagPos(int position, String name) {
            this.position = position;
            this.name = name;
            this.info = HtmlCleaner.this.getTagInfoProvider().getTagInfo(name);
        }
    }
}

