/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.ui;

import bl.radio.RadioKaras;
import bl.radio.channel.ChannelModel;
import bl.radio.config.MessageFactory;
import bl.radio.ui.CocoaUtil;
import bl.radio.util.WebClientUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ListenLoggerDialog
extends TitleAreaDialog {
    private static final int MAX_GRID_ROWS = 50;
    private Table table;
    private String dbPath;
    private Thread thread;
    private boolean doLoop;

    public ListenLoggerDialog(Shell shell, String string) {
        super(shell);
        this.dbPath = string;
    }

    public void create() {
        super.create();
        this.setTitle(MessageFactory.getMessage("Listen.Logger.Title"));
        this.setMessage(MessageFactory.getMessage("Listen.Logger.Info"), 1);
        Display display = Display.getDefault();
        try (InputStream inputStream = RadioKaras.class.getResourceAsStream("/icon/1364800464_songbird_64.png");){
            Image image = new Image((Device)display, inputStream);
            this.setTitleImage(image);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (RadioKaras.osName.startsWith("mac")) {
            CocoaUtil.setCollectionBehavior((Shell)this.getShell());
        }
    }

    protected void cancelPressed() {
        this.doLoop = false;
        while (this.thread.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        Button button = this.createButton(composite, 0, MessageFactory.getMessage("Appendix.List.Button.Close"), true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ListenLoggerDialog.this.cancelPressed();
            }
        });
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        control.getShell().setText(MessageFactory.getMessage("Listen.Logger.Title"));
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, true));
        TableViewer tableViewer = new TableViewer(composite2, 68352);
        this.table = tableViewer.getTable();
        this.table.setTouchEnabled(false);
        this.table.addGestureListener(new GestureListener(){

            public void gesture(GestureEvent gestureEvent) {
                ListenLoggerDialog.this.table.setTopIndex(ListenLoggerDialog.this.table.getTopIndex());
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 5;
        gridData.heightHint = 350;
        gridData.widthHint = 800;
        this.table.setLayoutData((Object)gridData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        String[] stringArray = new String[]{MessageFactory.getMessage("Listen.Logger.Col1"), MessageFactory.getMessage("Listen.Logger.Col2"), MessageFactory.getMessage("Listen.Logger.Col3"), MessageFactory.getMessage("Listen.Logger.Col4"), MessageFactory.getMessage("Listen.Logger.Col5")};
        int[] nArray = new int[]{155, 220, 120, 200, 180};
        for (int i = 0; i < stringArray.length; ++i) {
            TableColumn tableColumn = new TableColumn(this.table, 16384);
            tableColumn.setText(stringArray[i]);
            tableColumn.setWidth(nArray[i]);
        }
        this.setListData();
        tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
                Object object = iStructuredSelection.getFirstElement();
                if (object != null) {
                    ChannelModel channelModel = (ChannelModel)object;
                    ListenLoggerDialog.this.callYoutube(channelModel);
                }
            }
        });
        this.thread = new Thread(){

            @Override
            public void run() {
                ListenLoggerDialog.this.doLoop = true;
                while (ListenLoggerDialog.this.doLoop) {
                    if (ListenLoggerDialog.this.table.isDisposed()) {
                        return;
                    }
                    Display display = Display.getDefault();
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ListenLoggerDialog.this.setListData();
                        }
                    });
                    for (int i = 0; i < 100 && ListenLoggerDialog.this.doLoop; ++i) {
                        try {
                            Thread.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        this.thread.start();
        return composite;
    }

    private void setListData() {
        try {
            if (this.table.isDisposed()) {
                return;
            }
            int n = this.table.getTopIndex();
            this.table.removeAll();
            File file = new File(this.dbPath, "listen.log");
            List<ChannelModel> list = this.getLoglist(file);
            for (ChannelModel channelModel : list) {
                if (this.table.isDisposed()) {
                    return;
                }
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(0, channelModel.getListenTime());
                tableItem.setText(1, channelModel.getDescription());
                tableItem.setText(2, channelModel.getRadio());
                tableItem.setText(3, channelModel.getStation());
                if (!channelModel.getStation().equals(channelModel.getCategory())) {
                    tableItem.setText(4, channelModel.getCategory());
                }
                tableItem.setData((Object)channelModel);
                if (this.table.getItemCount() <= 50) continue;
                break;
            }
            if (this.table.isDisposed()) {
                return;
            }
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, "");
            tableItem.setText(1, "");
            tableItem.setText(2, "");
            tableItem.setText(3, "");
            tableItem.setText(4, "");
            tableItem.setData(null);
            this.table.setTopIndex(n);
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getMessage());
        }
    }

    private void callYoutube(ChannelModel channelModel) {
        try {
            if (channelModel.getDescription() != null) {
                WebClientUtil.queryYouTube(channelModel.getDescription());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<ChannelModel> getLoglist(File file) throws Exception {
        ArrayList<ChannelModel> arrayList = new ArrayList<ChannelModel>();
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string == null) continue;
                    String[] stringArray = string.split("\t");
                    this.setChannelModel(stringArray, arrayList);
                }
            }
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    private void setChannelModel(String[] stringArray, List<ChannelModel> list) {
        ChannelModel channelModel = new ChannelModel(stringArray[3]);
        channelModel.setListenTime(stringArray[0]);
        channelModel.setDescription(stringArray[1]);
        channelModel.setRadioKey(stringArray[2]);
        channelModel.setStation(stringArray[4]);
        channelModel.setCategory(stringArray[5]);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stringArray[6]);
        channelModel.setUrls(arrayList);
        list.add(channelModel);
    }
}

