/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.ui;

import bl.radio.RadioKaras;
import bl.radio.channel.CannelEditor;
import bl.radio.channel.ChannelModel;
import bl.radio.config.MessageFactory;
import bl.radio.ui.CocoaUtil;
import bl.radio.util.UrlHelper;
import bl.radio.util.WebClientUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AppendixEditDialog
extends TitleAreaDialog {
    private ChannelModel model;
    private Text stationText;
    private Text descriptionText;
    private Text urlText;
    private Text categoryText;
    private Button cancelButton;
    private CannelEditor editor;
    private boolean isNew;

    public AppendixEditDialog(Shell shell, ChannelModel channelModel, CannelEditor cannelEditor, boolean bl) {
        super(shell);
        this.model = channelModel;
        this.editor = cannelEditor;
        this.isNew = bl;
    }

    public ChannelModel getModel() {
        return this.model;
    }

    public void create() {
        super.create();
        if (RadioKaras.osName.startsWith("mac")) {
            CocoaUtil.setCollectionBehavior((Shell)this.getShell());
        }
        this.setTitle(MessageFactory.getMessage("Appendix.Edit.Title"));
        this.setMessage(MessageFactory.getMessage("Appendix.Edit.SubTitle"), 1);
        Display display = Display.getDefault();
        try (InputStream inputStream = RadioKaras.class.getResourceAsStream("/icon/1364800464_songbird_64.png");){
            Image image = new Image((Device)display, inputStream);
            this.setTitleImage(image);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (this.model.getStation() != null) {
            this.stationText.setText(this.model.getStation());
        }
        if (this.model.getCategory() != null) {
            this.categoryText.setText(this.model.getCategory());
        }
        if (this.model.getDescription() != null) {
            this.descriptionText.setText(this.model.getDescription());
        }
        if (this.model.getUrls() != null && this.model.getUrls().size() > 0) {
            this.urlText.setText(this.model.getUrls().get(0));
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void okPressed() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.urlText.getText());
        this.model.setCategory(this.categoryText.getText());
        this.model.setDescription(this.descriptionText.getText());
        this.model.setStation(this.stationText.getText());
        this.model.setUrls(arrayList);
        try {
            if (this.isNew) {
                this.editor.create(this.model);
            } else {
                this.editor.update(this.model);
            }
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getMessage());
            return;
        }
        super.okPressed();
    }

    private boolean isValidInput() {
        boolean bl = true;
        if (this.urlText.getText().length() == 0) {
            this.setErrorMessage(MessageFactory.getFormatMessage("Appendix.Edit.Error1", MessageFactory.getMessage("Appendix.Edit.Label.Url")));
            bl = false;
        }
        if (this.stationText.getText().length() == 0) {
            this.setErrorMessage(MessageFactory.getFormatMessage("Appendix.Edit.Error1", MessageFactory.getMessage("Appendix.Edit.Label.Station")));
            bl = false;
        }
        try {
            new UrlHelper(this.urlText.getText());
        }
        catch (MalformedURLException malformedURLException) {
            this.setErrorMessage(MessageFactory.getFormatMessage("Appendix.Edit.Error2", new Object[0]));
            bl = false;
        }
        return bl;
    }

    protected void buttonPressed(int n) {
        if (n == 1 && this.isValidInput() && this.testPlay()) {
            this.okPressed();
        }
    }

    private boolean testPlay() {
        try {
            UrlHelper urlHelper = new UrlHelper(this.urlText.getText());
            if (!WebClientUtil.chkStream(urlHelper)) {
                this.setErrorMessage(MessageFactory.getMessage("Appendix.Edit.Error.Url"));
                return false;
            }
        }
        catch (Exception exception) {
            this.setErrorMessage(MessageFactory.getMessage("Appendix.Edit.Error.Url"));
            return false;
        }
        return true;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 1, MessageFactory.getMessage("Appendix.Edit.Button.Update"), false);
        this.cancelButton = this.createButton(composite, 2, MessageFactory.getMessage("Appendix.Edit.Button.Cancel"), true);
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AppendixEditDialog.this.cancelPressed();
            }
        });
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        control.getShell().setText(MessageFactory.getMessage("Appendix.Edit.Title"));
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText(MessageFactory.getMessage("Appendix.Edit.Label.Station"));
        GridData gridData = new GridData(768);
        gridData.widthHint = 500;
        this.stationText = new Text(composite2, 2048);
        this.stationText.setLayoutData((Object)gridData);
        Label label2 = new Label(composite2, 0);
        label2.setText(MessageFactory.getMessage("Appendix.Edit.Label.Url"));
        this.urlText = new Text(composite2, 2048);
        this.urlText.setLayoutData((Object)new GridData(768));
        Label label3 = new Label(composite2, 0);
        label3.setText("");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(example)\r\n");
        stringBuilder.append("http://184.95.62.170:8002/\r\n");
        stringBuilder.append("http://www3.nhk.or.jp/rj/podcast/mp3/english.mp3\r\n");
        stringBuilder.append("mms://rj-wmt1.gekimedia.net/rj64-1m\r\n");
        stringBuilder.append("http://www.mi-j.com/test-meta/test-02.asx\r\n");
        stringBuilder.append("rtsp://011.mediaimage.jp/test/test-01.wmv\r\n");
        CLabel cLabel = new CLabel(composite2, 0);
        cLabel.setForeground(Display.getDefault().getSystemColor(16));
        cLabel.setText(stringBuilder.toString());
        Label label4 = new Label(composite2, 0);
        label4.setText(MessageFactory.getMessage("Appendix.Edit.Label.Description"));
        this.descriptionText = new Text(composite2, 2048);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        Label label5 = new Label(composite2, 0);
        label5.setText(MessageFactory.getMessage("Appendix.Edit.Label.Category"));
        this.categoryText = new Text(composite2, 2048);
        this.categoryText.setLayoutData((Object)new GridData(768));
        return composite;
    }
}

