/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.ui;

import bl.radio.RadioKaras;
import bl.radio.channel.CannelEditor;
import bl.radio.channel.ChannelModel;
import bl.radio.config.MessageFactory;
import bl.radio.ui.AppendixEditDialog;
import bl.radio.ui.CocoaUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.GestureEvent;
import org.eclipse.swt.events.GestureListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AppendixDialog
extends TitleAreaDialog {
    private List<ChannelModel> appendixMemory;
    private org.eclipse.swt.widgets.List list1;
    private CannelEditor editor;

    public AppendixDialog(Shell shell, String string) {
        super(shell);
        this.editor = new CannelEditor(string);
    }

    public void create() {
        super.create();
        this.setTitle(MessageFactory.getMessage("Appendix.List.Title"));
        this.setMessage(MessageFactory.getMessage("Appendix.List.SubTitle"), 1);
        Display display = Display.getDefault();
        try (InputStream inputStream = RadioKaras.class.getResourceAsStream("/icon/1364800464_songbird_64.png");){
            Image image = new Image((Device)display, inputStream);
            this.setTitleImage(image);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (RadioKaras.osName.startsWith("mac")) {
            CocoaUtil.setCollectionBehavior((Shell)this.getShell());
        }
    }

    protected void buttonPressed(int n) {
        if (n == 3) {
            return;
        }
        ChannelModel channelModel = null;
        if (n == 0) {
            channelModel = new ChannelModel("Appendix");
            AppendixEditDialog appendixEditDialog = new AppendixEditDialog(this.getShell(), channelModel, this.editor, true);
            appendixEditDialog.create();
            if (appendixEditDialog.open() == 0) {
                this.setListData();
            }
        } else if (n == 1) {
            int n2 = this.list1.getSelectionIndex();
            if (n2 < 0) {
                this.setErrorMessage(MessageFactory.getMessage("Appendix.List.Error1"));
                return;
            }
            channelModel = this.appendixMemory.get(n2);
            AppendixEditDialog appendixEditDialog = new AppendixEditDialog(this.getShell(), channelModel, this.editor, false);
            appendixEditDialog.create();
            if (appendixEditDialog.open() == 0) {
                this.setListData();
            }
        } else if (n == 2) {
            int n3 = this.list1.getSelectionIndex();
            if (n3 < 0) {
                this.setErrorMessage(MessageFactory.getMessage("Appendix.List.Error1"));
                return;
            }
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"RadioKaras", (String)MessageFactory.getMessage("Appendix.List.Delete"))) {
                channelModel = this.appendixMemory.get(n3);
                this.editor.delete(channelModel);
                this.setListData();
            } else {
                return;
            }
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, MessageFactory.getMessage("Appendix.List.Button.New"), false);
        this.createButton(composite, 1, MessageFactory.getMessage("Appendix.List.Button.Edit"), false);
        this.createButton(composite, 2, MessageFactory.getMessage("Appendix.List.Button.Delete"), false);
        Button button = this.createButton(composite, 3, MessageFactory.getMessage("Appendix.List.Button.Close"), true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AppendixDialog.this.cancelPressed();
            }
        });
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        control.getShell().setText(MessageFactory.getMessage("Appendix.List.Title"));
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FillLayout(512));
        this.list1 = new org.eclipse.swt.widgets.List(composite2, 2820);
        this.list1.setTouchEnabled(false);
        this.list1.addGestureListener(new GestureListener(){

            public void gesture(GestureEvent gestureEvent) {
                AppendixDialog.this.list1.setTopIndex(AppendixDialog.this.list1.getTopIndex());
            }
        });
        this.setListData();
        this.list1.setEnabled(true);
        GridData gridData = new GridData(272);
        gridData.widthHint = 600;
        gridData.heightHint = 200;
        composite2.setLayoutData((Object)gridData);
        return composite;
    }

    private void setListData() {
        try {
            this.appendixMemory = this.editor.getList();
            this.list1.removeAll();
            for (ChannelModel channelModel : this.appendixMemory) {
                this.list1.add(channelModel.getStation());
            }
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.getMessage());
        }
    }
}

