/*
 * Decompiled with CFR 0.152.
 */
package bl.radio.task;

import bl.radio.engine.PlayerStreamer;
import ch.qos.logback.classic.Logger;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.LoggerFactory;

public class FeadOutTask
extends TimerTask {
    private static Logger logger = (Logger)LoggerFactory.getLogger(FeadOutTask.class);
    private LinkedList<PlayerStreamer> msList;
    private LinkedList<Timer> timerList;
    private boolean isFinish;

    public FeadOutTask(LinkedList<PlayerStreamer> linkedList, LinkedList<Timer> linkedList2) {
        this.msList = linkedList;
        this.timerList = linkedList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        logger.debug("Feadout Start!!");
        this.isFinish = false;
        try {
            PlayerStreamer playerStreamer = this.msList.poll();
            Timer timer = this.timerList.poll();
            if (playerStreamer != null && playerStreamer.isPlay()) {
                int n = playerStreamer.getVolume();
                for (int i = 0; i < 50 && (n -= 10) > 10; ++i) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (playerStreamer == null || !playerStreamer.isPlay()) continue;
                    playerStreamer.setVolume(n);
                }
                if (playerStreamer != null) {
                    playerStreamer.stop();
                }
            }
            if (timer != null) {
                timer.cancel();
            }
            logger.debug("Feadout Finish!!");
        }
        catch (Exception exception) {
            logger.error("Feadout Error!", (Throwable)exception);
        }
        finally {
            this.isFinish = true;
        }
    }

    public boolean isFinish() {
        return this.isFinish;
    }
}

