// StringPool.cs
// 2008/11/19

using System;
using System.IO;
using System.Text;
using System.Collections.Generic;

namespace QAX {

// StringPool
public class StringPool {

	private List<String> _list;
	private SortedDictionary<String, Int32> _dict;

	public StringPool()
	{
		_list = new List<String>();
		_dict = new SortedDictionary<String, Int32>();
	}

	public Int32 Add(String s)
	{
		Int32 val = 0;
		if (_dict.TryGetValue(s, out val)) {
			return val;
		}

		Int32 idx = _list.Count;
		_list.Add(s);
		_dict.Add(s, idx);
		return idx;
	}

	public Chunk ToChunk()
	{
		var chunk = new Chunk();

		var ms = new MemoryStream();

		var en = Encoding.UTF8;

		Int32 index = 0;

		using (var w = new BinaryWriter(ms)) {
			String[] strs = _list.ToArray();
			Int32[]  lens = new Int32[strs.Length];

			for (Int32 i = 0; i < strs.Length; i++) {
				Byte[] by = en.GetBytes(strs[i]);

				w.Write(by);

				lens[i] = by.Length;

				index += by.Length;
			}

			Utils.WriteLengths(w, lens);
		}

		chunk.Payload = ms.ToArray();
		chunk.Index   = index;

		return chunk;
	}

} // StringPool

} // namespace QAX

