// PropertyBag.cs
// 2008/12/05

using System;
using System.IO;
using System.Text;
using System.Collections.Generic;

namespace QAX {

// PropertyBag
public class PropertyBag {

	private SortedDictionary<String, SortedDictionary<String, String>> _dict;

	public PropertyBag()
	{
		_dict = new SortedDictionary<String, SortedDictionary<String, String>>();
	}

	public void Read(TextReader reader, String name)
	{
		Int32 no = 0;
		for (; ; ) {
			String line = reader.ReadLine();
			if (line == null) {
				break;
			}

			no += 1;

			String val = line.Trim();
			if (val.StartsWith("#")) {
				continue;
			}

			if (val.Length == 0) {
				continue;
			}

			String[] vals = val.Split('\t');
			if (vals.Length < 3) {
				Console.Error.WriteLine("{0}({1}): Invalid Value.", name, no);
				continue;
			}

			String key = vals[0];

			SortedDictionary<String, String> item;
			if (!_dict.TryGetValue(key, out item)) {
				item = new SortedDictionary<String, String>();
				_dict.Add(key, item);
			}

			item[vals[1]] = vals[2];
		}
	}

	public ItemProperty[] GetProperty(String name, StringPool pool)
	{
		SortedDictionary<String, String> item;
		if (!_dict.TryGetValue(name, out item)) {
			return null;
		}

		var prop = new List<ItemProperty>();

		foreach (var v in item) {
			ItemProperty p;

			p.Type  = pool.Add(v.Key);
			p.Value = pool.Add(v.Value);

			prop.Add(p);
		}

		return prop.ToArray();
	}

} // PropertyBag

} // namespace QAX

