// Index.cs
// 2008/11/19

using System;
using System.IO;
using System.Collections.Generic;

namespace QAX {

// IndexEntry
public struct IndexEntry {

	public Int32 Size;
	public Int32 Duration;
	public Int32 Offset;

} // IndexEntry

// Index
public class Index {

	private List<IndexEntry> _list;

	public Index()
	{
		_list = new List<IndexEntry>();
	}

	public void Add(IndexEntry e)
	{
		_list.Add(e);
	}

	public Byte[] ToArray()
	{
		var ms = new MemoryStream();

		Byte[] buffer = new Byte[24];

		using (var w = new BinaryWriter(ms)) {
			IndexEntry[] data = _list.ToArray();

			Int32 len = Utils.ToBinary((UInt64)data.Length, buffer, 0, buffer.Length);

			w.Write(buffer, 0, len);

			for (Int32 i = 0; i < data.Length; i++) {
				len  = Utils.ToBinary((UInt64)data[i].Size,     buffer, 0,   buffer.Length      );
				len += Utils.ToBinary((UInt64)data[i].Duration, buffer, len, buffer.Length - len);
				len += Utils.ToBinary((UInt64)data[i].Offset,   buffer, len, buffer.Length - len);

				w.Write(buffer, 0, len);
			}
		}

		return ms.ToArray();
	}

} // Index

} // namespace QAX

