// DataPool.cs
// 2008/11/19

using System;
using System.IO;
using System.Collections.Generic;

namespace QAX {

// DataPool
public class DataPool {

	private List<Byte[]> _list;

	public DataPool()
	{
		_list = new List<Byte[]>();
	}

	public Int32 Add(Byte[] d)
	{
		Int32 idx = _list.Count;
		_list.Add(d);
		return idx;
	}

	public Chunk ToChunk()
	{
		var chunk = new Chunk();

		var ms = new MemoryStream();

		Int32 index = 0;

		using (var w = new BinaryWriter(ms)) {
			Byte[][] data = _list.ToArray();
			Int32[]  lens = new Int32[data.Length];

			for (Int32 i = 0; i < data.Length; i++) {
				w.Write(data[i]);

				lens[i] = data[i].Length;

				index += data[i].Length;
			}

			Utils.WriteLengths(w, lens);
		}

		chunk.Payload = ms.ToArray();
		chunk.Index   = index;

		return chunk;
	}

} // DataPool

} // namespace QAX

