/* VorbisTest.h */
/* 2008/11/12   */

#pragma once

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/* */

void TT_FFT8(
	const FLOAT* ar,
	const FLOAT* ai,
	FLOAT*       zr,
	FLOAT*       zi);

/* */

struct TT_FFT;

typedef struct TT_FFT TT_FFT_t;

TT_FFT_t* TT_CreateFFT(void);

BOOL TT_SetupFFT(
	TT_FFT_t* t,
	INT32     s);

void TT_ExecuteFFT(
	TT_FFT_t*    t,
	const FLOAT* ar,
	const FLOAT* ai,
	FLOAT*       zr,
	FLOAT*       zi);

void TT_ReleaseFFT(
	TT_FFT_t* t);

/* */

struct TT_IMDCT;

typedef struct TT_IMDCT TT_IMDCT_t;

TT_IMDCT_t* TT_CreateIMDCT(void);

BOOL TT_SetupIMDCT(
	TT_IMDCT_t* t,
	INT32       s);

void TT_ExecuteIMDCT(
	TT_IMDCT_t*  t,
	const FLOAT* a,
	FLOAT*       z);

void TT_ReleaseIMDCT(
	TT_IMDCT_t* t);

/* */

#ifdef __cplusplus_cli

struct TT_FFT   { };
struct TT_IMDCT { };

#endif /* __cplusplus_cli */

/* */

#ifdef __cplusplus
}
#endif /* __cplusplus */

