/* FrameDecoder.h */
/* 2008/11/07     */

#pragma once

#include "DecoderSetup.h"

/* */

#define TEST_FRAME_DECODER

/* */

/* FrameDecoder */
struct FrameDecoder {

	DecoderSetup_t* Setup;

	/* */

	ModeSetup_t* ModeSetup;

	INT32 BlockSize;

	MappingSetup_t* MappingSetup;
	Floor1Setup_t*  Floor1Setup;
	ResidueSetup_t* ResidueSetup;

	/* */

	INT16* Y[2];
	FLOAT* Sample[2];

	FLOAT* PCM[2][2];

	INT32 Index;
	INT32 PrevBlockSize;

	/* */

	TransformDecoder_t* Transform0;
	TransformDecoder_t* Transform1;

	/* */

	FLOAT* Output[2];
	INT32  OutputLength;

	/* */

#ifdef TEST_FRAME_DECODER
	FLOAT* Test[2];
	INT32  TestLength;
	INT32  TestType;
#endif

	/* */

}; /* FrameDecoder */

typedef struct FrameDecoder FrameDecoder_t;

/* */

BOOL FrameDecoder_Setup(
	DecoderContext_t* ctx,
	DecoderSetup_t*   setup,
	FrameDecoder_t*   frame);

void FrameDecoder_Reset(
	FrameDecoder_t* frame);

BOOL FrameDecoder_Decode(
	DecoderContext_t* ctx,
	BitDecoder_t*     d,
	FrameDecoder_t*   frame);

/* */

