/* TTADecoder.h */
/* 2008/12/18   */

#pragma once

#ifdef __cplusplus
extern "C"
{
#endif /* __cplusplus */

/* */

struct QTTADecoder;

typedef struct QTTADecoder QTTADecoder_t;

QTTADecoder_t* QT_CreateDecoder(void);

void QT_ReleaseDecoder(QTTADecoder_t* d);

BOOL QT_SetupDecoder(
	QTTADecoder_t* d,
	INT32          channels,
	INT32          samples);

struct QT_Output {

	INT32 Channels;
	INT32 Length;

	const INT16* Sample;

};

typedef struct QT_Output QT_Output_t;

BOOL QT_DecodeFrame(
	QTTADecoder_t* d,
	const VOID*    packet,
	SIZE_T         size,
	QT_Output_t*   output);

/* */

#ifdef __cplusplus_cli

/* for .NET Interop Dummy */

struct QTTADecoder { };

#endif /* __cplusplus_cli */

/* */

#ifdef __cplusplus
}
#endif /* __cplusplus */

