<?php
class user_base extends myQuicty {


function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->caching = 0; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 1800; // cache life time by seconds
	$this->cache_id = get_query_id();
	$this->page['data_name'] = 'userauth';

	if(!$this->user['id'] and in_array($this->dispatch_action,array(1=>'edit','delete'))) {
		$query = http_build_query($_GET);
		redirect('<!--{$folder_name}-->/user/error?'.$query);
	}
	return true;
}

function assign_search_form($page_obj=NULL) {
	if($page_obj) {
		$my = $page_obj;
	} else {
		$my = $this;
	}
	$search_form = $my->new_search_obj('userauth_search',array('action'=>$my->page['base_url'].'<!--{$folder_name}-->/user/','method'=>'get'));
	$my->assign_form('search_form',$search_form);
}

function add_list_options($pager_option) {
	/* this method for override use when included by external class */
	return $pager_option;
}

function list_records($condition='') {
	require_once 'list_options.class.php';
	$this->list = $this->new_data_set('userauth');
	$options = new user_list_options($this);
	$pager_option = $options->get_pager_option($condition);
	$pager_option = $this->add_list_options($pager_option);
	$this->list->bind_pager($pager_option);
	
	$fields = $options->make_select_fields();
	$sort_condition = $options->make_sort_condition();
	$list_table = $this->list->select_table_with_pager($sort_condition,$fields);
	return $list_table;
}

function set_pager() {
	$pager = $this->list->get_pager_links();
	$pager['pages_array'] = explode('&nbsp;&nbsp;',$pager['pages']);
	return $pager;
}

function add_form_options() {
	/* this method for override use when included by external class */
}

function display_record($condition='') {
	require_once 'form_options.class.php';
	$this->form = $this->new_data_set('userauth');
	$options = new user_form_options($this);
	$options->set_form_options();
	$this->add_form_options();
	$this->form->validate_and_freeze();
	$this->form->bind_button_control();
	
	$result = $this->form->automatic_form_handler($condition);
	$this->userauth = $result['userauth'] ? $result['userauth'] : $result['values'];
	return $result;
}


function assign_page_and_pathlist($page_name) {
	$this->set_pathlist('/',$this->W['top']);
	if($this->user['level'] >= admin_user 
		AND $this->Quicty['action']!='index') {
		$upper_path = $this->W['_userauth_registerd_list'];
		$this->add_pathlist('<!--{$folder_name}-->/user/',$upper_path,false);
	}
	$this->add_pathlist('',$page_name);
	$this->page['name'] = $page_name;
	$this->assign('page',$this->page);
}

} // end of user_base class
?>