Const ForReading = 1, ForWriting = 2, ForAppending = 8
CRLF = Chr(13) & Chr(10)

Set objFSO = WScript.CreateObject("Scripting.FileSystemObject")
If objFSO.FileExists("C:\xampp\apache\conf\extra\httpd-vhosts.conf") Then
	fileName = "C:\xampp\apache\conf\extra\httpd-vhosts.conf"
	pattern_xampp = "^[^#]*DocumentRoot.*C:/xampp/htdocs"
	addFile_xampp = "C:\QT\Quicty\etc\win\xampp_root_vhost.conf"
ElseIf objFSO.FileExists("C:\Program Files\xampp\apache\conf\extra\httpd-vhosts.conf") Then
	fileName = "C:\Program Files\xampp\apache\conf\extra\httpd-vhosts.conf"
	pattern_xampp = "^[^#]*DocumentRoot.*C:/Program Files/xampp/htdocs"
	addFile_xampp = "C:\QT\Quicty\etc\win\xampp_pf_vhost.conf"
Else
	Wscript.Echo "XAMPP܂" & CRLF & "C:\xampp  C:\Program Files\xampp ɃCXg[Ă"
	Wscript.Quit
End If

pattern_namevirtual = "^[^#]*NameVirtualHost *"
pattern_qtbuilder = "^[^#]*DocumentRoot.*C:/QT/qtbuilder/htdocs"

addLine_namevirtual = "NameVirtualHost *:80" & Chr(13) & Chr(10)
addFile_qtbuilder = "C:\QT\Quicty\etc\win\qtbuilder_vhost.conf"


result = fileCheck(fileName,pattern_namevirtual)
If result<>"" Then
	Wscript.Echo "Found : " & result
	need_namevirtual = False
Else 
	need_namevirtual = True
End If

result = fileCheck(fileName,pattern_xampp)
If result<>"" Then
	Wscript.Echo "Found : " & result
	need_xampp = False
Else 
	need_xampp = True
End If

result = fileCheck(fileName,pattern_qtbuilder)
If result<>"" Then
	Wscript.Echo "Found : " & result
	need_qtbuilder = False
Else 
	need_qtbuilder = True
End If


If need_namevirtual OR need_xampp OR need_qtbuilder Then
	result = fileWrite(fileName,need_namevirtual,need_xampp,need_qtbuilder,addLine_namevirtual,addFile_xampp,addFile_qtbuilder)
	Wscript.Echo "Add VirtualHost : '" & CRLF & result & "' to " & fileName 
End if


Function fileCheck(fileName,pattern)
Set objFSO = WScript.CreateObject("Scripting.FileSystemObject")
Set objInput = objFSO.OpenTextFile(fileName, ForReading)
fileCheck = ""
Do Until objInput.AtEndOfStream
	strLine = objInput.ReadLine
	If rexpCheck(pattern,strLine) Then
		' Wscript.Echo StrLine
		fileCheck = StrLine
	End If
Loop
objInput.Close
End Function


Function fileWrite(fileName,need_namevirtual,need_xampp,need_qtbuilder,addLine_namevirtual,addFile_xampp,addFile_qtbuilder)
	CRLF = Chr(13) & Chr(10)

	Set objFSO = WScript.CreateObject("Scripting.FileSystemObject")
	Set objInput = objFSO.OpenTextFile(fileName, ForReading)
	tempFileName = fileName & "_temp" 
	' Wscript.Echo tempFileName
	Set objOutput = objFSO.OpenTextFile(tempFileName, ForWriting, True)
	Do Until objInput.AtEndOfStream
		strLine = objInput.ReadLine
		objOutput.WriteLine strLine
	Loop
	objInput.Close

	If need_namevirtual Then
		objOutput.WriteLine addLine_namevirtual
		result = addLine_namevirtual & CRLF
	End If

	If need_xampp Then
		Set objInput = objFSO.OpenTextFile(addFile_xampp, ForReading)
		Do Until objInput.AtEndOfStream
			strLine = objInput.ReadLine
			objOutput.WriteLine strLine
		Loop
		objInput.Close
		result = result & "localhost for XAMPP" & CRLF
	End If

	If need_qtbuilder Then
		Set objInput = objFSO.OpenTextFile(addFile_qtbuilder, ForReading)
		Do Until objInput.AtEndOfStream
			strLine = objInput.ReadLine
			objOutput.WriteLine strLine
		Loop
		objInput.Close
		result = result & "localhost for QtBuilder" & CRLF
	End If

	objOutput.Close

	backupFileName = fileName & "_bak"
	If objFSO.FileExists(backupFileName) Then
   		objFSO.DeleteFile backupFileName
	End If
   	objFSO.MoveFile fileName , backupFileName
   	objFSO.MoveFile tempFileName , fileName
	
	fileWrite = result
End Function


Function rexpCheck(pattern,strLine)
	Dim objRE
	Set objRE = new RegExp
	objRE.IgnoreCase = True
	objRE.pattern = pattern
	rexpCheck = objRE.Test(strLine)
End Function

