'Option Explicit
ReDim patterns(8)
ReDim results(8)
ReDim needs(8)
For intCounter = 0 To 7
	results(intCounter) = False
	needs(intCounter) = True
Next

Const ForReading = 1, ForWriting = 2, ForAppending = 8
CRLF = Chr(13) & Chr(10)

Set objFSO = WScript.CreateObject("Scripting.FileSystemObject")
If objFSO.FileExists("C:\xampp\apache\bin\php.ini") Then
	fileName = "C:\xampp\apache\bin\php.ini"
ElseIf objFSO.FileExists("C:\Program Files\xampp\apache\bin\php.ini") Then
	fileName = "C:\Program Files\xampp\apache\bin\php.ini"
Else
	Wscript.Echo "XAMPP܂" & CRLF & "C:\xampp  C:\Program Files\xampp ɃCXg[Ă"
	Wscript.Quit
End If
'Wscript.Echo fileName

patterns(0) = "extension=php_pdo_pgsql.dll"
patterns(1) = "extension=php_pdo_sqlite.dll"
patterns(2) = "extension=php_pgsql.dll"
patterns(3) = "mbstring.language = Japanese"
patterns(4) = "mbstring.internal_encoding = EUC-JP"
patterns(5) = "mbstring.http_input = auto"
patterns(6) = "mbstring.detect_order = auto"
patterns(7) = "mbstring.substitute_character = none"

result = fileCheck(fileName,patterns)
If result Then
	result = fileWrite(fileName,patterns,needs)
	Wscript.Echo "Add conf to " & fileName & ":" & CRLF & result
End If

Function fileCheck(fileName,patterns)
	Set objFSO = WScript.CreateObject("Scripting.FileSystemObject")
	Set objInput = objFSO.OpenTextFile(fileName, ForReading)
	needsCounter = 8
	Do Until objInput.AtEndOfStream
		strLine = objInput.ReadLine
		For intCounter = 0 To 7
			pattern = "^[ ]*" & patterns(intCounter)
			If rexpCheck(pattern,strLine) Then
				Wscript.Echo "Found : " & strLine
				needs(intCounter) = False
				needsCounter = needsCounter - 1
			End If
		Next
	Loop
	objInput.Close
	fileCheck = needsCounter
End Function


Function fileWrite(fileName,patterns,needs)
	Dim result
	result = ""
	CRLF = Chr(13) & Chr(10)
	LF = Chr(10)
	Set objFSO = WScript.CreateObject("Scripting.FileSystemObject")
	Set objInput = objFSO.OpenTextFile(fileName, ForReading)
	tempFileName = fileName & "_temp" 
	' Wscript.Echo tempFileName
	Set objOutput = objFSO.OpenTextFile(tempFileName, ForWriting, True)
	Do Until objInput.AtEndOfStream
		strLine = objInput.ReadLine
		objOutput.WriteLine strLine
		For intCounter = 0 To 7
			If needs(intCounter) Then
				pattern = "^;.*" & patterns(intCounter)
				If rexpCheck(pattern,strLine) Then
					objOutput.WriteLine patterns(intCounter) & LF
					result = result & "Write : " & patterns(intCounter) & CRLF
					needs(intCounter) = False
				End If
			End If
		Next
	Loop
	objOutput.WriteLine addLine
	objInput.Close
	objOutput.Close

	backupFileName = fileName & "_bak"
	If objFSO.FileExists(backupFileName) Then
   		objFSO.DeleteFile backupFileName
	End If
   	objFSO.MoveFile fileName , backupFileName
   	objFSO.MoveFile tempFileName , fileName
	
	fileWrite = result
End Function


Function rexpCheck(pattern,strLine)
	Dim objRE
	Set objRE = new RegExp
	objRE.IgnoreCase = True
	objRE.pattern = pattern
	rexpCheck = objRE.Test(strLine)
End Function

