<?php
require_once 'includes/datasets_conf/_base.class.php';
class datasets_conf_create_template extends datasets_conf {

function __construct($options) {
	$this->Quicty_modules = $options['Quicty_modules'];
}

function create_template($datasets_id) {
	$this->init($datasets_id);

	if($_REQUEST['input_form']=='yes')
		$message .= $this->write_input_form();
	if($_REQUEST['form_view']=='yes')
		$message .= $this->write_form_view();
	if($_REQUEST['table_view']=='yes')
		$message .= $this->write_table_view();
	if($_REQUEST['list_view']=='yes')
		$message .= $this->write_list_view();
	$result['message'] = $message;
	return $result;
}

function make_form_html($form_template,$dataname,$info=true) {
	$done = false;
	foreach($form_template as $line) {
		if(preg_match("/<tr(.*?)>/",$line,$matches) AND $done==false) {
			$tr_style = $matches[1];
		} elseif(preg_match("/<th(.*?)><\/th>/",$line,$matches) AND $done==false) {
			$th_style = $matches[1];
		} elseif(preg_match("/<td(.*?)><\/td>/",$line,$matches) AND $done==false) {
			$td_style = $matches[1];
		} elseif(preg_match("/<\/tr>/",$line,$matches) AND $done==false) {
			foreach($this->data_sets as $key=>$column) {
				if($column['label'] and $column['type']!='hidden') {
					$name = $column['name'];
					$contents .= "\n";
					$contents .= "<tr$tr_style>\n";
					$contents .= "<th$th_style><label for=\"$name\">{".'$'.$dataname."_form.$name.label}</label></th>\n";
					$contents .= "<td$td_style>{".'$'.$dataname."_form.$name.html}";
					if($info) {
						$contents .= "{if ".'$'.$dataname."_form.$name.error}<br /><span class=\"error\">{".'$'.$dataname."_form.$name.error}</span>{/if}";
					}
					$contents .= "</td>\n";
					$contents .= "</tr>\n";
				}
			}
			$done = true;
		} elseif($match = str_replace('$dataname',$dataname,$line)) {
			$contents .= $match;
		} else {
			$contents .= $line;
		}
	}
	return $contents;
}


function write_input_form() {
	$dataname = $this->dsn['dataname'];
	$dataname_form = $dataname.'_form';
	
	if(file_exists($this->application_path.'/etc/modules/view/parts/input_form.inc')) {
		$input_form_template = file($this->application_path.'/etc/modules/view/parts/input_form.inc');
	} else {
		$input_form_template = file($this->Quicty_modules.'/view/parts/input_form.inc');
	}

	$contents = $this->make_form_html($input_form_template,$dataname,$info=true);
	
	$input_form_dir_name = $this->application_path."/view/includes/$dataname";
	umask(0);
	make_dir($input_form_dir_name,0777);
	$input_form_file_name = $input_form_dir_name.'/input_form.inc';
	if(file_exists($input_form_file_name)) {
		$old_dir = $input_form_dir_name.'/old';
		make_dir($old_dir,0777);
		copy_files($input_form_file_name,$old_dir,0777);
	}
	file_write_contents($input_form_file_name,$contents);
	chmod($input_form_file_name,0666);
	$message = "wrote $dataname/input_form.inc -> ".$input_form_file_name."\n";

	return $message;
} // end of write_input_form

function write_form_view() {
	$dataname = $this->dsn['dataname'];
	$dataname_form = $dataname.'_form';

	if(file_exists($this->application_path.'/etc/modules/view/parts/form_view.inc')) {
		$form_view_template = file($this->application_path.'/etc/modules/view/parts/form_view.inc');
	} else {
		$form_view_template = file($this->Quicty_modules.'/view/parts/form_view.inc');
	}
	$contents = $this->make_form_html($form_view_template,$dataname,$info=false);
	$form_view_dir_name = $this->application_path."/view/includes/$dataname";
	umask(0);
	make_dir($form_view_dir_name,0777);
	$form_view_file_name = $form_view_dir_name.'/form_view.inc';
	if(file_exists($form_view_file_name)) {
		$old_dir = $form_view_dir_name.'/old';
		make_dir($old_dir,0777);
		copy_files($form_view_file_name,$old_dir,0777);
	}
	file_write_contents($form_view_file_name,$contents);
	chmod($form_view_file_name,0666);
	$message .= "wrote $dataname/form_view.inc -> ".$form_view_file_name."\n";

	return $message;
} // end of write_form_view



function write_table_view() {
	$dataname = $this->dsn['dataname'];
	$dataname_view = $dataname.'_view';

	if(file_exists($this->application_path.'/etc/modules/view/parts/table_view.inc')) {
		$table_view_template = file($this->application_path.'/etc/modules/view/parts/table_view.inc');
	} else {
		$table_view_template = file($this->Quicty_modules.'/view/parts/table_view.inc');
	}
	
	foreach($table_view_template as $line) {
		if(preg_match("/<th(.*?)>(.*?)<\/th>/",$line,$matches)) {
			$th_style = $matches[1];
			$contents .= "<th$th_style>&nbsp;</th>\n";
			foreach($this->data_sets as $column) {
				if(isset($column['label'])) {
					$name = $column['name'];
					$selecter = str_replace('_','',$name);
					$contents .= '<th class="col-'.$selecter.'"'.$th_style.'>{$row.'.$name.'.label}'
					.'<span id="asc-'.$selecter.'"><a href="./index1.html?sort='.$name.'&amp;order=asc">{$W.asc_mark}</a></span>'
					.'<span id="desc-'.$selecter.'"><a href="./index1.html?sort='.$name.'&amp;order=desc">{$W.desc_mark}</a></span></th>'."\n";
				}
			}
		} elseif(preg_match("/<td(.*?)><\/td>/",$line,$matches)) {
			$td_style = $matches[1];
			if(!$td_style) {
				//$td_style = " style=\"text-align:center;\"";
				$no_td_style = true;
			}
			$contents .= "<td$td_style><a href=\"{\$display_cmd}?id={\$row.id.body}\">{\$row.sequence.value}</a></td>\n";
			if($no_td_style) $td_style = NULL;
			foreach($this->data_sets as $column) {
				if(isset($column['label'])) {
					$name = $column['name'];
					$contents .= "<td$td_style>{\$row.$name.html}</td>\n";
				}
			}
		} elseif($match = str_replace('$dataname',$dataname,$line)) {
			$contents .= $match;
		} else {
			$contents .= $line;
		}
	}

	$table_view_dir_name = $this->application_path."/view/includes/$dataname";
	umask(0);
	make_dir($table_view_dir_name,0777);
	$table_view_file_name = $table_view_dir_name.'/table_view.inc';
	if(file_exists($table_view_file_name)) {
		$old_dir = $table_view_dir_name.'/old';
		make_dir($old_dir,0777);
		copy_files($table_view_file_name,$old_dir,0777);
	}
	file_write_contents($table_view_file_name,$contents);
	chmod($table_view_file_name,0666);
	return "wrote $dataname/table_view.inc -> ".$table_view_file_name."\n";
} // end of write_table_view

function write_list_view() {
	$dataname = $this->dsn['dataname'];
	$dataname_list = $dataname.'_list';

	if(file_exists($this->application_path.'/etc/modules/view/parts/list_view.inc')) {
		$list_view_template = file($this->application_path.'/etc/modules/view/parts/list_view.inc');
	} else {
		$list_view_template = file($this->Quicty_modules.'/view/parts/list_view.inc');
	}

	$columns = false;
	foreach($list_view_template as $line) {
		if(preg_match("/<!-- columns -->/",$line,$matches)) {
			$columns = true;
		} elseif(preg_match("/<tr(.*?)>/",$line,$matches) AND $columns==true) {
			$tr_style = $matches[1];
		} elseif(preg_match("/<th(.*?)><\/th>/",$line,$matches) AND $columns==true) {
			$th_style = $matches[1];
		} elseif(preg_match("/<td(.*?)><\/td>/",$line,$matches) AND $columns==true) {
			$td_style = $matches[1];
		} elseif(preg_match("/<\/tr>/",$line,$matches) AND $columns==true) {
			/* nothing to do */
		} elseif(preg_match("/<!-- \/columns -->/",$line,$matches)) {
			foreach($this->data_sets as $column) {
				if(isset($column['label'])) {
					$name = $column['name'];
					if($column['type']=='textarea') {
						$column_body = 'body|nl2br';
					} else {
						$column_body = 'body';
					}
					$contents .= "\n";
					$contents .= "<tr>\n";
					$contents .= '<th>{$row.'.$name.".label}</th>\n";
					$contents .= '<td>{$row.'.$name.".$column_body}</td>\n";
					$contents .= "</tr>\n";
				}
			}
			$columns = false;
		} elseif($match = str_replace('$dataname',$dataname,$line)) {
			$contents .= $match;
		} else {
			$contents .= $line;
		}
	}

	$list_view_dir_name = $this->application_path."/view/includes/$dataname";
	umask(0);
	make_dir($list_view_dir_name,0777);
	$list_view_file_name = $list_view_dir_name.'/list_view.inc';
	if(file_exists($list_view_file_name)) {
		$old_dir = $list_view_dir_name.'/old';
		make_dir($old_dir,0777);
		copy_files($list_view_file_name,$old_dir,0777);
	}
	file_write_contents($list_view_file_name,$contents);
	chmod($list_view_file_name,0666);
	return "wrote $dataname/list_view.inc -> ".$list_view_file_name."\n";
}  // end of write_list_view

} // end of class datasets_conf_write
?>