<?php
$lib_dir = dirname(__FILE__);
$dir_path = explode(DIRECTORY_SEPARATOR,$lib_dir);
$dummy = array_pop($dir_path);
$dummy = array_pop($dir_path);
$QT_root_dir = implode('/',$dir_path);
ini_set('include_path', $QT_root_dir.PATH_SEPARATOR.$QT_root_dir.'/Quicty/phplib'.PATH_SEPARATOR.$lib_dir.PATH_SEPARATOR.ini_get('include_path'));
require_once 'Quicty/Quicty.php';

class myQuicty extends  Quicty {

public function pre_dispatch_index() {
	$this->site['name'] = 'Qtӥ';
	$this->assign('site',$this->site);
	$this->assign('b',quicty_base_url());
	$this->assign('g',$_GET);
	$this->assign('p',$_POST);
	$this->assign('q',$this->Quicty);
	$this->assign('r',$_REQUEST);

	$this->configure = $this->select_row('configure');
	if($this->request_path!='configure' and 
		(!$this->configure['quicty_root'] or !$this->configure['qt_applictions_root'])) {
		redirect('/configure/');
	}
	
	$this->Quicty_root = $this->configure['quicty_root'];
	$this->Quicty_modules = $this->Quicty_root.'/modules';
	$this->qt_application_root = $this->configure['qt_applictions_root'];

	$this->init_field_define();

	if(file_exists('../etc/conf/userauth.on')) {
		define('admin_user',10);
		define('registerd_user',1);
		define('guest_user',0);
		$this->assign('admin_user',admin_user);
		$this->assign('registerd_user',admin_user);
		$this->assign('guest_user',admin_user);
		$auth = $this->new_auth_obj('auth.set.conf');
		$this->user = $auth->get_user_data();
		if($this->user['authorized']===false) {
			$this->user['handle'] = '';
			$this->user['level'] = 0;
		}
		$this->assign('user',$this->user);
	}

	return true;
}

public function dispatch_index() {
	return $this->display($this->current_template);
}

public function post_dispatch_index() {
	return true;
}

function set_pager_option($perPage,$condition) {
	$pager_option = array(
		'perPage'=>$perPage,
		'condition'=>$condition,
		'prevImg'=>''.$perPage.'',
		'nextImg'=>''.$perPage.'',
		'separator'=>"&nbsp;",
		'curPageLinkClassName'=>'current_page',
		'firstPageText'=>'ƬΥڡ','firstPagePre'=>'','firstPagePost'=>'',
		'lastPageText'=>'ǸΥڡ','lastPagePre'=>'','lastPagePost'=>'',
	);
	return $pager_option;
}

// init data

function init_field_define() {
	list($year,$month,$day,$hour,$min) = explode('-',date("Y-m-d-H-i"));
	$maxYear = $year + 5;
	$this->field_kind = array(1=>
		array('name'=>'id','kind'=>'variation','type'=>'id'),
		array('name'=>'advcheckbox','kind'=>'hqf','type'=>'advcheckbox','label'=>'checkbox','text'=>NULL,'values'=>array('0'=>'no','1'=>'yes'),'default'=>'0'),
		array('name'=>'captcha_image','label'=>'ǧڲ','kind'=>'hqf','type'=>'captcha_image'),
		array('name'=>'captcha','kind'=>'variation','type'=>'captcha','label'=>'ʸ','attr'=>array('size'=>10,'maxlength'=>30),'rule'=>array('required'=>'yes')),
		array('name'=>'date','kind'=>'hqf','type'=>'date','label'=>'date',opt=>array('language'=>'ja','minYear'=>'1970','maxYear'=>$maxYear,'format'=>'Yǯmd'),'default'=>array('date'=>'now')),
		array('name'=>'date_time','kind'=>'variation','type'=>'date','label'=>'',opt=>array('language'=>'ja','minYear'=>'1970','maxYear'=>$maxYear,'format'=>'Yǯmd Hiʬ'),'default'=>array('date'=>'now')),
		array('name'=>'entry_datetime','kind'=>'variation','type'=>'date','label'=>'Ͽ',opt=>array('language'=>'ja','minYear'=>'2008','maxYear'=>'2050','format'=>'Yǯmd Hiʬ')
			,'force_value'=>array('date'=>'now','auto_only_1st'=>'yes')),
		array('name'=>'update_datetime','kind'=>'variation','type'=>'date','label'=>'',opt=>array('language'=>'ja','minYear'=>'2008','maxYear'=>'2050','format'=>'Yǯmd Hiʬ')
			,'force_value'=>array('date'=>'now')),
		array('name'=>'birthday','kind'=>'variation','type'=>'date','label'=>'',opt=>array('language'=>'ja','minYear'=>'1930','maxYear'=>$maxYear,'format'=>'Yǯmd')
			,'default'=>array('Y'=>'1970','m'=>'1','d'=>'1')),
			
		array('name'=>'file','kind'=>'basic','type'=>'file','virtual'=>'yes','label'=>'file','attr'=>array('size'=>'50')),
		
		array('name'=>'hidden','kind'=>'basic','type'=>'hidden','label'=>'hidden','value'=>''),
		array('name'=>'hidden_int','kind'=>'variation','type'=>'hidden_int','label'=>'hidden_int','value'=>'','default'=>0),
		array('name'=>'ip_address','kind'=>'variation','type'=>'hidden','label'=>'ip_address','force_value'=>array('_SERVER'=>'REMOTE_ADDR')),
		array('name'=>'embed_value','kind'=>'variation','type'=>'hidden','label'=>'embed_value','force_value'=>array('_THIS_VALUE'=>'array_name.key_name')),
		array('name'=>'embed_int_value','kind'=>'variation','type'=>'hidden_int','label'=>'embed_value','force_value'=>array('_THIS_VALUE'=>'array_name.key_name')),
		
		array('name'=>'password','kind'=>'basic','type'=>'password','label'=>'password','attr'=>array('size'=>'30','maxlength'=>'50'),'rule'=>array('alphanumeric'=>'yes')),
		array('name'=>'password_plain','kind'=>'basic','type'=>'password_plain','label'=>'password','attr'=>array('size'=>'30','maxlength'=>'50'),'rule'=>array('alphanumeric'=>'yes')),
		
		array('name'=>'radio','kind'=>'basic','type'=>'radio','label'=>'radio','list'=>array('key'=>'text'),'default'=>array('name'=>'key')),
		array('name'=>'gender','kind'=>'variation','type'=>'radio','label'=>'','list'=>array('1'=>'','2'=>''),'default'=>array('gender'=>'1')),
		
		array('name'=>'select','kind'=>'basic','type'=>'select','label'=>'select','value'=>array('key'=>'text'),'default'=>array('name'=>'key')),
		array('name'=>'select_text','kind'=>'variation','type'=>'select_text','label'=>'select_text','value'=>array('key'=>'text'),'default'=>array('name'=>'key')),
		array('name'=>'select_from_table','kind'=>'variation','type'=>'select','label'=>'select_from_table','value'=>array('_TABLE'=>'table_name','_ORDER_BY'=>'id','_VALUE'=>'id','_LABEL'=>'name','_START'=>'no_value')),
		array('name'=>'select_from_table_by_condition','kind'=>'variation','type'=>'select','label'=>'select_from_table_by_condition','value'=>array('_TABLE'=>'table_name','_WHERE_COLUMN'=>'where_column_name','_WHERE_THIS_VALUE'=>'where_value_name','_ORDER_BY'=>'id','_VALUE'=>'id','_LABEL'=>'name','_START'=>'no_value')),
		
		array('name'=>'text','kind'=>'basic','type'=>'text','label'=>'text','attr'=>array('size'=>'50','maxlength'=>'50'),'default'=>''),
		array('name'=>'email','kind'=>'variation','type'=>'text','label'=>'email','attr'=>array('size'=>'50','maxlength'=>'50'),'rule'=>array('email'=>'yes'),'default'=>''),
		array('name'=>'zipcode','kind'=>'variation','type'=>'text','label'=>'͹ֹ','attr'=>array('size'=>'8','maxlength'=>'8'),'rule'=>array('zipcode'=>'yes'),'default'=>''),
		
		array('name'=>'textarea','kind'=>'basic','type'=>'textarea','label'=>'textarea','attr'=>array('rows'=>'10','cols'=>'50'),'default'=>''),
		array('name'=>'int','kind'=>'quicty','type'=>'int','label'=>'int','attr'=>array('size'=>'10','maxlength'=>'50'),'rule'=>array('numeric'=>'yes','maxlength'=>'8','minlength'=>'1'),'default'=>'0'),
		array('name'=>'float','kind'=>'quicty','type'=>'float','label'=>'float','attr'=>array('size'=>'50','maxlength'=>'50'),'rule'=>array('numeric'=>'yes','maxlength'=>'12','minlength'=>'1'),'default'=>'0'),
		array('name'=>'id_reference','kind'=>'variation','type'=>'int','label'=>'id_reference','reference'=>array('_TABLE'=>'table_name','_GET_COLUMN'=>'get_column_name','_WHERE_COLUMN'=>'where_column_name')),
		array('name'=>'url','kind'=>'quicty','type'=>'url','label'=>'url','attr'=>array('size'=>'50','maxlength'=>'128'),'default'=>''),
	);

	foreach($this->field_kind as $key=>$value) {
		$this->fields_reverse_map[$value['name']] = $value;
	}

	$this->field_desc = array(
		'id'=>'ɬܡʥƥѡ',
		'advcheckbox'=>'åܥå<input type="checkbox" checked />',
		'date'=>"ա<select><option>$year</option></select><select><option>$month</option></select><select><option>$day</option></select>",
		'date_time'=>"<select><option>$year</option></select><select><option>$month</option></select><select><option>$day</option></select><select><option>$hour</option></select><select><option>$min</option></select>",
		'entry_datetime'=>"Ͽʼưϡˡ$year ǯ $month  $day  $hour  $min ʬ",
		'update_datetime'=>"ʼưˡ$yearǯ  $month  $day  $hour  $min ʬ",
		'birthday'=>"<select><option>$year</option></select><select><option>$month</option></select><select><option>$day</option></select>",
		'password'=>'ѥɡ<input type="password" value="password" size="20" />',
		'password_plain'=>'ѥɡ<input type="password" value="password" size="20" />',
		'radio'=>'饸ܥ<input type="radio" />A&nbsp;<input type="radio" />B',
		'gender'=>'̡<input type="radio" />&nbsp;<input type="radio" />',
		'file'=>'ե륢åץɡ<input type="file" />',
		'hidden'=>'ɽƥȥǡ<span style="color:#aaa;">abcde</span>',
		'hidden_int'=>'ɽ ǡ<span style="color:#aaa;">12345</span>',
		'ip_address'=>'饤IPɥ쥹ʼưϿˡ<span style="color:#aaa;">123.456.789.012</span>',
		'embed_value'=>'ɽ ǡ<span style="color:#aaa;">$this->array[key]</span>',
		'embed_int_value'=>'ɽ ǡ<span style="color:#aaa;">$this->array[key]</span>',
		'select'=>"쥯Υ<select><option value=\"1\">1</option><option value=\"2\">2</option></select>",
		'select_text'=>"쥯Υʸ<select><option value=\"first\">1</option><option value=\"second\">2</option></select>",
		'select_from_table'=>"̥ơ֥뤫<select><option>1</option><option>2</option></select>",
		'select_from_table_by_condition'=>"դ̥ơ֥뤫<select><option>1</option><option>2</option></select>",
		'text'=>'ƥȡ<input type="text" value="abcde" size="20" />',
		'email'=>'᡼륢ɥ쥹<input type="text" value="my_name@domain.xx" size="20" />',
		'zipcode'=>'͹ֹ桧<input type="text" value="000-00" size="20" />',
		'textarea'=>"ʣԥƥȡ<textarea rows='2',cols='5'>line1\nline2</textarea>",
		'int'=>'<input type="text" value="12345" size="20" />',
		'float'=>'͡<input type="text" value="123.45" size="20" />',
		'url'=>'URL<input type="text" value="http://www.domain.xx" size="20" />',
	);

	$this->rule_kind = array(1=>
		array('name'=>'alphanumeric','param'=>'yes','description'=>'Ⱦѱѿ'),
		array('name'=>'alphanumsymbol','param'=>'yes','description'=>'Ⱦѱѿȵ'),
		array('name'=>'check_hiragana','param'=>'yes','description'=>'Ҥ餬ʸ'),
		array('name'=>'checkemaildomain','param'=>'column','description'=>'᡼ɥᥤ¸߳ǧ'),
		array('name'=>'checkmd5key','param'=>'column','description'=>'md5'),
		array('name'=>'checkmd5pass','param'=>'column','description'=>'md5'),
		array('name'=>'checkuniq','param'=>'yes','description'=>'ʣػ'),
		array('name'=>'compare','param'=>'column','description'=>'ۤΥեɤ'),
		array('name'=>'email','param'=>'yes','description'=>'name@domain'),
		array('name'=>'entry_only_1st','param'=>'yes','description'=>'ϿΤ'),
		array('name'=>'lettersonly','param'=>'yes','description'=>'ػ'),
		array('name'=>'maxlength','param'=>'int','description'=>'ʸ'),
		array('name'=>'minlength','param'=>'int','description'=>'Ǿʸ'),
		array('name'=>'numeric','param'=>'yes','description'=>'Ⱦѿ'),
		array('name'=>'nonzero','param'=>'yes','description'=>'Ͷػ'),
		array('name'=>'regex','param'=>'text','description'=>'ɽǥå'),
		array('name'=>'required','param'=>'yes','description'=>'ɬ'),
		array('name'=>'required','param'=>'only_1st','description'=>'ϿΤɬ'),
		array('name'=>'zipcode','param'=>'yes','description'=>'͹ֹȾѤxxx-xx˸'),
		
	);
}


} // end of class myQuicty
?>