<?php
class send_update_ping extends QuictyPlugin {
	public $plugin_title = 'WeblogUpdatePing';

	protected function make_contents() {
		return $this->update_ping(
			$this->params['target_url'],
			$this->params['url'],
			$this->params['blog_name']
		);
	}

	function update_ping($target_url,$url,$blog_name) {
		$port = 80;
		$query = "";
		
		if(substr($url,0,7)!='http://') $url = 'http://'.$url;
		$ping_data = <<<END_OF_XML
<?xml version="1.0"?>
<methodCall>
<methodName>weblogUpdates.ping</methodName>
<params>
<param>
<value>$blog_name</value>
</param>
<param>
<value>$url</value>
</param>
</params>
</methodCall>
END_OF_XML;
		$ping_data = mb_convert_encoding($ping_data, "UTF-8", "EUC-JP" );
		$ping_url = parse_url(trim($target_url));
		if(isset( $ping_url['query'])) $query = "?".$ping_url['query'];
		if(isset( $ping_url['port'])) $port = $ping_url['port'];
		
		$request  = "POST ".$ping_url['path'].$query." HTTP/1.0\r\n";
		$request .= "Host: ".$ping_url['host']."\r\n";
		$request .= "User-Agent: PHP/".phpversion()."\r\n";
		$request .= "Content-type: text/xml\r\n";
		$request .= "Content-Length: ".strlen($ping_data)."\r\n\r\n";
		$request .= $ping_data."\r\n";
		//echo "host=".$ping_url['host']."\n";
		$socket = fsockopen( $ping_url['host'], $port );
		if($socket) {
			fputs($socket,$request);
			$response = '';
			while(!feof($socket)) {
				$line = fgets($socket);
				//echo $line;
				if($contents_started) {
					$response .= $line;
				} elseif(preg_match('/^<.*>$/',$line)) {
					$contents_started = true;
					$response .= $line;
				}
			}
			fclose($socket);
		}
		return $response;
	}

}
?>
