$(function(){

	// Parse GET query string
	function parse_get_query() {
		query_string = document.URL.replace(/.*?\?(.*)/,"$1");
		query = query_string.split('&');
		get_query = new Array();
		for(i in query) {
			tmp = query[i].split('=');
			get_query[tmp[0]] = tmp[1];
		}
		return get_query;
	}
	var GET_QUERY = parse_get_query();

	// Parse cookies
	function parse_cookies() {
		cookies = document.cookie.split('; ');
		cookie_data = Array();
		for(i in cookies) {
			tmp = cookies[i].split('=');
			cookie_data[tmp[0]] = decodeURIComponent(tmp[1]);
		}
		return cookie_data;
	}
	var COOKIES = parse_cookies();
	
	function get_css_color(element,property) {
		color_property = $(element).css(property);
		color_property = color_property.replace(/rgb\((.*)\)/,"$1");
		colors_array = color_property.split(',');
		color_hexed = parseInt(colors_array.shift()).toString(16);
		color_hexed += parseInt(colors_array.shift()).toString(16);
		color_hexed += parseInt(colors_array.shift()).toString(16);
		return color_hexed;
	}
	
	// open new windows for external link
	//$('a[href^="http://"]').click(function(){
	//	window.open(this.href, "_blank");
	//	return false;
	//});

	// site-id block
	if(!$.browser.msie) {
		site_id_color = get_css_color('#site-id','background-color');
		$('#site-id')
			.gradient({from: site_id_color,to: 'ffffff'});
	}

	// global-nav corner
	$('#global-nav ul li')
		.corner();

	// table stripe
	$('.table-view table').each(function(){
		$(this).find('tr:odd').addClass('even');
		$(this).find('tr:even').addClass('odd');
	});
	$('.table-view table tr:first-child,.input-form table tr:first-child').addClass('firstChild');
	$('.table-view table tr:last-child').addClass('lastChild');

	// path-list(Breadcram) arrow mark
	$('ol#topic-path li a')
		.css('background','url('+COOKIES['base_path']+'/img/common/glue.gif) no-repeat right center');

	// table sorter
	$('span[id^="asc-"] a')
		.addClass('asc-mark');
	$('span[id^="desc-"] a')
		.addClass('desc-mark');
	current_sort = GET_QUERY['order']+'-'+GET_QUERY['sort'];
	current_sort = current_sort.replace(/_/,'');
	$('#'+current_sort+' a').css('color','gray');
	
	// Page Nav
	current_page_nav = '.link2' + COOKIES['page_id'];
	$(current_page_nav)
		.addClass('current');
	
	// check values
	//$('div[id="contents-block"]').prepend(site_id_color_r);

});
