<?php
class <!--{$class_name}--> extends myQuicty {

function pre_dispatch_index() {
	parent::pre_dispatch_index();
	$this->caching = 0; // caching page flag: 0 = none; 1 = simple; 2 = each query
	$this->cache_lifetime = 1800; // cache life time by seconds
	$this->cache_id = get_query_id();
	$this->page['base_url'] = quicty_base_url();
	$this->page['data_name'] = '<!--{$data_name}-->';

	//$access_key = 'your access key';
	//$associate_id = 'your associate id';
	$access_key = '090596K8VFHWK71V2782';
	$associate_id = 'zubapitacom-22';
	$cache_dir = '/tmp';
	//$cache_dir = $home_dir.'/var/amazon_cache';
	require_once 'Quicty/lib/Amazon.class.php';
	$this->amazon = new amazon_search($access_key,$associate_id,$cache_dir);

	return true;
}

function display_record($condition='') {
	$this->form = $this->new_data_set('<!--{$data_name}-->');
	$this->form->set_base_link_addr(quicty_base_url().'<!--{$dir_name}-->/');
	$this->form->set_restart_link_addr(quicty_base_url().'<!--{$dir_name}-->/');
	$this->form->set_button_status('use_confirm',false);

	$this->form->form_element['search_option']->loadArray($this->amazon->search_kind_array);
	$this->form->form_element['sort_option']->loadArray($this->amazon->sort_option_array);
	$constants = array("ItemPage"=>'1');
	$this->form->setConstants($constants);

	$this->form->validate_and_freeze();
	$this->set_qs_status('SEND');
	$this->form->bind_button_control();
	
	if($_POST['asin']) {
		$this->amazon->response_options = $this->set_response_option();
		$result = $this->amazon->asin_search($_POST['asin']);
	} elseif($_POST['keywords']) {
		$this->amazon->search_kind = $this->set_search_option();
		$this->amazon->response_options = $this->set_response_option();
		$result = $this->amazon->keyword_search($_POST['keywords']);
	}
	return $result;
}


function dispatch_index() {
	$result = $this->display_record('');
	if($result['error']) {
		$table = array();
	} elseif($result) {
		$table = $this->make_table($result);
	}

	$this->assign_form('input_form',$this->form);
	$this->assign('table_view',$table['Items']);
	$this->assign('num',$table['num']);

	$this->page['name'] = '<!--{$page_title}-->';
	$this->assign('page',$this->page);
	return $this->display($this->current_template);
}

//----------------------------------
// Utils

function set_search_option() {
	if($_POST['search_option'] and 
		array_key_exists($_POST['search_option'],$this->amazon->search_kind_array)) {
		$search_option = $_POST['search_option'];
	} else {
		$search_option = 'Blended';
	}
	return $search_option;
}


function set_response_option() {
	if($_POST['sort_option'] and 
		array_key_exists($_POST['sort_option'],$this->amazon->sort_option_array)) {
		$sort_option = $_POST['sort_option'];
	} else {
		$sort_option = 'salesrank';
	}
	$sort_option = 'salesrank';
	$response_options = array(
		'Sort' => $sort_option,
		'ResponseGroup' => 'Small,Images,ItemAttributes',
		'ItemPage'=>$_POST['itempage'],
	);
	return $response_options;
}

function make_table($result) {	
	$table['num']['TotalResults'] = $result['TotalResults'];
	$table['num']['TotalPages'] = $result['TotalPages'];
	$i = 0;
	foreach($result['Item'] as $item) {
		$asin = $item[ASIN];
		if($item['ItemAttributes']['EAN']) {
			$isbn = $item['ItemAttributes']['EAN'];
		} elseif($item['ItemAttributes']['ISBN']) {
			$isbn = $item['ItemAttributes']['ISBN'];
		} else {
			$isbn = $item['ASIN'];
		}
		$detail_url = $item['DetailPageURL'];
		$manufacture = $item['ItemAttributes']['Manufacturer'];
		$list_price = $item['ItemAttributes']['ListPrice']['Amount'];
		$title = $item['ItemAttributes']['Title'];
		if(isset($item['ItemAttributes']['Creator']['_content'])) {
			$creater = $item['ItemAttributes']['Creator']['_content'];
		} elseif(is_array($item['ItemAttributes']['Creator'])) {
			foreach($item['ItemAttributes']['Creator'] as $creater_set) {
				$creaters[] = $creater_set['_content'];
			}
			$creater = implode('',$creaters);
		}
		$small_image_url = $item['SmallImage']['URL'];
		$small_image_height_unit = $item['SmallImage']['Height']['Units'];
		$small_image_height = $item['SmallImage']['Height']['_content'];
		$small_image_width_unit = $item['SmallImage']['Width']['Units'];
		$small_image_width = $item['SmallImage']['Width']['_content'];
		if($small_image_url) {
			$small_image = "<img src=\"$small_image_url\" width=\"$small_image_width\" height=\"$small_image_height\" border=\"0\" />";
			$small_image_tag = htmlentities($small_image);
			$small_image_link = "<a href=\"$detail_url\" target=\"_blank\">$small_image</a>";
		}

		$medium_image_url = $item['MediumImage']['URL'];
		$medium_image_height_unit = $item['MediumImage']['Height']['Units'];
		$medium_image_height = $item['MediumImage']['Height']['_content'];
		$medium_image_width_unit = $item['MediumImage']['Width']['Units'];
		$medium_image_width = $item['MediumImage']['Width']['_content'];
		if($medium_image_url) {
			$medium_image = "<img src=\"$medium_image_url\" width=\"$medium_image_width\" height=\"$medium_image_height\" border=\"0\" />";
			$medium_image_tag = htmlentities($medium_image);
		}

		$table['Items'][$i]['image_link'] = array('label'=>$this->W['image'].'&'.$this->W['link'],'value'=>$small_image,'body'=>$small_image_link);
		$table['Items'][$i]['title'] = array('label'=>$this->W['title'],'value'=>$title,'body'=>$title);
		$table['Items'][$i]['creater'] = array('label'=>$this->W['author'],'value'=>$creater,'body'=>$creater);
		$table['Items'][$i]['asin'] = array('label'=>'ASIN','value'=>$asin,'body'=>$asin);
		//$table['Items'][$i]['isbn'] = array('label'=>'ISBN','value'=>$isbn,'body'=>$isbn);
		$table['Items'][$i]['manufacture'] = array('label'=>$this->W['manufacture'],'value'=>$manufacture,'body'=>$manufacture);
		$table['Items'][$i]['list_price'] = array('label'=>$this->W['price'],'value'=>$list_price,'body'=>$list_price);
		//$table['Items'][$i]['detail_url'] = array('label'=>'URL','value'=>$detail_url,'body'=>$detail_url);
		//$table['Items'][$i]['small_image'] = array('label'=>$this->W['image'],'value'=>$small_image,'body'=>$small_image_tag);
		//$table['Items'][$i]['medium_image'] = array('label'=>$this->W['image'],'value'=>$medium_image,'body'=>$medium_image_tag);
		//$table['Items'][$i]['properties'] = serialize($item);
		$i++;
	}
	return $table;
}

} // end of <!--{$class_name}--> class
?>