<?php
/**
 *	Project:	Quicty: Quick application build environment depends on PEAR and Smarty
 *	File:		Log.class.php
 *
 *	@copyright	Tomoyuki Negishi and ZubaPitaTech, Inc.
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Quicty
 *	@version	$Id:$
 */

/* Sample
 * $this->log = new QtLog($formName,$display=true);
 * $this->log->err("file not found '$file' in dir '$dir'  source file:".__FILE__.' line:'.__LINE__);
 *
 * or 
 *
 * $message = $e->getMessage();
 * $this->log->err("$message.  source file:".__FILE__.' line:'.__LINE__);
 */

// {{{ QtLog
/**
 *	QtLog Logging Error and Information class.
 *
 *	@author		Tomoyuki Negishi <tomoyu-n@zubapita.jp>
 *	@access		public
 *	@package	Quicty
 */
class QtLog {
var $display = true;

//  constructor
function QtLog($ident='QuictyLog',$display=true,$home_dir='..') {
	$this->display = $display;
	$this->home_dir = realpath($home_dir);
	$myIdent = $this->home_dir.':'.$ident;
	if((is_file($this->home_dir.'/etc/conf/dev.conf') or is_file($this->home_dir.'/etc/conf/dev2.conf')) and $this->display) {
		$this->logger = Log::factory('display',NULL,$myIdent);
	} elseif(is_file($this->home_dir.'/var/log/error_log')) {
		$this->logger = Log::factory('file',$this->home_dir.'/var/log/error_log',$myIdent);
	} else {
		$this->logger = Log::factory('syslog',LOG_USER,$myIdent);
	}
}

function set_display($value) {
	$this->display = $value;
	return $this->display;
}

function write($message,$level=PEAR_LOG_INFO) {
	$this->logger->log($message,$level);
}

/*
function err($message) {
	$this->logger->err($message);
}
*/

function __call($method,$message) {
	call_user_func(array($this->logger,$method),$message[0]);
}



} // end of class QtLog
// }}}
?>
