/*!
  \example scip_20_tm.cpp

  \brief SCIP 2.0  "TMx" sTv

  \author Satofumi KAMIMURA

  $Id: scip_20_tm.cpp 1474 2009-11-01 05:33:08Z satofumi $
*/

#include "SerialDevice.h"
#include "ConnectionUtils.h"
#include "ScipUtils.h"
#include "delay.h"
#include "DetectOS.h"
#include <cstdio>

using namespace qrk;


static long recvTm1Reply(Connection* con, int timeout) {

  con->send("TM1\n", 4);

  // GR[obNA̓ǂݏo
  int ret = recvReply(con, timeout);
  if (ret != 0x00) {
    fprintf(stderr, "recvReply: %d\n", ret);
    return -1;
  }

  // ^CX^v̓ǂݏo
  enum { TimestampLine = 5 + 1 };
  char buffer[TimestampLine];
  int n = readline(con, buffer, TimestampLine, timeout);
  long timestamp = 0;
  if (n == 5) {
    // ^CX^vo͂
    printf("%s\n", buffer);

    // ^CX^ṽfR[h
    timestamp = decode(buffer, 4);
  }

  // Ō̉s̓ǂݏo
  char recv_ch = '\0';
  n = con->receive(&recv_ch, 1, timeout);
  if (! isLF(recv_ch)) {
    return -2;
  }

  return timestamp;
}


//! main
int main(int argc, char *argv[]) {

  // K؂Ƀ|[gύX邱
#if defined(WINDOWS_OS)
  const char device[] = "COM3";
#elif defined(LINUX_OS)
  const char device[] = "/dev/ttyACM0";
#else
  const char device[] = "/dev/tty.usbmodem1d11";
#endif

  SerialDevice con;
  if (! con.connect(device, 19200)) {
    printf("SerialDevice::connect: %s\n", con.what());
    exit(1);
  }

  // SCIP2.0 ̌ĂяoƁA̖
  enum { Timeout = 200 };
  con.send("SCIP2.0\n", 8);
  skip(&con, Timeout);

  // TM0 ɂA^CX^v[h֑Jڂ
  con.send("TM0\n", 4);
  int ret = recvReply(&con, Timeout);
  if (ret != 0x00) {
    printf("%d: Please reboot URG.\n", ret);
    exit(1);
  }

  enum { TryTimes = 3 };
  for (int i = 0; i < TryTimes; ++i) {
    // TM1 ŁA^CX^v擾A\
    long timestamp = recvTm1Reply(&con, Timeout);
    printf("=> %ld [msec]\n\n", timestamp);
    delay(1);
  }

  // TM2 ŁA^CX^v[h甲
  con.send("TM2\n", 4);
  ret = recvReply(&con, Timeout);
  if (ret != 0x00) {
    printf("%d: Please reboot URG.\n", ret);
    exit(1);
  }

  printf("exit normaly.\n");

  return 0;
}
