/*!
  \example get_version_lines.c

  \brief o[W̎擾

  URG ̃o[W擾

  \author Satofumi KAMIMURA

  $Id: get_version_lines.c 1300 2009-09-15 06:36:54Z satofumi $
*/

#include "urg_ctrl.h"
#include <stdio.h>
#include <stdlib.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


/*! main */
int main(int argc, char *argv[])
{
  enum {
    LinesMax = 5,
  };

  const char device[] = "COM4"; /* Windows ł̗ */
  // const char device[] = "/dev/ttyACM0"; /* Linux ł̗ */

  char buffer[LinesMax][UrgLineWidth];
  char *lines[LinesMax];
  int ret;
  int i;

  /* ڑ */
  urg_t urg;
  ret = urg_connect(&urg, device, 115200);
  if (ret < 0) {
    urg_exit(&urg, "urg_connect()");
  }

  /* o[W̎擾 */
  for (i = 0; i < LinesMax; ++i) {
    lines[i] = buffer[i];
  }
  ret = urg_versionLines(&urg, lines, LinesMax);
  printf("urg_getVersion: %s\n", urg_error(&urg));
  if (ret < 0) {
    urg_disconnect(&urg);
    exit(1);
  }

  /* \ */
  for (i = 0; i < LinesMax; ++i) {
    printf("%s\n", lines[i]);
  }

  /* ؒf */
  urg_disconnect(&urg);

#ifdef MSC
  getchar();
#endif

  return 0;
}
