#ifndef QRK_M_URG_CTRL_H
#define QRK_M_URG_CTRL_H

/*!
  \file
  \brief j^Ή URG 

  \author Satofumi KAMIMURA

  $Id: mUrgCtrl.h 1633 2010-01-19 07:09:49Z satofumi $
*/

#include "UrgCtrl.h"


namespace qrk
{
  /*!
    \brief j^Ή URG 
  */
  class mUrgCtrl : public RangeSensor
  {
    mUrgCtrl(void);
    mUrgCtrl(const mUrgCtrl& rhs);
    mUrgCtrl& operator = (const mUrgCtrl& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    /*!
      \brief IvVpp[^
    */
    enum {
      DefaultBaudrate = 115200, //!< ڑ̃ftHg{[[g
      Infinity = 0,             //!< ̃f[^擾
    };


    /*!
      \brief RXgN^

      샂[hw肷

      - Record [h (-r w)
        - 擾f[^Ot@Cɏo

      - Play [h (-p w)
        - Ot@C̃f[^擾f[^ƂĈ

      gp
      \code
// vOs̈ -r, -p w肷邱Ƃœ삪ςB
//
// % ./a.exe -r    f[^擾AL^
// % ./a.exe -p    L^ς݂̃f[^Đ
//
// AL^ƍĐł͓vOgƁB

#include <mUrgCtrl.h>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  mUrgCtrl urg(argc, argv);

  if (! urg.connect("COM4")) {
    ...
  }

  long timestamp = 0;
  vector<long> data;
  urg.capture(data, &timestamp);

  ...
} \endcode

      \see UrgCtrl
    */
    explicit mUrgCtrl(int argc, char *argv[]);
    ~mUrgCtrl(void);

    const char* what(void) const;

    bool connect(const char* device, long baudrate = DefaultBaudrate);
    void setConnection(Connection* con);
    Connection* connection(void);
    void disconnect(void);
    bool isConnected(void) const;

    long minDistance(void) const;
    long maxDistance(void) const;
    int maxScanLines(void) const;

    void setRetryTimes(size_t times);

    int scanMsec(void) const;

    void setCaptureMode(RangeCaptureMode mode);
    RangeCaptureMode captureMode(void);

    void setCaptureRange(int begin_index, int end_index);
    void setCaptureFrameInterval(size_t interval);
    void setCaptureTimes(size_t times);
    size_t remainCaptureTimes(void);
    void setCaptureSkipLines(size_t skip_lines);

    int capture(std::vector<long>& data, long* timestamp = NULL);
    int captureWithIntensity(std::vector<long>& data,
                             std::vector<long>& intensity_data,
                             long* timestamp = NULL);
    void stop(void);

    bool setTimestamp(int ticks = 0, int* response_msec = NULL,
                      int* force_delay_msec = NULL);

    bool setLaserOutput(bool on);

    double index2rad(const int index) const;
    int rad2index(const double radian) const;

    void setParameter(const RangeSensorParameter& parameter);
    RangeSensorParameter parameter(void) const;
    bool loadParameter(void);

    bool versionLines(std::vector<std::string>& lines);

    void reset(void);
  };
}

#endif /* !QRK_M_URG_CTRL_H */
