#ifndef QRK_RING_BUFFER_H
#define QRK_RING_BUFFER_H

/*!
  \file
  \brief Oobt@

  \author Satofumi KAMIMURA

  $Id: RingBuffer.h 1574 2009-12-13 03:53:55Z satofumi $
*/

#include <deque>


namespace qrk
{
  /*!
    \brief Oobt@
  */
  template <class T>
  class RingBuffer
  {
  public:
    explicit RingBuffer(void)
    {
    }


    /*!
      \brief obt@TCY̎擾
    */
    size_t size(void)
    {
      return ring_buffer_.size();
    }


    /*!
      \brief obt@

      \retval true f[^Ȃ
      \retval false f[^
    */
    bool empty(void)
    {
      return ring_buffer_.empty();
    }


    /*!
      \brief f[^̊i[

      \param[in] data f[^
      \param[in] size f[^
    */
    void put(const T* data, size_t size)
    {
      const T* last_p = data + size;
      ring_buffer_.insert(ring_buffer_.end(), data, last_p);
    }


    /*!
      \brief f[^̎o

      \param[out] data f[^opobt@
      \param[in] size of[^̍ő

      \return of[^
    */
    size_t get(T* data, size_t size)
    {
      size_t n = std::min(size, ring_buffer_.size());
      std::copy(ring_buffer_.begin(), ring_buffer_.begin() + n, data);
      ring_buffer_.erase(ring_buffer_.begin(), ring_buffer_.begin() + n);
      return n;
    }


    /*!
      \brief f[^̏߂

      \param[in] ch ߂f[^
    */
    void ungetc(const T ch)
    {
      ring_buffer_.push_front(ch);
    }


    /*!
      \brief i[f[^̃NA
    */
    void clear(void)
    {
      ring_buffer_.clear();
    }


  private:
    RingBuffer(const RingBuffer& rhs);
    RingBuffer& operator = (const RingBuffer& rhs);

    std::deque<T> ring_buffer_;
  };
}

#endif /* !QRK_RING_BUFFER_H */
