/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode.codec;

import java.util.Vector;
import jp.sourceforge.qrcode.codec.data.QRCodeImage;
import jp.sourceforge.qrcode.codec.data.QRCodeSymbol;
import jp.sourceforge.qrcode.codec.ecc.ReedSolomon;
import jp.sourceforge.qrcode.codec.exception.DecodingFailedException;
import jp.sourceforge.qrcode.codec.exception.InvalidDataBlockException;
import jp.sourceforge.qrcode.codec.exception.SymbolNotFoundException;
import jp.sourceforge.qrcode.codec.geom.Point;
import jp.sourceforge.qrcode.codec.reader.QRCodeDataBlockReader;
import jp.sourceforge.qrcode.codec.reader.QRCodeImageReader;
import jp.sourceforge.qrcode.codec.util.DebugCanvas;
import jp.sourceforge.qrcode.codec.util.DebugCanvasAdapter;

public class QRCodeDecoder {
    QRCodeSymbol qrCodeSymbol;
    int numTryDecode = 0;
    Vector results;
    Vector lastResults = new Vector();
    static DebugCanvas canvas;
    QRCodeImageReader imageReader;
    int numLastCorrections;
    boolean correctionSucceeded;

    public static void setCanvas(DebugCanvas canvas) {
        QRCodeDecoder.canvas = canvas;
    }

    public static DebugCanvas getCanvas() {
        return canvas;
    }

    public QRCodeDecoder() {
        this.results = new Vector();
        canvas = new DebugCanvasAdapter();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] decode(QRCodeImage qrCodeImage) throws DecodingFailedException {
        Point[] adjusts = this.getAdjustPoints();
        Vector<DecodeResult> results = new Vector<DecodeResult>();
        while (true) {
            Object var5_7;
            if (this.numTryDecode >= adjusts.length) {
                if (results.size() != 0) break;
                throw new DecodingFailedException("Give up decoding");
            }
            try {
                try {
                    DecodeResult result = this.decode(qrCodeImage, adjusts[this.numTryDecode]);
                    if (result.isCorrectionSucceeded()) {
                        byte[] byArray = result.getDecodedBytes();
                        var5_7 = null;
                        ++this.numTryDecode;
                        return byArray;
                    }
                    results.addElement(result);
                    canvas.println("Decoding succeeded but could not correct");
                    canvas.println("all errors. Retrying..");
                }
                catch (DecodingFailedException dfe) {
                    if (dfe.getMessage().indexOf("Finder Pattern") >= 0) {
                        throw dfe;
                    }
                }
            }
            catch (Throwable throwable) {
                var5_7 = null;
                ++this.numTryDecode;
                throw throwable;
            }
            {
                var5_7 = null;
                ++this.numTryDecode;
                continue;
            }
            break;
        }
        int lowestErrorIndex = -1;
        int lowestError = Integer.MAX_VALUE;
        int i = 0;
        while (true) {
            if (i >= results.size()) {
                canvas.println("All trials need for correct error");
                canvas.println("Reporting #" + lowestErrorIndex + " that,");
                canvas.println("corrected minimum errors (" + lowestError + ")");
                canvas.println("Decoding finished.");
                return ((DecodeResult)results.elementAt(lowestErrorIndex)).getDecodedBytes();
            }
            DecodeResult result = (DecodeResult)results.elementAt(i);
            if (result.getNumErrors() < lowestError) {
                lowestError = result.getNumErrors();
                lowestErrorIndex = i;
            }
            ++i;
        }
    }

    Point[] getAdjustPoints() {
        Vector<Point> adjustPoints = new Vector<Point>();
        int d = 0;
        while (d < 4) {
            adjustPoints.addElement(new Point(1, 1));
            ++d;
        }
        int lastX = 0;
        int lastY = 0;
        int y = 0;
        while (y > -4) {
            int x = 0;
            while (x > -4) {
                if (x != y && (x + y) % 2 == 0) {
                    adjustPoints.addElement(new Point(x - lastX, y - lastY));
                    lastX = x;
                    lastY = y;
                }
                --x;
            }
            --y;
        }
        Point[] adjusts = new Point[adjustPoints.size()];
        int i = 0;
        while (i < adjusts.length) {
            adjusts[i] = (Point)adjustPoints.elementAt(i);
            ++i;
        }
        return adjusts;
    }

    DecodeResult decode(QRCodeImage qrCodeImage, Point adjust) throws DecodingFailedException {
        try {
            if (this.numTryDecode == 0) {
                canvas.println("Decoding started");
                int[][] intImage = this.imageToIntArray(qrCodeImage);
                this.imageReader = new QRCodeImageReader();
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbol(intImage);
            } else {
                canvas.println("--");
                canvas.println("Decoding restarted #" + this.numTryDecode);
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbolWithAdjustedGrid(adjust);
            }
        }
        catch (SymbolNotFoundException e) {
            throw new DecodingFailedException(e.getMessage());
        }
        canvas.println("Created QRCode symbol.");
        canvas.println("Reading symbol.");
        canvas.println("Version: " + this.qrCodeSymbol.getVersionReference());
        canvas.println("Mask pattern: " + this.qrCodeSymbol.getMaskPatternRefererAsString());
        int[] blocks = this.qrCodeSymbol.getBlocks();
        canvas.println("Correcting data errors.");
        blocks = this.correctDataBlocks(blocks);
        try {
            byte[] decodedByteArray = this.getDecodedByteArray(blocks, this.qrCodeSymbol.getVersion(), this.qrCodeSymbol.getNumErrorCollectionCode());
            return new DecodeResult(decodedByteArray, this.numLastCorrections, this.correctionSucceeded);
        }
        catch (InvalidDataBlockException e) {
            canvas.println(e.getMessage());
            throw new DecodingFailedException(e.getMessage());
        }
    }

    int[][] imageToIntArray(QRCodeImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] intImage = new int[width][height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                intImage[x][y] = image.getPixel(x, y);
                ++x;
            }
            ++y;
        }
        return intImage;
    }

    int[] correctDataBlocks(int[] blocks) {
        int numCorrections = 0;
        int dataCapacity = this.qrCodeSymbol.getDataCapacity();
        int[] dataBlocks = new int[dataCapacity];
        int numErrorCollectionCode = this.qrCodeSymbol.getNumErrorCollectionCode();
        int numRSBlocks = this.qrCodeSymbol.getNumRSBlocks();
        int eccPerRSBlock = numErrorCollectionCode / numRSBlocks;
        if (numRSBlocks == 1) {
            ReedSolomon corrector = new ReedSolomon(blocks, eccPerRSBlock);
            corrector.correct();
            if ((numCorrections += corrector.getNumCorrectedErrors()) > 0) {
                canvas.println(String.valueOf(String.valueOf(numCorrections)) + " data errors corrected.");
            } else {
                canvas.println("No errors found.");
            }
            this.numLastCorrections = numCorrections;
            this.correctionSucceeded = corrector.isCorrectionSucceeded();
            return blocks;
        }
        int numLongerRSBlocks = dataCapacity % numRSBlocks;
        if (numLongerRSBlocks == 0) {
            int lengthRSBlock = dataCapacity / numRSBlocks;
            int[][] RSBlocks = new int[numRSBlocks][lengthRSBlock];
            int i = 0;
            while (i < numRSBlocks) {
                int j = 0;
                while (j < lengthRSBlock) {
                    RSBlocks[i][j] = blocks[j * numRSBlocks + i];
                    ++j;
                }
                ReedSolomon corrector = new ReedSolomon(RSBlocks[i], eccPerRSBlock);
                corrector.correct();
                numCorrections += corrector.getNumCorrectedErrors();
                this.correctionSucceeded = corrector.isCorrectionSucceeded();
                ++i;
            }
            int p = 0;
            int i2 = 0;
            while (i2 < numRSBlocks) {
                int j = 0;
                while (j < lengthRSBlock - eccPerRSBlock) {
                    dataBlocks[p++] = RSBlocks[i2][j];
                    ++j;
                }
                ++i2;
            }
        } else {
            int lengthShorterRSBlock = dataCapacity / numRSBlocks;
            int lengthLongerRSBlock = dataCapacity / numRSBlocks + 1;
            int numShorterRSBlocks = numRSBlocks - numLongerRSBlocks;
            int[][] shorterRSBlocks = new int[numShorterRSBlocks][lengthShorterRSBlock];
            int[][] longerRSBlocks = new int[numLongerRSBlocks][lengthLongerRSBlock];
            int i = 0;
            while (i < numRSBlocks) {
                ReedSolomon corrector;
                int mod;
                if (i < numShorterRSBlocks) {
                    mod = 0;
                    int j = 0;
                    while (j < lengthShorterRSBlock) {
                        if (j == lengthShorterRSBlock - eccPerRSBlock) {
                            mod = numLongerRSBlocks;
                        }
                        shorterRSBlocks[i][j] = blocks[j * numRSBlocks + i + mod];
                        ++j;
                    }
                    corrector = new ReedSolomon(shorterRSBlocks[i], eccPerRSBlock);
                    corrector.correct();
                    numCorrections += corrector.getNumCorrectedErrors();
                    this.correctionSucceeded = corrector.isCorrectionSucceeded();
                } else {
                    mod = 0;
                    int j = 0;
                    while (j < lengthLongerRSBlock) {
                        if (j == lengthShorterRSBlock - eccPerRSBlock) {
                            mod = numShorterRSBlocks;
                        }
                        longerRSBlocks[i - numShorterRSBlocks][j] = blocks[j * numRSBlocks + i - mod];
                        ++j;
                    }
                    corrector = new ReedSolomon(longerRSBlocks[i - numShorterRSBlocks], eccPerRSBlock);
                    corrector.correct();
                    numCorrections += corrector.getNumCorrectedErrors();
                    this.correctionSucceeded = corrector.isCorrectionSucceeded();
                }
                ++i;
            }
            int p = 0;
            int i3 = 0;
            while (i3 < numRSBlocks) {
                int j;
                if (i3 < numShorterRSBlocks) {
                    j = 0;
                    while (j < lengthShorterRSBlock - eccPerRSBlock) {
                        dataBlocks[p++] = shorterRSBlocks[i3][j];
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < lengthLongerRSBlock - eccPerRSBlock) {
                        dataBlocks[p++] = longerRSBlocks[i3 - numShorterRSBlocks][j];
                        ++j;
                    }
                }
                ++i3;
            }
        }
        if (numCorrections > 0) {
            canvas.println(String.valueOf(String.valueOf(numCorrections)) + " data errors corrected.");
        } else {
            canvas.println("No errors found.");
        }
        this.numLastCorrections = numCorrections;
        return dataBlocks;
    }

    byte[] getDecodedByteArray(int[] blocks, int version, int numErrorCorrectionCode) throws InvalidDataBlockException {
        QRCodeDataBlockReader reader = new QRCodeDataBlockReader(blocks, version, numErrorCorrectionCode);
        byte[] byteArray = reader.getDataByte();
        return byteArray;
    }

    String getDecodedString(int[] blocks, int version, int numErrorCorrectionCode) throws InvalidDataBlockException {
        String dataString = null;
        QRCodeDataBlockReader reader = new QRCodeDataBlockReader(blocks, version, numErrorCorrectionCode);
        try {
            dataString = reader.getDataString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidDataBlockException(e.getMessage());
        }
        return dataString;
    }

    class DecodeResult {
        int numCorrections;
        boolean correctionSucceeded;
        byte[] decodedBytes;

        public DecodeResult(byte[] decodedBytes, int numErrors, boolean correctionSucceeded) {
            this.decodedBytes = decodedBytes;
            this.numCorrections = numErrors;
            this.correctionSucceeded = correctionSucceeded;
        }

        public byte[] getDecodedBytes() {
            return this.decodedBytes;
        }

        public int getNumErrors() {
            return this.numCorrections;
        }

        public boolean isCorrectionSucceeded() {
            return this.correctionSucceeded;
        }
    }
}

