/*
 * Created on 2004/12/28
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package jp.sourceforge.qrcode.codec.geom;

import jp.sourceforge.qrcode.codec.reader.QRCodeImageReader;

/**
 * @author Owner
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Axis {
	int sin, cos;
	int modulePitch;
	Point origin;
	
	public Axis(int sin, int cos, int modulePitch) {
		this.sin = sin;
		this.cos = cos;
		this.modulePitch = modulePitch;
		this.origin = new Point();
	}
	
	public void setOrigin(Point origin) {
		this.origin = origin;
	}
	
	public void setModulePitch(int modulePitch) {
		this.modulePitch = modulePitch;
	}
	
	public Point translate(Point offset) {
		int moveX = offset.getX();
		int moveY = offset.getY();
		return this.translate(moveX, moveY);
	}
	
	public Point translate(int moveX, int moveY) {
		int dp = QRCodeImageReader.DECIMAL_POINT;
		Point point = new Point(origin.getX(), origin.getY());
		int xf = 0, yf = 0;
		if (moveX >= 0 & moveY >= 0) yf = 1;
		else if (moveX < 0 & moveY >= 0) yf = -1;
		else if (moveX >= 0 & moveY < 0) yf = -1;
		else if (moveX < 0 & moveY < 0) yf = 1;
		
		if (moveX != 0 && moveY != 0)
			point.translate(
					(((modulePitch * moveX) >> dp) * cos - 
					((modulePitch * moveY) >> dp) * sin) 
					>> dp, 
					yf * (((modulePitch * moveX) >> dp) * cos + 
					((modulePitch * moveY) >> dp) * sin)
					>> dp);
		else if (moveY == 0) { 
			if (moveX < 0) yf = -yf;
			point.translate(
					(((modulePitch * moveX) >> dp) * cos)
					>> dp, 
					yf * (((modulePitch * moveX) >> dp) * sin) 
					>> dp);
		}
		else if (moveX == 0) {
			if (moveY < 0) yf = -yf;
			point.translate(
					-yf * (((modulePitch * moveY) >> dp) * sin)
					>> dp, 
					(((modulePitch * moveY) >> dp) * cos)
					>> dp);	
		}
		return point;
	}
}
