/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.auth.jaas;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.util.StringTokenizer;

public class MQDestinationPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -2435224016059811024L;
    private static final int PRODUCE = 1;
    private static final int CONSUME = 2;
    private static final int BROWSE = 4;
    private static final int NONE = 0;
    private static final int ALL = 7;
    private transient boolean wildcard = false;
    private transient boolean isQueue = false;
    private transient String destName = null;
    private transient int mask = 0;
    private String actions = null;

    public MQDestinationPermission(String string, String string2) {
        super(string);
        this.init(string, string2);
    }

    private void init(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("name null");
        }
        if (string.trim().startsWith("queue:")) {
            this.isQueue = true;
            this.destName = string.trim().substring("queue:".length()).trim();
        } else if (string.trim().startsWith("topic:")) {
            this.isQueue = false;
            this.destName = string.trim().substring("topic:".length()).trim();
        } else {
            throw new IllegalArgumentException("invalid name " + string);
        }
        int n = this.destName.length();
        if (n == 1 && this.destName.equals("*")) {
            this.wildcard = true;
        }
        if (string2 == null) {
            throw new NullPointerException("actions null");
        }
        this.mask = this.computeMask(string2);
    }

    public int getMask() {
        return this.mask;
    }

    private int computeMask(String string) throws IllegalArgumentException {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        String string2 = null;
        while (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken().trim().toLowerCase();
            int n2 = 0;
            while (n2 < string2.length() && Character.isSpaceChar(string2.charAt(n2++))) {
            }
            if (n2 > 0) {
                string2 = string2.substring(n2 - 1);
            }
            for (n2 = string2.length() - 1; n2 != -1 && Character.isSpaceChar(string2.charAt(n2)); --n2) {
            }
            if (n2 < string2.length() - 1) {
                string2 = string2.substring(0, n2 + 1);
            }
            if (string2.equals("produce")) {
                n |= 1;
                continue;
            }
            if (string2.equals("consume")) {
                n |= 2;
                continue;
            }
            if (!string2.equals("browse")) continue;
            n |= 4;
        }
        if (n == 0) {
            throw new IllegalArgumentException("invalid actions " + string);
        }
        return n;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof MQDestinationPermission)) {
            return false;
        }
        MQDestinationPermission mQDestinationPermission = (MQDestinationPermission)permission;
        if (this.isQueue != mQDestinationPermission.isQueue) {
            return false;
        }
        return (this.mask & mQDestinationPermission.mask) == mQDestinationPermission.mask && this.impliesDestName(mQDestinationPermission);
    }

    private boolean impliesDestName(MQDestinationPermission mQDestinationPermission) {
        if (this.wildcard) {
            return true;
        }
        if (mQDestinationPermission.wildcard) {
            return false;
        }
        return this.destName.equals(mQDestinationPermission.destName);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MQDestinationPermission)) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        MQDestinationPermission mQDestinationPermission = (MQDestinationPermission)object;
        return this.mask == mQDestinationPermission.mask && this.isQueue == mQDestinationPermission.isQueue && this.destName.equals(mQDestinationPermission.destName);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        if (this.actions != null) {
            return this.actions;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if ((this.mask & 1) == 1) {
            bl = true;
            stringBuffer.append("produce");
        }
        if ((this.mask & 2) == 2) {
            if (bl) {
                stringBuffer.append(',');
            }
            bl = true;
            stringBuffer.append("consume");
        }
        if ((this.mask & 4) == 4) {
            if (bl) {
                stringBuffer.append(',');
            }
            bl = true;
            stringBuffer.append("browse");
        }
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName(), this.actions);
    }
}

