/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Resource;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.event.SearchableEvent;
import com.jidesoft.swing.event.SearchableListener;
import com.jidesoft.utils.DefaultWildcardSupport;
import com.jidesoft.utils.WildcardSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

public abstract class Searchable {
    private final PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);
    protected final JComponent _component;
    private SearchPopup _popup;
    private JLayeredPane _layeredPane;
    private SearchableProvider _searchableProvider;
    private Pattern _pattern;
    private String _searchText;
    private String _previousSearchText = null;
    private boolean _fromStart = true;
    private boolean _caseSensitive = false;
    private boolean _repeats = false;
    private boolean _wildcardEnabled = true;
    private WildcardSupport _wildcardSupport = null;
    private Color _foreground = null;
    private Color _background = null;
    private ComponentListener _componentListener;
    private KeyListener _keyListener;
    private FocusListener _focusListener;
    private int _cursor = -1;
    private String _searchLabel = null;
    private int _popupLocation = 1;
    private int _searchingDelay = 0;
    private boolean _reverseOrder = false;
    private EventListenerList listenerList = new EventListenerList();
    private Set<Integer> _selection;

    public Searchable(JComponent object) {
        this._component = object;
        this._selection = new HashSet<Integer>();
        this.installListeners();
        Searchable searchable = this;
        JComponent jComponent = this._component;
        object = this;
        if (jComponent != null) {
            object = ((Searchable)object)._component.getClientProperty("Searchable");
            if (object instanceof Searchable) {
                ((Searchable)object).uninstallListeners();
            }
            jComponent.putClientProperty("Searchable", searchable);
        }
    }

    protected abstract int getSelectedIndex();

    protected abstract void setSelectedIndex(int var1, boolean var2);

    protected abstract int getElementCount();

    protected abstract Object getElementAt(int var1);

    protected abstract String convertElementToString(Object var1);

    public void hidePopup() {
        Searchable searchable;
        if (this._popup != null) {
            searchable = this;
            if (this._layeredPane != null) {
                this._layeredPane.remove(this._popup);
                this._layeredPane.validate();
                this._layeredPane.repaint();
                this._layeredPane = null;
            }
            this._popup = null;
            this._searchableProvider = null;
            this.fireSearchableEvent(new SearchableEvent(this, 3000));
        }
        int n = -1;
        searchable = this;
        searchable.setCursor(n, false);
    }

    public final void setSearchableProvider(SearchableProvider searchableProvider) {
        this._searchableProvider = searchableProvider;
    }

    public void installListeners() {
        Object object;
        if (this._componentListener == null) {
            object = this;
            this._componentListener = new ComponentAdapter((Searchable)object){
                private /* synthetic */ Searchable this$0;
                {
                    this.this$0 = searchable;
                }

                public final void componentHidden(ComponentEvent componentEvent) {
                    super.componentHidden(componentEvent);
                    boolean bl = this.this$0._searchableProvider == null || this.this$0._searchableProvider.isPassive();
                    if (bl) {
                        this.this$0.hidePopup();
                    }
                }

                public final void componentResized(ComponentEvent componentEvent) {
                    super.componentResized(componentEvent);
                    boolean bl = this.this$0._searchableProvider == null || this.this$0._searchableProvider.isPassive();
                    if (bl) {
                        this.this$0.updateSizeAndLocation();
                    }
                }

                public final void componentMoved(ComponentEvent componentEvent) {
                    super.componentMoved(componentEvent);
                    boolean bl = this.this$0._searchableProvider == null || this.this$0._searchableProvider.isPassive();
                    if (bl) {
                        this.this$0.updateSizeAndLocation();
                    }
                }
            };
        }
        this._component.addComponentListener(this._componentListener);
        object = JideSwingUtilities.getScrollPane(this._component);
        if (object != null) {
            ((Component)object).addComponentListener(this._componentListener);
        }
        if (this._keyListener == null) {
            object = this;
            this._keyListener = new KeyAdapter((Searchable)object){
                private /* synthetic */ Searchable this$0;
                {
                    this.this$0 = searchable;
                }

                public final void keyTyped(KeyEvent keyEvent) {
                    boolean bl = this.this$0._searchableProvider == null || this.this$0._searchableProvider.isPassive();
                    if (bl) {
                        this.this$0.keyTypedOrPressed(keyEvent);
                    }
                }

                public final void keyPressed(KeyEvent keyEvent) {
                    boolean bl = this.this$0._searchableProvider == null || this.this$0._searchableProvider.isPassive();
                    if (bl) {
                        this.this$0.keyTypedOrPressed(keyEvent);
                    }
                }
            };
        }
        object = this;
        JideSwingUtilities.insertKeyListener(((Searchable)object)._component, this._keyListener, 0);
        if (this._focusListener == null) {
            object = this;
            this._focusListener = new FocusAdapter((Searchable)object){
                private /* synthetic */ Searchable this$0;
                {
                    this.this$0 = searchable;
                }

                public final void focusLost(FocusEvent focusEvent) {
                    boolean bl = this.this$0._searchableProvider == null || this.this$0._searchableProvider.isPassive();
                    if (bl) {
                        this.this$0.hidePopup();
                    }
                }
            };
        }
        object = this;
        ((Searchable)object)._component.addFocusListener(this._focusListener);
    }

    public void uninstallListeners() {
        Object object;
        if (this._componentListener != null) {
            object = this;
            ((Searchable)object)._component.removeComponentListener(this._componentListener);
            object = this;
            object = JideSwingUtilities.getScrollPane(((Searchable)object)._component);
            if (object != null) {
                ((Component)object).removeComponentListener(this._componentListener);
            }
            this._componentListener = null;
        }
        if (this._keyListener != null) {
            object = this;
            ((Searchable)object)._component.removeKeyListener(this._keyListener);
            this._keyListener = null;
        }
        if (this._focusListener != null) {
            object = this;
            ((Searchable)object)._component.removeFocusListener(this._focusListener);
            this._focusListener = null;
        }
    }

    public final void firePropertyChangeEvent(String string) {
        if (!string.equals(this._previousSearchText)) {
            this._propertyChangeSupport.firePropertyChange("searchText", this._previousSearchText, string);
            this.fireSearchableEvent(new SearchableEvent(this, 3004, string, this._previousSearchText));
            this._previousSearchText = string;
        }
    }

    private boolean compare(Object object, String string) {
        if ((object = this.convertElementToString(object)) != null) {
            Searchable searchable = this;
            if (this.compare((String)(searchable._caseSensitive ? object : ((String)object).toLowerCase()), string)) {
                return true;
            }
        }
        return false;
    }

    private boolean compare(String string, String string2) {
        Object object;
        block10: {
            block11: {
                block12: {
                    if (string2 == null || string2.trim().length() == 0) {
                        return true;
                    }
                    object = this;
                    if (((Searchable)object)._wildcardEnabled) break block10;
                    if (string2 == null) break block11;
                    if (string2.equals(string)) break block12;
                    if (string2.length() <= 0) break block11;
                    Searchable searchable = this;
                    if (!(searchable._fromStart ? string.startsWith(string2) : string.indexOf(string2) != -1)) break block11;
                }
                return true;
            }
            return false;
        }
        if (this._searchText != null && this._searchText.equals(string2) && this._pattern != null) {
            return this._pattern.matcher(string).find();
        }
        object = this;
        if (((Searchable)object)._wildcardSupport == null) {
            ((Searchable)object)._wildcardSupport = new DefaultWildcardSupport();
        }
        object = ((Searchable)object)._wildcardSupport;
        if (string2.equals(object = object.convert(string2))) {
            Searchable searchable = this;
            if (searchable._fromStart) {
                return string.startsWith(string2);
            }
            return string.indexOf(string2) != -1;
        }
        this._searchText = string2;
        try {
            Searchable searchable = this;
            searchable = this;
            this._pattern = Pattern.compile((String)(searchable._fromStart ? "^" + (String)object : object), searchable._caseSensitive ? 0 : 2);
            return this._pattern.matcher(string).find();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public final int getCursor() {
        return this._cursor;
    }

    public final void setCursor(int n) {
        this.setCursor(n, false);
    }

    public final void setCursor(int n, boolean bl) {
        if (!bl || this._cursor < 0) {
            this._selection.clear();
        }
        if (this._cursor >= 0) {
            this._selection.add(n);
        }
        this._cursor = n;
    }

    public int findNext(String string) {
        Object object;
        int n;
        Searchable searchable = this;
        String string2 = searchable._caseSensitive ? string : string.toLowerCase();
        int n2 = this.getElementCount();
        if (n2 == 0) {
            if (string.length() > 0) {
                return -1;
            }
            return 0;
        }
        int n3 = this.getCurrentIndex();
        for (n = n3 + 1; n < n2; ++n) {
            object = this.getElementAt(n);
            if (!this.compare(object, string2)) continue;
            return n;
        }
        Searchable searchable2 = this;
        if (searchable2._repeats) {
            for (n = 0; n < n3; ++n) {
                object = this.getElementAt(n);
                if (!this.compare(object, string2)) continue;
                return n;
            }
        }
        if (n3 != -1 && this.compare(this.getElementAt(n3), string2)) {
            return n3;
        }
        return -1;
    }

    private int getCurrentIndex() {
        if (this._selection.contains(this.getSelectedIndex())) {
            if (this._cursor != -1) {
                return this._cursor;
            }
            return this.getSelectedIndex();
        }
        this._selection.clear();
        return this.getSelectedIndex();
    }

    public int findPrevious(String string) {
        Object object;
        Searchable searchable = this;
        String string2 = searchable._caseSensitive ? string : string.toLowerCase();
        int n = this.getElementCount();
        if (n == 0) {
            if (string.length() > 0) {
                return -1;
            }
            return 0;
        }
        int n2 = this.getCurrentIndex();
        for (int i = n2 - 1; i >= 0; --i) {
            object = this.getElementAt(i);
            if (!this.compare(object, string2)) continue;
            return i;
        }
        Searchable searchable2 = this;
        if (searchable2._repeats) {
            for (int i = n - 1; i >= n2; --i) {
                object = this.getElementAt(i);
                if (!this.compare(object, string2)) continue;
                return i;
            }
        }
        if (n2 != -1 && this.compare(this.getElementAt(n2), string2)) {
            return n2;
        }
        return -1;
    }

    public int findFromCursor(String string) {
        Object object;
        int n;
        int n2;
        Searchable searchable = this;
        if (searchable._reverseOrder) {
            return this.reverseFindFromCursor(string);
        }
        searchable = this;
        string = searchable._caseSensitive ? string : string.toLowerCase();
        int n3 = this.getCurrentIndex();
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = this.getElementCount()) == 0) {
            return -1;
        }
        for (n = n3; n < n2; ++n) {
            object = this.getElementAt(n);
            if (!this.compare(object, string)) continue;
            return n;
        }
        for (n = 0; n < n3; ++n) {
            object = this.getElementAt(n);
            if (!this.compare(object, string)) continue;
            return n;
        }
        return -1;
    }

    public int reverseFindFromCursor(String string) {
        Object object;
        int n;
        int n2;
        Searchable searchable = this;
        if (!searchable._reverseOrder) {
            return this.findFromCursor(string);
        }
        searchable = this;
        string = searchable._caseSensitive ? string : string.toLowerCase();
        int n3 = this.getCurrentIndex();
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = this.getElementCount()) == 0) {
            return -1;
        }
        for (n = n3; n >= 0; --n) {
            object = this.getElementAt(n);
            if (!this.compare(object, string)) continue;
            return n;
        }
        for (n = n2 - 1; n >= n3; --n) {
            object = this.getElementAt(n);
            if (!this.compare(object, string)) continue;
            return n;
        }
        return -1;
    }

    public int findFirst(String string) {
        Searchable searchable = this;
        String string2 = searchable._caseSensitive ? string : string.toLowerCase();
        int n = this.getElementCount();
        if (n == 0) {
            if (string.length() > 0) {
                return -1;
            }
            return 0;
        }
        for (int i = 0; i < n; ++i) {
            Searchable searchable2;
            int n2 = i;
            int n3 = n;
            searchable = this;
            searchable = searchable;
            int n4 = searchable2._reverseOrder ? n3 - n2 - 1 : n2;
            Object object = this.getElementAt(n4);
            if (!this.compare(object, string2)) continue;
            return n4;
        }
        return -1;
    }

    public int findLast(String string) {
        Object object = this;
        object = ((Searchable)object)._caseSensitive ? string : string.toLowerCase();
        int n = this.getElementCount();
        if (n == 0) {
            if (string.length() > 0) {
                return -1;
            }
            return 0;
        }
        for (int i = n - 1; i >= 0; --i) {
            Object object2 = this.getElementAt(i);
            if (!this.compare(object2, (String)object)) continue;
            return i;
        }
        return -1;
    }

    protected final void keyTypedOrPressed(KeyEvent keyEvent) {
        if (this._searchableProvider != null && this._searchableProvider.isPassive()) {
            this._searchableProvider.processKeyEvent(keyEvent);
            return;
        }
        if (this.isActivateKey(keyEvent)) {
            Object object = "";
            if (keyEvent.getID() == 400) {
                if ((keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0) {
                    return;
                }
                if (keyEvent.isAltDown()) {
                    return;
                }
                object = String.valueOf(keyEvent.getKeyChar());
            }
            Object object2 = object;
            object = this;
            if (((Searchable)object)._searchableProvider == null) {
                ((Searchable)object).fireSearchableEvent(new SearchableEvent(object, 2999, (String)object2));
                Object object3 = object2;
                object2 = object;
                object3 = (Searchable)object2.new DefaultSearchPopup((String)object3);
                object2 = object;
                Object object4 = ((Searchable)object2)._component.getRootPane();
                ((Searchable)object2)._layeredPane = object4 != null ? ((JRootPane)object4).getLayeredPane() : null;
                if (((Searchable)object2)._layeredPane == null) {
                    ((Searchable)object2)._popup = object3;
                    object4 = super.updateSizeAndLocation();
                    if (object4 != null) {
                        ((JidePopup)object3).showPopup(((Point)object4).x, ((Point)object4).y);
                        ((Searchable)object2)._popup.setVisible(true);
                    } else {
                        ((Searchable)object2)._popup = null;
                    }
                } else {
                    object4 = object2;
                    if (((Searchable)object2)._popup != null && ((Searchable)object2)._layeredPane != null) {
                        ((Searchable)object2)._layeredPane.remove(((Searchable)object2)._popup);
                        ((Searchable)object2)._layeredPane.validate();
                        ((Searchable)object2)._layeredPane.repaint();
                        ((Searchable)object2)._layeredPane = null;
                    } else {
                        ((Searchable)object2)._popup = !((Searchable)object2)._component.isShowing() ? null : object3;
                    }
                    if (((Searchable)object2)._popup != null && ((Searchable)object2)._component.isDisplayable()) {
                        if (((Searchable)object2)._layeredPane == null) {
                            System.err.println("Failed to find layeredPane.");
                        } else {
                            ((Searchable)object2)._layeredPane.add((Component)((Searchable)object2)._popup, JLayeredPane.POPUP_LAYER);
                            super.updateSizeAndLocation();
                            ((Searchable)object2)._popup.setVisible(true);
                            ((Searchable)object2)._popup.validate();
                        }
                    }
                }
                ((Searchable)object)._searchableProvider = new SearchableProvider((Searchable)object){
                    private /* synthetic */ Searchable this$0;
                    {
                        this.this$0 = searchable;
                    }

                    public final String getSearchingText() {
                        if (this.this$0._popup != null) {
                            return this.this$0._popup.getSearchingText();
                        }
                        return "";
                    }

                    public final boolean isPassive() {
                        return true;
                    }

                    public final void processKeyEvent(KeyEvent keyEvent) {
                        if (this.this$0._popup != null) {
                            this.this$0._popup.processKeyEvent(keyEvent);
                        }
                    }
                };
            }
            if (keyEvent.getKeyCode() != 10) {
                keyEvent.consume();
            }
        }
    }

    public final String getSearchingText() {
        if (this._searchableProvider != null) {
            return this._searchableProvider.getSearchingText();
        }
        return "";
    }

    private Point updateSizeAndLocation() {
        Object object = this;
        Object object2 = null;
        if (null == null) {
            object2 = JideSwingUtilities.getScrollPane(this._component);
        }
        if (object2 == null) {
            object2 = this._component;
        }
        if (this._popup != null) {
            Dimension dimension = this._popup.getPreferredSize();
            object = this;
            switch (((Searchable)object)._popupLocation) {
                case 3: {
                    try {
                        object = ((Component)object2).getLocationOnScreen();
                        ((Point)object).y += ((Component)object2).getHeight();
                        object2 = this;
                        SwingUtilities.convertPointFromScreen((Point)object, this._layeredPane);
                        if (((Point)object).y + dimension.height <= this._layeredPane.getHeight()) break;
                        ((Point)object).y = this._layeredPane.getHeight() - dimension.height;
                        break;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        return null;
                    }
                }
                default: {
                    try {
                        object = ((Component)object2).getLocationOnScreen();
                        object2 = this;
                        SwingUtilities.convertPointFromScreen((Point)object, this._layeredPane);
                        ((Point)object).y -= dimension.height;
                        if (((Point)object).y >= 0) break;
                        ((Point)object).y = 0;
                        break;
                    }
                    catch (IllegalComponentStateException illegalComponentStateException) {
                        return null;
                    }
                }
            }
            object2 = this;
            this._popup.setLocation((Point)object);
            this._popup.setSize(dimension);
            return object;
        }
        return null;
    }

    protected static boolean isFindFirstKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 36;
    }

    protected static boolean isFindLastKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 35;
    }

    protected static boolean isFindPreviousKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 38;
    }

    protected static boolean isFindNextKey(KeyEvent keyEvent) {
        return keyEvent.getKeyCode() == 40;
    }

    protected final boolean isNavigationKey(KeyEvent keyEvent) {
        return Searchable.isFindFirstKey(keyEvent) || Searchable.isFindLastKey(keyEvent) || Searchable.isFindNextKey(keyEvent) || Searchable.isFindPreviousKey(keyEvent);
    }

    protected boolean isActivateKey(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        return keyEvent.getID() == 400 && (Character.isLetterOrDigit(c) || c == '*' || c == '?');
    }

    protected static boolean isSelectAllKey(KeyEvent keyEvent) {
        return (keyEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0 && keyEvent.getKeyCode() == 65;
    }

    public final boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public final void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }

    public final boolean isRepeats() {
        return this._repeats;
    }

    public final void setRepeats(boolean bl) {
        this._repeats = bl;
    }

    public final String getSearchLabel() {
        return this.getResourceString("Searchable.searchFor");
    }

    public final void addSearchableListener(SearchableListener searchableListener) {
        this.listenerList.add(SearchableListener.class, searchableListener);
    }

    protected final void fireSearchableEvent(SearchableEvent searchableEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SearchableListener.class) continue;
            ((SearchableListener)objectArray[i + 1]).searchableEventFired(searchableEvent);
        }
    }

    public final Component getComponent() {
        return this._component;
    }

    public final boolean isReverseOrder() {
        return this._reverseOrder;
    }

    public final void setReverseOrder(boolean bl) {
        this._reverseOrder = bl;
    }

    protected final String getResourceString(String string) {
        return Resource.getResourceBundle(this._component != null ? this._component.getLocale() : Locale.getDefault()).getString(string);
    }

    public abstract class SearchPopup
    extends JidePopup {
        protected SearchField _textField;
        private /* synthetic */ Searchable this$0;

        public SearchPopup(Searchable searchable) {
            this.this$0 = searchable;
        }

        public void processKeyEvent(KeyEvent serializable) {
            this._textField.processKeyEvent((KeyEvent)serializable);
            if (((InputEvent)serializable).isConsumed()) {
                Object object = this.getSearchingText();
                if (((String)object).length() == 0) {
                    return;
                }
                if (Searchable.isSelectAllKey((KeyEvent)serializable)) {
                    int n;
                    boolean bl;
                    int n2;
                    String string = object;
                    object = serializable;
                    serializable = this;
                    boolean bl2 = ((SearchPopup)serializable).this$0.isReverseOrder();
                    if (bl2) {
                        ((SearchPopup)serializable).this$0.setReverseOrder(false);
                    }
                    if ((n2 = ((SearchPopup)serializable).this$0.findFirst(string)) != -1) {
                        ((SearchPopup)serializable).this$0.setSelectedIndex(n2, false);
                        ((SearchPopup)serializable).this$0.setCursor(n2);
                    }
                    if (bl = ((SearchPopup)serializable).this$0.isRepeats()) {
                        ((SearchPopup)serializable).this$0.setRepeats(false);
                    }
                    while (n2 != -1 && (n2 = n2 == (n = ((SearchPopup)serializable).this$0.findNext(string)) ? -1 : n) != -1) {
                        ((SearchPopup)serializable).select(n2, (KeyEvent)object, string);
                    }
                    if (bl) {
                        ((SearchPopup)serializable).this$0.setRepeats(bl);
                    }
                    if (bl2) {
                        ((SearchPopup)serializable).this$0.setReverseOrder(bl2);
                    }
                    return;
                }
                if (Searchable.isFindPreviousKey((KeyEvent)serializable)) {
                    int n = this.this$0.findPrevious((String)object);
                    this.select(n, (KeyEvent)serializable, (String)object);
                } else if (Searchable.isFindNextKey((KeyEvent)serializable)) {
                    int n = this.this$0.findNext((String)object);
                    this.select(n, (KeyEvent)serializable, (String)object);
                } else if (Searchable.isFindFirstKey((KeyEvent)serializable)) {
                    int n = this.this$0.findFirst((String)object);
                    this.select(n, (KeyEvent)serializable, (String)object);
                } else if (Searchable.isFindLastKey((KeyEvent)serializable)) {
                    int n = this.this$0.findLast((String)object);
                    this.select(n, (KeyEvent)serializable, (String)object);
                }
            }
            if (((KeyEvent)serializable).getKeyCode() != 10) {
                ((InputEvent)serializable).consume();
            }
        }

        public final String getSearchingText() {
            if (this._textField != null) {
                return this._textField.getText();
            }
            return "";
        }

        protected abstract void select(int var1, KeyEvent var2, String var3);
    }

    final class DefaultSearchPopup
    extends SearchPopup {
        private JLabel _label;
        private JLabel _noMatch;

        public DefaultSearchPopup(String object2) {
            super((Searchable)Searchable.this);
            Searchable.this = this;
            Object object3 = ((DefaultSearchPopup)Searchable.this).Searchable.this;
            Color color = UIDefaultsLookup.getColor("ToolTip.foreground");
            object3 = ((DefaultSearchPopup)Searchable.this).Searchable.this;
            object3 = UIDefaultsLookup.getColor("ToolTip.background");
            ((DefaultSearchPopup)Searchable.this)._label = new JLabel(((DefaultSearchPopup)Searchable.this).Searchable.this.getSearchLabel());
            ((DefaultSearchPopup)Searchable.this)._label.setForeground(color);
            ((DefaultSearchPopup)Searchable.this)._label.setVerticalAlignment(3);
            ((DefaultSearchPopup)Searchable.this)._noMatch = new JLabel();
            Searchable searchable = ((DefaultSearchPopup)Searchable.this).Searchable.this;
            ((DefaultSearchPopup)Searchable.this)._noMatch.setForeground(Color.RED);
            ((DefaultSearchPopup)Searchable.this)._noMatch.setVerticalAlignment(3);
            ((DefaultSearchPopup)Searchable.this)._textField = new SearchField(((DefaultSearchPopup)Searchable.this).Searchable.this);
            ((DefaultSearchPopup)Searchable.this)._textField.setFocusable(false);
            ((DefaultSearchPopup)Searchable.this)._textField.setBorder(BorderFactory.createEmptyBorder());
            ((DefaultSearchPopup)Searchable.this)._textField.setForeground(color);
            ((DefaultSearchPopup)Searchable.this)._textField.setCursor(((Component)Searchable.this).getCursor());
            ((DefaultSearchPopup)Searchable.this)._textField.getDocument().addDocumentListener(new DocumentListener((DefaultSearchPopup)Searchable.this, color){
                private Timer timer = new Timer(200, new ActionListener(this){
                    private /* synthetic */ 1 this$2;
                    {
                        this.this$2 = var1_1;
                    }

                    public final void actionPerformed(ActionEvent actionEvent) {
                        this.this$2.applyText();
                    }
                });
                private /* synthetic */ Color val$foreground;
                private /* synthetic */ DefaultSearchPopup this$1;
                {
                    this.this$1 = defaultSearchPopup;
                    this.val$foreground = color;
                }

                public final void insertUpdate(DocumentEvent documentEvent) {
                    this.startTimer();
                }

                public final void removeUpdate(DocumentEvent documentEvent) {
                    this.startTimer();
                }

                public final void changedUpdate(DocumentEvent documentEvent) {
                    this.startTimer();
                }

                protected final void applyText() {
                    String string = this.this$1._textField.getText().trim();
                    if (string.length() != 0) {
                        int n = this.this$1.Searchable.this.findFromCursor(string);
                        if (n == -1) {
                            Searchable searchable = this.this$1.Searchable.this;
                            this.this$1._textField.setForeground(Color.RED);
                        } else {
                            this.this$1._textField.setForeground(this.val$foreground);
                        }
                        this.this$1.select(n, null, string);
                        return;
                    }
                    this.this$1.hidePopup();
                }

                private void startTimer() {
                    this.this$1.updatePopupBounds();
                    Searchable searchable = this.this$1.Searchable.this;
                    this.applyText();
                }
            });
            ((DefaultSearchPopup)Searchable.this)._textField.setText((String)object2);
            ((JComponent)Searchable.this).setBackground((Color)object3);
            ((JComponent)Searchable.this).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("controlShadow"), 1), BorderFactory.createEmptyBorder(0, 6, 1, 8)));
            ((JidePopup)Searchable.this).setLayout(new BorderLayout(2, 0));
            object2 = ((DefaultSearchPopup)Searchable.this)._label.getPreferredSize();
            ((DefaultSearchPopup)Searchable.this)._label.getPreferredSize().height = ((DefaultSearchPopup)Searchable.this)._textField.getPreferredSize().height;
            ((DefaultSearchPopup)Searchable.this)._label.setPreferredSize((Dimension)object2);
            ((Container)Searchable.this).add((Component)((DefaultSearchPopup)Searchable.this)._label, "Before");
            ((Container)Searchable.this).add((Component)((DefaultSearchPopup)Searchable.this)._textField, "Center");
            ((Container)Searchable.this).add((Component)((DefaultSearchPopup)Searchable.this)._noMatch, "After");
            ((JidePopup)Searchable.this).setPopupBorder(BorderFactory.createEmptyBorder());
        }

        protected final void select(int n, KeyEvent object, String string) {
            if (n != -1) {
                boolean bl = object != null && (((InputEvent)object).getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
                Searchable.this.setSelectedIndex(n, bl);
                Searchable.this.setCursor(n, bl);
                this._textField.setForeground(this.getForeground());
                this._noMatch.setText("");
            } else {
                object = Searchable.this;
                this._textField.setForeground(Color.RED);
                this._noMatch.setText(Searchable.this.getResourceString("Searchable.noMatch"));
            }
            this.updatePopupBounds();
            Searchable.this.firePropertyChangeEvent(string);
            if (n != -1) {
                Object object2 = Searchable.this.getElementAt(n);
                Searchable.this.fireSearchableEvent(new SearchableEvent(Searchable.this, 3002, string, object2, Searchable.this.convertElementToString(object2)));
                return;
            }
            Searchable.this.fireSearchableEvent(new SearchableEvent(Searchable.this, 3003, string));
        }

        private void updatePopupBounds() {
            if (Searchable.this._popup != null) {
                this._textField.invalidate();
                try {
                    Object object = Searchable.this;
                    object = this._noMatch.getPreferredSize();
                    ((Dimension)object).width += this._label.getPreferredSize().width;
                    ((Dimension)object).width += new JLabel((String)this._textField.getText()).getPreferredSize().width + 24;
                    ((Dimension)object).height = ((Searchable)Searchable.this)._popup.getSize().height;
                    Searchable.this._popup.setSize((Dimension)object);
                    Searchable.this._popup.validate();
                }
                catch (Exception exception) {}
            }
        }
    }

    public final class SearchField
    extends JTextField {
        private /* synthetic */ Searchable this$0;

        SearchField(Searchable searchable) {
            this.this$0 = searchable;
            JideSwingUtilities.setTextComponentTransparent(this);
        }

        public final Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            super.getPreferredSize().width = this.getFontMetrics(this.getFont()).stringWidth(this.getText()) + 4;
            return dimension;
        }

        public final void processKeyEvent(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 8 && this.getDocument().getLength() == 0) {
                keyEvent.consume();
                return;
            }
            boolean bl = this.this$0.isNavigationKey(keyEvent);
            KeyEvent keyEvent2 = keyEvent;
            int n2 = keyEvent2.getKeyCode();
            if ((n2 == 10 || n2 == 27 || n2 == 33 || n2 == 34 || n2 == 36 || n2 == 35 || n2 == 37 || n2 == 39 || n2 == 38 || n2 == 40) && !bl) {
                this.this$0.hidePopup();
                if (n == 27) {
                    keyEvent.consume();
                }
                return;
            }
            super.processKeyEvent(keyEvent);
            if (n == 8 || bl) {
                keyEvent.consume();
            }
            if (Searchable.isSelectAllKey(keyEvent)) {
                keyEvent.consume();
            }
        }
    }
}

