/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideTabbedPaneUI;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TabEditingEvent;
import com.jidesoft.swing.TabEditingListener;
import com.jidesoft.utils.JideFocusTracker;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;

public class JideTabbedPane
extends JTabbedPane {
    private boolean _hideOneTab = false;
    private boolean _showTabButtons = false;
    private boolean _showCloseButton = false;
    private boolean _showCloseButtonOnTab = false;
    private boolean _useDefaultShowCloseButtonOnTab = false;
    private boolean _showTabArea = true;
    private boolean _showTabContent = true;
    private boolean _showIconsOnTab = true;
    private boolean _useDefaultShowIconsOnTab = true;
    private boolean _scrollSelectedTabOnWheel = false;
    private boolean _showGripper = false;
    private boolean _boldActiveTab = false;
    private Map _closableMap = new Hashtable();
    private Hashtable _pageLastFocusTrackers = new Hashtable();
    private Font _selectedTabFont;
    private int _tabResizeMode = 0;
    private int _colorTheme = 0;
    private int _tabShape = 0;
    private Component _tabLeadingComponent = null;
    private Component _tabTrailingComponent = null;
    private boolean _showCloseButtonOnSelectedTab = false;
    private Insets _contentBorderInsets;
    private static final Logger LOGGER_EVENT = Logger.getLogger(TabEditingEvent.class.getName());
    private boolean closeTabOnMouseMiddleButton = false;
    private Action _closeAction;
    private boolean _autoFocusonTabHideClose = true;
    private boolean _suppressStateChangedEvents = false;
    private boolean _suppressSetSelectedIndex = false;
    private boolean _autoRequestFocus = true;
    private transient boolean _tabEditingAllowed = false;
    private static Color[] ONENOTE_COLORS = new Color[]{new Color(138, 168, 228), new Color(238, 149, 151), new Color(180, 158, 222), new Color(145, 186, 174), new Color(246, 176, 120), new Color(255, 216, 105), new Color(183, 201, 151)};
    private PropertyChangeListener _focusChangeListener;

    public JideTabbedPane() {
        this(1, 1);
    }

    public JideTabbedPane(int n) {
        this(1, 1);
    }

    private JideTabbedPane(int n, int n2) {
        super(n, 1);
        this.setModel(new IgnoreableSingleSelectionModel(this));
    }

    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.ui;
    }

    public void setUI(TabbedPaneUI tabbedPaneUI) {
        super.setUI(tabbedPaneUI);
    }

    public void updateUI() {
        if (UIDefaultsLookup.get("JideTabbedPaneUI") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "JideTabbedPaneUI";
    }

    public final boolean isTabShown() {
        JideTabbedPane jideTabbedPane = this;
        if (jideTabbedPane._showTabArea) {
            jideTabbedPane = this;
            return true;
        }
        return false;
    }

    public final boolean isShowTabButtons() {
        return false;
    }

    public final void setCloseAction(Action action) {
        Action action2 = this._closeAction;
        if (action2 != action) {
            this._closeAction = action;
            this.firePropertyChange("closeTabAction", action2, this._closeAction);
        }
    }

    public final Action getCloseAction() {
        return this._closeAction;
    }

    public final boolean isAutoFocusOnTabHideClose() {
        return this._autoFocusonTabHideClose;
    }

    protected void fireStateChanged() {
        JideTabbedPane jideTabbedPane = this;
        if (!jideTabbedPane._autoFocusonTabHideClose) {
            this.clearVisComp();
        }
        super.fireStateChanged();
    }

    public void setSelectedIndex(int n) {
        boolean bl = this.isFocusCycleRoot();
        this.setFocusCycleRoot(true);
        try {
            super.setSelectedIndex(n);
            return;
        }
        finally {
            this.setFocusCycleRoot(bl);
        }
    }

    public void setComponentAt(int n, Component component) {
        super.setComponentAt(n, component);
        JideTabbedPane jideTabbedPane = this;
        if (!jideTabbedPane._autoFocusonTabHideClose) {
            this.clearVisComp();
        }
    }

    public final boolean isAutoRequestFocus() {
        return this._autoRequestFocus;
    }

    private int getTabHeight() {
        if (this.getTabPlacement() == 1 || this.getTabPlacement() == 3) {
            return ((JideTabbedPaneUI)this.getUI()).getTabPanel().getHeight();
        }
        return ((JideTabbedPaneUI)this.getUI()).getTabPanel().getWidth();
    }

    public final boolean isRightClickSelect() {
        return false;
    }

    public final boolean isShowGripper() {
        return false;
    }

    public final boolean isShowIconsOnTab() {
        return this._showIconsOnTab;
    }

    public final boolean isUseDefaultShowIconsOnTab() {
        return this._useDefaultShowIconsOnTab;
    }

    public final boolean isShowCloseButtonOnTab() {
        return this._showCloseButtonOnTab;
    }

    public final void setShowCloseButtonOnTab(boolean bl) {
        bl = this._showCloseButtonOnTab;
        if (!bl) {
            this._showCloseButtonOnTab = true;
            this.firePropertyChange("showCloseButtonOnTab", bl, this._showCloseButtonOnTab);
            if (this._showCloseButtonOnTab) {
                this.setShowCloseButton(true);
            }
        }
        bl = false;
        JideTabbedPane jideTabbedPane = this;
        boolean bl2 = jideTabbedPane._useDefaultShowCloseButtonOnTab;
        if (bl2) {
            jideTabbedPane._useDefaultShowCloseButtonOnTab = false;
            jideTabbedPane.firePropertyChange("useDefaultShowCloseButtonOnTab", bl2, jideTabbedPane._useDefaultShowCloseButtonOnTab);
        }
    }

    public final boolean isUseDefaultShowCloseButtonOnTab() {
        return this._useDefaultShowCloseButtonOnTab;
    }

    public final boolean isTabEditingAllowed() {
        return false;
    }

    public final boolean isShowCloseButton() {
        return this._showCloseButton;
    }

    public final void setShowCloseButton(boolean bl) {
        bl = this._showCloseButton;
        if (!bl) {
            this._showCloseButton = true;
            this.firePropertyChange("showCloseButton", bl, this._showCloseButton);
        }
    }

    public final boolean isShowTabArea() {
        return this._showTabArea;
    }

    public final boolean isShowTabContent() {
        return this._showTabContent;
    }

    public final String getDisplayTitleAt(int n) {
        return super.getTitleAt(n);
    }

    public final boolean isBoldActiveTab() {
        return false;
    }

    public void removeTabAt(int n) {
        int n2 = this.getTabCount();
        int n3 = this.getSelectedIndex();
        boolean bl = false;
        if (n3 == n && n3 < n2 - 1) {
            bl = !SystemInfo.isJdk15Above();
        }
        n2 = 0;
        String string = this.getTitleAt(n);
        if (this._closableMap.containsKey(string)) {
            n2 = 1;
        }
        Component component = this.getComponentAt(n);
        JideTabbedPane jideTabbedPane = this;
        if (!jideTabbedPane._autoFocusonTabHideClose) {
            this.clearVisComp();
        }
        super.removeTabAt(n);
        if (n2 != 0) {
            this._closableMap.remove(string);
        }
        if (component != null) {
            PageLastFocusTracker pageLastFocusTracker = (PageLastFocusTracker)this._pageLastFocusTrackers.get(component);
            this._pageLastFocusTrackers.remove(component);
            if (pageLastFocusTracker != null) {
                pageLastFocusTracker.setHeighestComponent(null);
            }
        }
        if (bl) {
            try {
                this.fireStateChanged();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
            }
        }
        this.updateUI();
    }

    public void setTitleAt(int n, String string) {
        boolean bl = false;
        if (this._closableMap.containsKey(this.getTitleAt(n))) {
            bl = true;
        }
        super.setTitleAt(n, string);
        if (bl) {
            this._closableMap.put(string, "");
        }
    }

    public final boolean isTabClosableAt(int n) {
        return !this._closableMap.containsKey(n);
    }

    public final Component getLastFocusedComponent(Component object) {
        if (object == null) {
            return null;
        }
        JideTabbedPane jideTabbedPane = this;
        object = (object = (PageLastFocusTracker)jideTabbedPane._pageLastFocusTrackers.get(object)) != null ? ((PageLastFocusTracker)object).getLastFocusedComponent() : null;
        return object;
    }

    private void clearVisComp() {
        try {
            Field field = JTabbedPane.class.getDeclaredField("visComp");
            field.setAccessible(true);
            field.set(this, null);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        if (component != null && !component.isVisible()) {
            component.setVisible(false);
        }
        super.insertTab(string, icon, component, string2, n);
        if (component != null) {
            this._pageLastFocusTrackers.put(component, new PageLastFocusTracker(this, component));
        }
        this.fireStateChanged();
    }

    public final Font getSelectedTabFont() {
        return this._selectedTabFont;
    }

    public final void setSelectedTabFont(Font font) {
        this._selectedTabFont = font;
    }

    public final int getColorTheme() {
        return UIDefaultsLookup.getInt("JideTabbedPane.defaultTabColorTheme");
    }

    public final int getTabResizeMode() {
        return UIDefaultsLookup.getInt("JideTabbedPane.defaultResizeMode");
    }

    public final int getTabShape() {
        return UIDefaultsLookup.getInt("JideTabbedPane.defaultTabShape");
    }

    public final Component getTabLeadingComponent() {
        return null;
    }

    public final Component getTabTrailingComponent() {
        return null;
    }

    public final boolean isShowCloseButtonOnSelectedTab() {
        return false;
    }

    public final ColorProvider getTabColorProvider() {
        return null;
    }

    public final void editTabAt(int n) {
        boolean bl = ((JideTabbedPaneUI)this.getUI()).editTabAt(n);
        if (bl) {
            this.fireTabEditing(3099, n, this.getTitleAt(n), null);
        }
    }

    public final boolean isTabEditing() {
        return ((JideTabbedPaneUI)this.getUI()).isTabEditing();
    }

    public final void stopTabEditing() {
        int n = this.getEditingTabIndex();
        if (n != -1) {
            String string = this.getTitleAt(n);
            ((JideTabbedPaneUI)this.getUI()).stopTabEditing();
            String string2 = this.getTitleAt(n);
            this.fireTabEditing(3100, n, string, string2);
        }
    }

    public final void cancelTabEditing() {
        int n = this.getEditingTabIndex();
        if (n != -1) {
            ((JideTabbedPaneUI)this.getUI()).cancelTabEditing();
            this.fireTabEditing(3101, n, this.getTitleAt(n), this.getTitleAt(n));
        }
    }

    private int getEditingTabIndex() {
        return ((JideTabbedPaneUI)this.getUI()).getEditingTabIndex();
    }

    public final void repaintTabAreaAndContentBorder() {
        ((JideTabbedPaneUI)this.getUI()).getTabPanel().repaint(200L);
        Serializable serializable = this;
        serializable = serializable._contentBorderInsets;
        if (serializable == null) {
            LookAndFeelFactory.installJideExtension();
            serializable = this;
            serializable = serializable._contentBorderInsets;
        }
        if (serializable != null && (((Insets)serializable).top != 0 || ((Insets)serializable).bottom != 0 || ((Insets)serializable).left != 0 || ((Insets)serializable).right != 0)) {
            Insets insets = new Insets(0, 0, 0, 0);
            BasicJideTabbedPaneUI.rotateInsets((Insets)serializable, insets, this.tabPlacement);
            switch (this.getTabPlacement()) {
                case 1: {
                    insets.top += this.getTabHeight();
                    break;
                }
                case 3: {
                    insets.bottom += this.getTabHeight();
                    break;
                }
                case 2: {
                    insets.left += this.getTabHeight();
                    break;
                }
                case 4: {
                    insets.right += this.getTabHeight();
                }
            }
            if (insets.top != 0) {
                this.repaintContentBorder(0, 0, this.getWidth(), insets.top);
            }
            if (insets.left != 0) {
                this.repaintContentBorder(0, 0, insets.left, this.getHeight());
            }
            if (insets.right != 0) {
                this.repaintContentBorder(this.getWidth() - insets.right, 0, insets.right, this.getHeight());
            }
            if (insets.bottom != 0) {
                this.repaintContentBorder(0, this.getHeight() - insets.bottom, this.getWidth(), insets.bottom);
            }
        }
    }

    private void repaintContentBorder(int n, int n2, int n3, int n4) {
        this.repaint(n, n2, n3, n4);
    }

    public void addNotify() {
        super.addNotify();
        if (this._focusChangeListener == null) {
            JideTabbedPane jideTabbedPane = this;
            this._focusChangeListener = new PropertyChangeListener(jideTabbedPane){
                private /* synthetic */ JideTabbedPane this$0;
                {
                    this.this$0 = jideTabbedPane;
                }

                public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = this.this$0.isAncestorOf((Component)propertyChangeEvent.getOldValue()) || this.this$0 == propertyChangeEvent.getOldValue();
                    boolean bl2 = this.this$0 == propertyChangeEvent.getNewValue() || this.this$0.hasFocusComponent();
                    if (bl2 != bl) {
                        this.this$0.repaintTabAreaAndContentBorder();
                    }
                }
            };
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this._focusChangeListener);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._focusChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("focusOwner", this._focusChangeListener);
            this._focusChangeListener = null;
        }
    }

    public final ListCellRenderer getTabListCellRenderer() {
        return new TabListCellRenderer();
    }

    public final boolean hasFocusComponent() {
        return JideSwingUtilities.isAncestorOfFocusOwner(this);
    }

    public final Insets getContentBorderInsets() {
        return this._contentBorderInsets;
    }

    public final void setContentBorderInsets(Insets insets) {
        Insets insets2 = this._contentBorderInsets;
        this._contentBorderInsets = insets;
        this.firePropertyChange("contentBorderInsets", insets2, this._contentBorderInsets);
    }

    public final boolean isDragOverDisabled() {
        return false;
    }

    private void fireTabEditing(int n, int n2, String string, String string2) {
        if (LOGGER_EVENT.isLoggable(Level.FINE)) {
            switch (n) {
                case 3099: {
                    LOGGER_EVENT.fine("TabEditing Started at tab \"" + n2 + "\"; the current title is " + string);
                    break;
                }
                case 3100: {
                    LOGGER_EVENT.fine("TabEditing Stopped at tab \"" + n2 + "\"; the old title is " + string + "; the new title is " + string2);
                    break;
                }
                case 3101: {
                    LOGGER_EVENT.fine("TabEditing Cancelled at tab \"" + n2 + "\"; the current title remains " + string);
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TabEditingListener.class) continue;
            new TabEditingEvent(this, n, n2, string, string2);
        }
    }

    public final Icon getIconForTab(int n) {
        boolean bl = UIDefaultsLookup.getBoolean("JideTabbedPane.showIconOnTab");
        JideTabbedPane jideTabbedPane = this;
        if (jideTabbedPane._useDefaultShowIconsOnTab) {
            if (bl) {
                if (!this.isEnabled() || !this.isEnabledAt(n)) {
                    return this.getDisabledIconAt(n);
                }
                return this.getIconAt(n);
            }
            return null;
        }
        jideTabbedPane = this;
        if (jideTabbedPane._showIconsOnTab) {
            if (!this.isEnabled() || !this.isEnabledAt(n)) {
                return this.getDisabledIconAt(n);
            }
            return this.getIconAt(n);
        }
        return null;
    }

    public final boolean isScrollSelectedTabOnWheel() {
        return false;
    }

    public final boolean isCloseTabOnMouseMiddleButton() {
        return false;
    }

    static /* synthetic */ boolean access$000(JideTabbedPane jideTabbedPane) {
        return false;
    }

    static /* synthetic */ Color[] access$300() {
        return ONENOTE_COLORS;
    }

    public static final class TabListCellRenderer
    extends DefaultListCellRenderer {
        public final Component getListCellRendererComponent(JList jComponent, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof JideTabbedPane) {
                object = (JideTabbedPane)object;
                String string = ((JTabbedPane)object).getTitleAt(n);
                String string2 = ((JTabbedPane)object).getToolTipTextAt(n);
                Icon icon = ((JideTabbedPane)object).getIconForTab(n);
                jComponent = (JLabel)super.getListCellRendererComponent((JList<?>)jComponent, string, n, bl, bl2);
                jComponent.setToolTipText(string2);
                ((Component)object).getFont();
                Font font = ((JTabbedPane)object).getSelectedIndex() == n ? ((JideTabbedPane)object).getSelectedTabFont() : ((Component)object).getFont();
                if (((JTabbedPane)object).getSelectedIndex() == n && ((JideTabbedPane)object).isBoldActiveTab() && font.getStyle() != 1) {
                    font = font.deriveFont(1);
                }
                jComponent.setFont(font);
                ((JLabel)jComponent).setIcon(icon);
                jComponent.setEnabled(((JTabbedPane)object).isEnabledAt(n));
                return jComponent;
            }
            return super.getListCellRendererComponent((JList<?>)jComponent, object, n, bl, bl2);
        }
    }

    public static interface GradientColorProvider
    extends ColorProvider {
        public Color getTopBackgroundAt$361b9f0e();
    }

    public static interface ColorProvider {
        public Color getBackgroundAt(int var1);

        public Color getForegroudAt$361b9f0e();
    }

    public final class PageLastFocusTracker
    extends JideFocusTracker {
        private Component _lastFocusedComponent;
        private FocusListener _lastFocusedListener;

        protected PageLastFocusTracker(JideTabbedPane jideTabbedPane, Component component) {
            this.setHeighestComponent(component);
        }

        protected final Component getLastFocusedComponent() {
            return this._lastFocusedComponent;
        }

        public final void setHeighestComponent(Component component) {
            if (component == null) {
                if (this._lastFocusedListener != null) {
                    this.removeFocusListener(this._lastFocusedListener);
                    this._lastFocusedListener = null;
                }
            } else if (this._lastFocusedListener == null) {
                this._lastFocusedListener = new FocusAdapter(this){
                    private /* synthetic */ PageLastFocusTracker this$1;
                    {
                        this.this$1 = pageLastFocusTracker;
                    }

                    public final void focusGained(FocusEvent focusEvent) {
                        this.this$1._lastFocusedComponent = focusEvent.getComponent();
                    }
                };
                this.addFocusListener(this._lastFocusedListener);
            }
            super.setHeighestComponent(component);
        }
    }

    public final class IgnoreableSingleSelectionModel
    extends DefaultSingleSelectionModel {
        private /* synthetic */ JideTabbedPane this$0;

        protected IgnoreableSingleSelectionModel(JideTabbedPane jideTabbedPane) {
            this.this$0 = jideTabbedPane;
        }

        protected final void fireStateChanged() {
            if (!JideTabbedPane.access$000(this.this$0)) {
                super.fireStateChanged();
            }
        }
    }
}

