/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import java.awt.Cursor;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public final class Gripper
extends JComponent
implements Alignable,
SwingConstants,
UIResource {
    private boolean _rolloverEnabled = false;
    private boolean _rollover;
    private int _orientation;

    public Gripper() {
        this(0);
    }

    private Gripper(int n) {
        this.setOrientation(0);
        this.setFocusable(false);
        this.updateUI();
    }

    public final void updateUI() {
        if (UIDefaultsLookup.get("GripperUI") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    public final String getUIClassID() {
        return "GripperUI";
    }

    public final void setOrientation(int n) {
        int n2 = this._orientation;
        if (n2 != n) {
            this._orientation = n;
            this.firePropertyChange("orientation", n2, n);
        }
    }

    public final int getOrientation() {
        return this._orientation;
    }

    public final Cursor getCursor() {
        if (this.isEnabled()) {
            return Cursor.getPredefinedCursor(13);
        }
        return super.getCursor();
    }

    public final boolean isRolloverEnabled() {
        return this._rolloverEnabled;
    }

    public final void setRolloverEnabled(boolean bl) {
        bl = this._rolloverEnabled;
        if (!bl) {
            this._rolloverEnabled = true;
            this.firePropertyChange("rolloverEnabled", bl, this._rolloverEnabled);
            this.repaint();
        }
    }

    public final boolean isRollover() {
        return this._rollover;
    }

    public final void setRollover(boolean bl) {
        boolean bl2 = this._rollover;
        if (bl != bl2) {
            this._rollover = bl;
            this.firePropertyChange("ROLLOVER", bl2, bl);
            this.repaint();
        }
    }
}

