/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Calculator
extends JPanel
implements ActionListener {
    private double _result;
    private StringBuffer _op1 = new StringBuffer();
    private StringBuffer _op2 = new StringBuffer();
    private int _operator = -1;
    private String _displayText;
    private boolean _overflow = false;
    private boolean _negationOp1 = true;
    private boolean _backspaceOp1 = false;
    private boolean _backspaceOp2 = false;
    private boolean _clearOperatorPending = false;
    private boolean _isFakedEqualPressed = false;
    private AbstractButton _addButton;
    private AbstractButton _minusButton;
    private AbstractButton _multiplyButton;
    private AbstractButton _divideButton;
    private AbstractButton _pointButton;
    private AbstractButton _equalButton;
    private AbstractButton _backspaceButton;
    private AbstractButton _clearButton;
    private AbstractButton _negativeButton;
    private AbstractButton[] _numberButtons;
    private NumberFormat _displayFormat;
    private int _buttonWidth = 24;
    private int _buttonHeight = 24;
    private int _buttonGap = 2;

    public Calculator() {
        this.initComponents();
        this._displayFormat = NumberFormat.getNumberInstance();
        Calculator calculator = this;
        calculator._displayFormat.setMaximumFractionDigits(20);
        calculator._displayFormat.setMinimumFractionDigits(0);
        calculator._displayFormat.setGroupingUsed(false);
        boolean bl = true;
        Calculator calculator2 = this;
        Calculator calculator3 = this;
        calculator2.registerKeyboardAction(calculator3, "+", KeyStroke.getKeyStroke('+'), 1);
        calculator2.registerKeyboardAction(calculator3, "-", KeyStroke.getKeyStroke('-'), 1);
        calculator2.registerKeyboardAction(calculator3, "*", KeyStroke.getKeyStroke('*'), 1);
        calculator2.registerKeyboardAction(calculator3, "/", KeyStroke.getKeyStroke('/'), 1);
        calculator2.registerKeyboardAction(calculator3, "=", KeyStroke.getKeyStroke('='), 1);
        calculator2.registerKeyboardAction(calculator3, "=", KeyStroke.getKeyStroke(10, 0), 1);
        calculator2.registerKeyboardAction(calculator3, "0", KeyStroke.getKeyStroke('0'), 1);
        calculator2.registerKeyboardAction(calculator3, "1", KeyStroke.getKeyStroke('1'), 1);
        calculator2.registerKeyboardAction(calculator3, "2", KeyStroke.getKeyStroke('2'), 1);
        calculator2.registerKeyboardAction(calculator3, "3", KeyStroke.getKeyStroke('3'), 1);
        calculator2.registerKeyboardAction(calculator3, "4", KeyStroke.getKeyStroke('4'), 1);
        calculator2.registerKeyboardAction(calculator3, "5", KeyStroke.getKeyStroke('5'), 1);
        calculator2.registerKeyboardAction(calculator3, "6", KeyStroke.getKeyStroke('6'), 1);
        calculator2.registerKeyboardAction(calculator3, "7", KeyStroke.getKeyStroke('7'), 1);
        calculator2.registerKeyboardAction(calculator3, "8", KeyStroke.getKeyStroke('8'), 1);
        calculator2.registerKeyboardAction(calculator3, "9", KeyStroke.getKeyStroke('9'), 1);
        calculator2.registerKeyboardAction(calculator3, ".", KeyStroke.getKeyStroke('.'), 1);
        calculator2.registerKeyboardAction(calculator3, "<", KeyStroke.getKeyStroke(8, 0), 1);
        calculator2.registerKeyboardAction(calculator3, "c", KeyStroke.getKeyStroke(27, 0), 1);
        calculator2.registerKeyboardAction(calculator3, "c", KeyStroke.getKeyStroke(27, 0), 1);
        calculator2.registerKeyboardAction(calculator3, "c", KeyStroke.getKeyStroke(Character.toUpperCase('c')), 1);
        calculator2.registerKeyboardAction(calculator3, "c", KeyStroke.getKeyStroke(Character.toLowerCase('c')), 1);
    }

    private void initComponents() {
        this.setLayout(new CalculatorLayoutManager(this));
        String string = "+";
        Calculator calculator = this;
        this._addButton = calculator.createButton(string, null);
        this.add(this._addButton);
        string = "-";
        calculator = this;
        this._minusButton = calculator.createButton(string, null);
        this.add(this._minusButton);
        string = "*";
        calculator = this;
        this._multiplyButton = calculator.createButton(string, null);
        this.add(this._multiplyButton);
        string = "/";
        calculator = this;
        this._divideButton = calculator.createButton(string, null);
        this.add(this._divideButton);
        this._numberButtons = new AbstractButton[10];
        for (int i = 0; i <= 9; ++i) {
            string = "" + i;
            calculator = this;
            this._numberButtons[i] = calculator.createButton(string, null);
            this.add(this._numberButtons[i]);
        }
        string = ".";
        calculator = this;
        this._pointButton = calculator.createButton(string, null);
        this.add(this._pointButton);
        string = "=";
        calculator = this;
        this._equalButton = calculator.createButton(string, null);
        this.add(this._equalButton);
        this._backspaceButton = this.createButton(null, new BackspaceIcon(this));
        this.add(this._backspaceButton);
        this._negativeButton = this.createButton(null, new ToggleNegativeIcon(this));
        this.add(this._negativeButton);
        string = "C";
        calculator = this;
        this._clearButton = calculator.createButton(string, null);
        this.add(this._clearButton);
    }

    private AbstractButton createButton(String object, Icon icon) {
        object = new JideButton((String)object, icon);
        ((JComponent)object).setOpaque(true);
        ((AbstractButton)object).setContentAreaFilled(true);
        ((JComponent)object).setRequestFocusEnabled(false);
        ((Component)object).setFocusable(false);
        ((AbstractButton)object).addActionListener(this);
        return object;
    }

    private void input(char c) {
        if ('c' == Character.toLowerCase(c) || 'c' == Character.toUpperCase(c)) {
            Calculator calculator;
            Calculator calculator2 = calculator = this;
            calculator.setOperator(-1);
            calculator2._op1.setLength(0);
            calculator2._op2.setLength(0);
            calculator._overflow = false;
            calculator._clearOperatorPending = false;
            calculator.setDisplayText("0");
            return;
        }
        if (this._overflow) {
            PortingUtils.notifyUser();
            return;
        }
        if (Character.isDigit(c) || '.' == c) {
            if (this._clearOperatorPending) {
                this.setOperator(-1);
                this._op1.setLength(0);
                this._clearOperatorPending = false;
            }
            Calculator calculator = this;
            if (calculator._operator == -1) {
                if ('.' != c || this._op1.indexOf(".") == -1) {
                    this._op1.append(c);
                    this._backspaceOp1 = true;
                    this._backspaceOp2 = false;
                    this.setDisplayText(this._op1.toString());
                    return;
                }
                PortingUtils.notifyUser();
                return;
            }
            if ('.' != c || this._op2.indexOf(".") == -1) {
                this._op2.append(c);
                this._backspaceOp2 = true;
                this._backspaceOp1 = false;
                this.setDisplayText(this._op2.toString());
                return;
            }
            PortingUtils.notifyUser();
            return;
        }
        switch (c) {
            case '+': {
                this.operatorPressed(0);
                return;
            }
            case '-': {
                this.operatorPressed(1);
                return;
            }
            case '*': {
                this.operatorPressed(2);
                return;
            }
            case '/': {
                this.operatorPressed(3);
                return;
            }
            case '=': {
                this.calculateResult(true);
                this._clearOperatorPending = true;
                return;
            }
            case '!': {
                if (this._negationOp1) {
                    Calculator.negativePressed(this._op1);
                    this.setDisplayText(this._op1.toString());
                    return;
                }
                Calculator.negativePressed(this._op2);
                this.setDisplayText(this._op2.toString());
                return;
            }
            case '<': {
                if (this._backspaceOp1) {
                    Calculator.backspacePressed(this._op1);
                    this.setDisplayText(this._op1.toString());
                    return;
                }
                if (this._backspaceOp2) {
                    Calculator.backspacePressed(this._op2);
                    this.setDisplayText(this._op2.toString());
                    return;
                }
                PortingUtils.notifyUser();
            }
        }
    }

    private void operatorPressed(int n) {
        if (this._op1.length() == 0) {
            this._op1.append("0");
        } else {
            Calculator calculator = this;
            if (calculator._operator == -1) {
                this._op2.setLength(0);
                this.calculateResult(false);
            } else {
                if (this._op2.length() == 0) {
                    PortingUtils.notifyUser();
                    return;
                }
                this._isFakedEqualPressed = false;
                this.calculateResult(true);
                this._op1.setLength(0);
                this._op1.append(Double.valueOf(this._result).toString());
                this._op2.setLength(0);
            }
        }
        this.setOperator(n);
        this._negationOp1 = false;
        this._clearOperatorPending = false;
    }

    private static void negativePressed(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0) {
            return;
        }
        if (stringBuffer.charAt(0) == '-') {
            stringBuffer.deleteCharAt(0);
            return;
        }
        stringBuffer.insert(0, '-');
    }

    private static void backspacePressed(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0) {
            return;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
    }

    private void calculateResult(boolean bl) {
        Calculator calculator = this;
        if (calculator._operator == -1) {
            return;
        }
        if (this._op1.length() == 0) {
            PortingUtils.notifyUser();
            return;
        }
        if (bl) {
            if (this._op2.length() == 0) {
                this._op2.append(this._op1);
            }
        } else if (this._op2.length() == 0) {
            return;
        }
        double d = Double.parseDouble(this._op1.toString());
        double d2 = Double.parseDouble(this._op2.toString());
        if (!this._isFakedEqualPressed) {
            try {
                calculator = this;
                switch (calculator._operator) {
                    case 0: {
                        this._result = d + d2;
                        break;
                    }
                    case 1: {
                        this._result = d - d2;
                        break;
                    }
                    case 2: {
                        this._result = d * d2;
                        break;
                    }
                    case 3: {
                        if (d2 == 0.0) {
                            this._result = Double.NaN;
                            this._overflow = true;
                            break;
                        }
                        this._result = d / d2;
                    }
                }
            }
            catch (Exception exception) {
                this._overflow = true;
            }
        }
        if (this._overflow) {
            this.setDisplayText("E");
            return;
        }
        this._op1.setLength(0);
        if (this._displayFormat != null) {
            String string = this._displayFormat.format(this._result);
            this.setDisplayText(string);
        } else {
            this.setDisplayText("" + this._result);
        }
        Calculator calculator2 = this;
        this._op1.append(calculator2._displayText);
        this._negationOp1 = true;
        this._backspaceOp1 = true;
        this._backspaceOp2 = false;
    }

    private void setDisplayText(String string) {
        String string2 = this._displayText;
        this._displayText = string;
        this.firePropertyChange("displayText", string2, this._displayText);
    }

    private void setOperator(int n) {
        int n2 = this._operator;
        if (n2 != n) {
            this._operator = n;
            this.firePropertyChange("operator", new Integer(n2), new Integer(n));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this._addButton == object) {
            this.input('+');
            return;
        }
        if (this._minusButton == object) {
            this.input('-');
            return;
        }
        if (this._multiplyButton == object) {
            this.input('*');
            return;
        }
        if (this._divideButton == object) {
            this.input('/');
            return;
        }
        if (this._equalButton == object) {
            this._isFakedEqualPressed = actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equals("Faked");
            this.input('=');
            return;
        }
        if (this._pointButton == object) {
            this.input('.');
            return;
        }
        if (this._negativeButton == object) {
            this.input('!');
            return;
        }
        if (this._backspaceButton == object) {
            this.input('<');
            return;
        }
        if (this._clearButton == object) {
            this.input('c');
            return;
        }
        boolean bl = false;
        for (int i = 0; i <= 9; ++i) {
            if (this._numberButtons[i] != object) continue;
            this.input(("" + i).charAt(0));
            bl = true;
            break;
        }
        if (!bl) {
            if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().length() > 0) {
                this.fakePressButton(actionEvent.getActionCommand().charAt(0));
                return;
            }
            this.fakePressButton('=');
        }
    }

    private void fakePressButton(AbstractButton abstractButton) {
        this.actionPerformed(new ActionEvent(abstractButton, 0, null));
    }

    private void fakePressButton(char c) {
        switch (c) {
            case 'c': {
                this.fakePressButton(this._clearButton);
                return;
            }
            case '<': {
                this.fakePressButton(this._backspaceButton);
                return;
            }
            case '=': {
                this.fakePressButton(this._equalButton);
                return;
            }
            case '.': {
                this.fakePressButton(this._pointButton);
                return;
            }
            case '!': {
                this.fakePressButton(this._negativeButton);
                return;
            }
            case '+': {
                this.fakePressButton(this._addButton);
                return;
            }
            case '-': {
                this.fakePressButton(this._minusButton);
                return;
            }
            case '*': {
                this.fakePressButton(this._multiplyButton);
                return;
            }
            case '/': {
                this.fakePressButton(this._divideButton);
                return;
            }
            case '0': {
                this.fakePressButton(this._numberButtons[0]);
                return;
            }
            case '1': {
                this.fakePressButton(this._numberButtons[1]);
                return;
            }
            case '2': {
                this.fakePressButton(this._numberButtons[2]);
                return;
            }
            case '3': {
                this.fakePressButton(this._numberButtons[3]);
                return;
            }
            case '4': {
                this.fakePressButton(this._numberButtons[4]);
                return;
            }
            case '5': {
                this.fakePressButton(this._numberButtons[5]);
                return;
            }
            case '6': {
                this.fakePressButton(this._numberButtons[6]);
                return;
            }
            case '7': {
                this.fakePressButton(this._numberButtons[7]);
                return;
            }
            case '8': {
                this.fakePressButton(this._numberButtons[8]);
                return;
            }
            case '9': {
                this.fakePressButton(this._numberButtons[9]);
            }
        }
    }

    public final int getButtonWidth() {
        return this._buttonWidth;
    }

    public final int getButtonHeight() {
        return this._buttonHeight;
    }

    public final int getButtonGap() {
        return this._buttonGap;
    }

    public static void main(String[] object) {
        object = new Calculator();
        ((Calculator)object).input('1');
        super.input('0');
        super.input('*');
        super.input('2');
        super.input('4');
        super.input('=');
    }

    final class CalculatorLayoutManager
    implements LayoutManager {
        private /* synthetic */ Calculator this$0;

        public CalculatorLayoutManager(Calculator calculator) {
            this.this$0 = calculator;
        }

        public final void addLayoutComponent(String string, Component component) {
        }

        public final void removeLayoutComponent(Component component) {
        }

        public final Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public final Dimension minimumLayoutSize(Container container) {
            return new Dimension((this.this$0.getButtonWidth() << 2) + this.this$0.getButtonGap() * 3, this.this$0.getButtonHeight() * 5 + (this.this$0.getButtonGap() << 2));
        }

        public final void layoutContainer(Container container) {
            int n = this.this$0.getButtonWidth();
            int n2 = this.this$0.getButtonHeight();
            int n3 = this.this$0.getButtonGap();
            this.this$0._numberButtons[7].setBounds(0, 0, n, n2);
            int n4 = 0 + (n + n3);
            this.this$0._numberButtons[8].setBounds(n4, 0, n, n2);
            this.this$0._numberButtons[9].setBounds(n4 += n + n3, 0, n, n2);
            this.this$0._divideButton.setBounds(n4 += n + n3, 0, n, n2);
            int n5 = 0 + (n2 + n3);
            this.this$0._numberButtons[4].setBounds(0, n5, n, n2);
            n4 = 0 + (n + n3);
            this.this$0._numberButtons[5].setBounds(n4, n5, n, n2);
            this.this$0._numberButtons[6].setBounds(n4 += n + n3, n5, n, n2);
            this.this$0._multiplyButton.setBounds(n4 += n + n3, n5, n, n2);
            this.this$0._numberButtons[1].setBounds(0, n5 += n2 + n3, n, n2);
            n4 = 0 + (n + n3);
            this.this$0._numberButtons[2].setBounds(n4, n5, n, n2);
            this.this$0._numberButtons[3].setBounds(n4 += n + n3, n5, n, n2);
            this.this$0._minusButton.setBounds(n4 += n + n3, n5, n, n2);
            this.this$0._numberButtons[0].setBounds(0, n5 += n2 + n3, n, n2);
            n4 = 0 + (n + n3);
            this.this$0._pointButton.setBounds(n4, n5, n, n2);
            this.this$0._negativeButton.setBounds(n4 += n + n3, n5, n, n2);
            this.this$0._addButton.setBounds(n4 += n + n3, n5, n, n2);
            this.this$0._clearButton.setBounds(0, n5 += n2 + n3, n, n2);
            n4 = 0 + (n + n3);
            this.this$0._backspaceButton.setBounds(n4, n5, n, n2);
            this.this$0._equalButton.setBounds(n4 += n + n3, n5, (n << 1) + n3, n2);
        }
    }

    final class ToggleNegativeIcon
    implements Icon {
        public ToggleNegativeIcon(Calculator calculator) {
        }

        public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            graphics.setColor(component.getForeground());
            graphics.drawLine(n, n2 + 2, n + 6, n2 + 2);
            graphics.drawLine(n, n2 + 7, n + 6, n2 + 7);
            graphics.drawLine(n + 3, n2, n + 3, n2 + 5);
            graphics.setColor(color);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
        }

        public final int getIconWidth() {
            return 7;
        }

        public final int getIconHeight() {
            return 7;
        }
    }

    final class BackspaceIcon
    implements Icon {
        public BackspaceIcon(Calculator calculator) {
        }

        public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            Color color = graphics.getColor();
            graphics.setColor(component.getForeground());
            graphics.drawLine(n, n2 + 3, n + 3, n2);
            graphics.drawLine(n, n2 + 3, n + 3, n2 + 6);
            graphics.drawLine(n + 3, n2 + 3, n + 7, n2 + 3);
            graphics.setColor(color);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
        }

        public final int getIconWidth() {
            return 7;
        }

        public final int getIconHeight() {
            return 7;
        }
    }
}

