/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.swing.JideLabel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class BasicJideLabelUI
extends BasicLabelUI {
    private static final LabelUI INSTANCE = new BasicJideLabelUI();
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return INSTANCE;
    }

    protected void installDefaults(JLabel jLabel) {
        super.installDefaults(jLabel);
        LookAndFeel.installColorsAndFont(jLabel, "JideLabel.background", "JideLabel.foreground", "JideLabel.font");
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
            return dimension;
        }
        return new Dimension(dimension.height, dimension.width);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = super.getMaximumSize(jComponent);
        if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
            return dimension;
        }
        return new Dimension(dimension.height, dimension.width);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (JideSwingUtilities.getOrientationOf(jComponent) == 0) {
            return dimension;
        }
        return new Dimension(dimension.height, dimension.width);
    }

    public void paint(Graphics object, JComponent object2) {
        if (JideSwingUtilities.getOrientationOf((Component)object2) == 1) {
            JComponent jComponent = object2;
            object2 = object;
            object = this;
            int n = 1;
            if (jComponent instanceof JideLabel) {
                n = ((JideLabel)jComponent).isClockwise();
            }
            JLabel jLabel = (JLabel)jComponent;
            String string = jLabel.getText();
            Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
            if (icon != null || string != null) {
                FontMetrics fontMetrics = ((Graphics)object2).getFontMetrics();
                paintViewInsets = jComponent.getInsets(paintViewInsets);
                BasicJideLabelUI.paintViewR.x = BasicJideLabelUI.paintViewInsets.left;
                BasicJideLabelUI.paintViewR.y = BasicJideLabelUI.paintViewInsets.top;
                BasicJideLabelUI.paintViewR.height = jComponent.getWidth() - (BasicJideLabelUI.paintViewInsets.left + BasicJideLabelUI.paintViewInsets.right);
                BasicJideLabelUI.paintViewR.width = jComponent.getHeight() - (BasicJideLabelUI.paintViewInsets.top + BasicJideLabelUI.paintViewInsets.bottom);
                BasicJideLabelUI.paintIconR.height = 0;
                BasicJideLabelUI.paintIconR.width = 0;
                BasicJideLabelUI.paintIconR.y = 0;
                BasicJideLabelUI.paintIconR.x = 0;
                BasicJideLabelUI.paintTextR.height = 0;
                BasicJideLabelUI.paintTextR.width = 0;
                BasicJideLabelUI.paintTextR.y = 0;
                BasicJideLabelUI.paintTextR.x = 0;
                String string2 = ((BasicLabelUI)object).layoutCL(jLabel, fontMetrics, string, icon, paintViewR, paintIconR, paintTextR);
                Graphics2D graphics2D = (Graphics2D)object2;
                AffineTransform affineTransform = graphics2D.getTransform();
                if (n != 0) {
                    graphics2D.rotate(1.5707963267948966);
                    graphics2D.translate(0, -jComponent.getWidth());
                } else {
                    graphics2D.rotate(-1.5707963267948966);
                    graphics2D.translate(-jComponent.getHeight(), 0);
                }
                if (icon != null) {
                    icon.paintIcon(jComponent, (Graphics)object2, BasicJideLabelUI.paintIconR.x, BasicJideLabelUI.paintIconR.y);
                }
                if (string != null) {
                    int n2 = BasicJideLabelUI.paintTextR.x;
                    n = BasicJideLabelUI.paintTextR.y + fontMetrics.getAscent();
                    if (jLabel.isEnabled()) {
                        ((BasicLabelUI)object).paintEnabledText(jLabel, (Graphics)object2, string2, n2, n);
                    } else {
                        ((BasicLabelUI)object).paintDisabledText(jLabel, (Graphics)object2, string2, n2, n);
                    }
                }
                graphics2D.setTransform(affineTransform);
            }
            return;
        }
        super.paint((Graphics)object, (JComponent)object2);
    }

    public void propertyChange(PropertyChangeEvent serializable) {
        super.propertyChange((PropertyChangeEvent)serializable);
        if ("orientation".equals(((PropertyChangeEvent)serializable).getPropertyName())) {
            if (((EventObject)serializable).getSource() instanceof JLabel) {
                serializable = (JLabel)((EventObject)serializable).getSource();
                ((JComponent)serializable).revalidate();
                return;
            }
        } else if ("clockwise".equals(((PropertyChangeEvent)serializable).getPropertyName()) && ((EventObject)serializable).getSource() instanceof JLabel) {
            serializable = (JLabel)((EventObject)serializable).getSource();
            ((Component)serializable).repaint();
        }
    }
}

