/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public final class WindowsDesktopProperty
implements UIDefaults.ActiveValue {
    private static boolean updatePending;
    private WeakPCL pcl;
    private String key;
    private Object value;
    private Object fallback;
    private Toolkit toolkit;
    private float fontSize = -1.0f;
    private int fontStyle = -1;

    private static synchronized void setUpdatePending(boolean bl) {
        updatePending = bl;
    }

    private static synchronized boolean isUpdatePending() {
        return updatePending;
    }

    private static void updateWindowUI(Window windowArray) {
        SwingUtilities.updateComponentTreeUI((Component)windowArray);
        Window[] windowArray2 = windowArray.getOwnedWindows();
        windowArray = windowArray2;
        windowArray = windowArray2;
        int n = windowArray2.length;
        for (int i = 0; i < n; ++i) {
            Window window = windowArray[i];
            WindowsDesktopProperty.updateWindowUI(window);
        }
    }

    public WindowsDesktopProperty(String string, Object object, Toolkit toolkit) {
        this.key = string;
        this.fallback = object;
        this.toolkit = toolkit;
    }

    public WindowsDesktopProperty(String string, Object object, Toolkit toolkit, float f) {
        this.key = string;
        this.fallback = object;
        this.toolkit = toolkit;
        this.fontSize = f;
    }

    public WindowsDesktopProperty(String string, Object object, Toolkit toolkit, float f, int n) {
        this.key = string;
        this.fallback = object;
        this.toolkit = toolkit;
        this.fontSize = f;
        this.fontStyle = 1;
    }

    public final Object createValue(UIDefaults object) {
        if (this.value == null) {
            object = this;
            if (((WindowsDesktopProperty)object).toolkit == null) {
                ((WindowsDesktopProperty)object).toolkit = Toolkit.getDefaultToolkit();
            }
            Object object2 = object;
            Object object3 = ((WindowsDesktopProperty)object).toolkit.getDesktopProperty(((WindowsDesktopProperty)object2).key);
            ((WindowsDesktopProperty)object).pcl = new WeakPCL(object, ((WindowsDesktopProperty)object).toolkit);
            object2 = object;
            ((WindowsDesktopProperty)object).toolkit.addPropertyChangeListener(((WindowsDesktopProperty)object2).key, ((WindowsDesktopProperty)object).pcl);
            this.value = this.configureValue(object3);
            if (this.value == null) {
                object = this;
                this.value = this.configureValue(((WindowsDesktopProperty)object).fallback instanceof String ? UIDefaultsLookup.get(((WindowsDesktopProperty)object).fallback) : ((WindowsDesktopProperty)object).fallback);
            }
        }
        return this.value;
    }

    public final void invalidate() {
        if (this.pcl != null) {
            WindowsDesktopProperty windowsDesktopProperty = this;
            this.toolkit.removePropertyChangeListener(windowsDesktopProperty.key, this.pcl);
            this.toolkit = null;
            this.pcl = null;
            this.value = null;
        }
    }

    protected final void updateUI() {
        if (!WindowsDesktopProperty.isUpdatePending()) {
            WindowsDesktopProperty.setUpdatePending(true);
            Runnable runnable = new Runnable(this){

                public final void run() {
                    WindowsDesktopProperty.access$000();
                    WindowsDesktopProperty.setUpdatePending(false);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private Object configureValue(Object object) {
        if (object != null) {
            if (object instanceof Color) {
                return new ColorUIResource((Color)object);
            }
            if (object instanceof Font) {
                if (this.fontSize != -1.0f && (float)this.fontStyle != -1.0f) {
                    return new FontUIResource(((Font)object).deriveFont(this.fontStyle, this.fontSize));
                }
                if (this.fontSize != -1.0f) {
                    return new FontUIResource(((Font)object).deriveFont(this.fontSize));
                }
                if ((float)this.fontStyle != -1.0f) {
                    return new FontUIResource(((Font)object).deriveFont(this.fontStyle));
                }
                return new FontUIResource((Font)object);
            }
            if (object instanceof UIDefaults.ProxyLazyValue) {
                object = ((UIDefaults.ProxyLazyValue)object).createValue(null);
            } else if (object instanceof UIDefaults.ActiveValue) {
                object = ((UIDefaults.ActiveValue)object).createValue(null);
            }
        }
        return object;
    }

    static /* synthetic */ void access$000() {
        Frame[] frameArray = Frame.getFrames();
        Frame[] frameArray2 = frameArray;
        frameArray2 = frameArray;
        int n = frameArray.length;
        for (int i = 0; i < n; ++i) {
            Frame frame = frameArray2[i];
            WindowsDesktopProperty.updateWindowUI(frame);
        }
    }

    static final class WeakPCL
    extends WeakReference
    implements PropertyChangeListener {
        private Toolkit kit;

        WeakPCL(Object object, Toolkit toolkit) {
            super(object);
            this.kit = toolkit;
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WindowsDesktopProperty windowsDesktopProperty = (WindowsDesktopProperty)this.get();
            if (windowsDesktopProperty == null) {
                this.kit.removePropertyChangeListener(propertyChangeEvent.getPropertyName(), this);
                return;
            }
            windowsDesktopProperty.invalidate();
            windowsDesktopProperty.updateUI();
        }
    }
}

