/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.ButtonPanel;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SizeRequirements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ButtonPanelLayout
implements LayoutManager2,
Serializable {
    private Container _target;
    private transient SizeRequirements[] _xChildren;
    private transient SizeRequirements[] _yChildren;
    private transient SizeRequirements _xTotal;
    private transient SizeRequirements _yTotal;
    private List<Component> _affirmativeButtons = new Vector<Component>(13);
    private List<Component> _cancelButtons = new Vector<Component>(13);
    private List<Component> _helpButtons = new Vector<Component>(13);
    private List<Component> _otherButtons = new Vector<Component>(13);
    private int _minWidth;
    private int _maxWidth;
    int _groupGap = 10;
    int _buttonGap = 6;
    private int _sizeConstraint = 1;
    private String _buttonOrder = "ACO";
    private String _oppositeButtonOrder = "H";
    private int _minButtonWidth = 75;
    private int _axis = 0;
    private int _alignment = 11;

    public ButtonPanelLayout(Container container, int n, int n2, int n3, String string, String string2, int n4, int n5) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = n;
        this._target = container;
        this._alignment = n2;
        this._sizeConstraint = n3;
        this._buttonOrder = string;
        this._oppositeButtonOrder = string2;
        this._buttonGap = n4;
        this._groupGap = n5;
    }

    @Override
    public final synchronized void invalidateLayout(Container container) {
        this.checkContainer(container);
        this._xChildren = null;
        this._yChildren = null;
        this._xTotal = null;
        this._yTotal = null;
    }

    @Override
    public final void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    @Override
    public final void removeLayoutComponent(Component component) {
        if (this._affirmativeButtons.contains(component)) {
            this._affirmativeButtons.remove(component);
        }
        if (this._cancelButtons.contains(component)) {
            this._cancelButtons.remove(component);
        }
        if (this._helpButtons.contains(component)) {
            this._helpButtons.remove(component);
        }
        if (this._otherButtons.contains(component)) {
            this._otherButtons.remove(component);
        }
    }

    @Override
    public final void addLayoutComponent(Component component, Object object) {
        if ("AFFIRMATIVE".equals(object) && !this._affirmativeButtons.contains(component)) {
            this._affirmativeButtons.add(component);
        }
        if ("CANCEL".equals(object) && !this._cancelButtons.contains(component)) {
            this._cancelButtons.add(component);
        }
        if ("HELP".equals(object) && !this._helpButtons.contains(component)) {
            this._helpButtons.add(component);
        }
        if ("ALTERNATIVE".equals(object) && !this._otherButtons.contains(component)) {
            this._otherButtons.add(component);
        }
    }

    @Override
    public final Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this._xTotal.preferred, this._yTotal.preferred);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    @Override
    public final Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this._xTotal.minimum, this._yTotal.minimum);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    @Override
    public final Dimension maximumLayoutSize(Container container) {
        Dimension dimension;
        Serializable serializable = this;
        synchronized (serializable) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this._xTotal.maximum, this._yTotal.maximum);
        }
        serializable = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    @Override
    public final synchronized float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this._xTotal.alignment;
    }

    @Override
    public final synchronized float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this._yTotal.alignment;
    }

    @Override
    public final void layoutContainer(Container serializable) {
        this.checkContainer((Container)serializable);
        Dimension dimension = serializable.getSize();
        Insets insets = serializable.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        ComponentOrientation componentOrientation = serializable.getComponentOrientation();
        int n = ButtonPanelLayout.resolveAxis(this._axis, componentOrientation);
        boolean bl = componentOrientation.isLeftToRight();
        int n2 = this._alignment;
        if (this._alignment == 10) {
            n2 = bl ? 2 : 4;
        } else if (this._alignment == 11) {
            n2 = bl ? 4 : 2;
        }
        ButtonPanelLayout buttonPanelLayout = this;
        synchronized (buttonPanelLayout) {
            this.checkRequests();
            ButtonPanelLayout buttonPanelLayout2 = this;
            for (Component component : buttonPanelLayout2._affirmativeButtons) {
                component.setBounds(0, 0, 0, 0);
            }
            for (Component component : buttonPanelLayout2._cancelButtons) {
                component.setBounds(0, 0, 0, 0);
            }
            for (Component component : buttonPanelLayout2._otherButtons) {
                component.setBounds(0, 0, 0, 0);
            }
            for (Component component : buttonPanelLayout2._helpButtons) {
                component.setBounds(0, 0, 0, 0);
            }
            if (n == 0) {
                n = insets.top;
                if (n2 == 0) {
                    int n3;
                    serializable = this.preferredLayoutSize((Container)serializable);
                    n2 = (dimension.width + ((Dimension)serializable).width) / 2;
                    for (n3 = 0; n3 < this.getButtonOrder().length(); ++n3) {
                        char c = this.getButtonOrder().charAt(this.getButtonOrder().length() - n3 - 1);
                        if (c == 'A' || c == 'a') {
                            n2 = this.layoutButtonsRightAlign(this._affirmativeButtons, n2, n, dimension);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            n2 = this.layoutButtonsRightAlign(this._cancelButtons, n2, n, dimension);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            n2 = this.layoutButtonsRightAlign(this._helpButtons, n2, n, dimension);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        n2 = this.layoutButtonsRightAlign(this._otherButtons, n2, n, dimension);
                    }
                    n2 = (dimension.width - ((Dimension)serializable).width) / 2;
                    for (n3 = 0; n3 < this.getOppositeButtonOrder().length(); ++n3) {
                        char c = this.getOppositeButtonOrder().charAt(n3);
                        if (c == 'A' || c == 'a') {
                            n2 = this.layoutButtonsLeftAlign(this._affirmativeButtons, n2, n, dimension);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            n2 = this.layoutButtonsLeftAlign(this._cancelButtons, n2, n, dimension);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            n2 = this.layoutButtonsLeftAlign(this._helpButtons, n2, n, dimension);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        n2 = this.layoutButtonsLeftAlign(this._otherButtons, n2, n, dimension);
                    }
                } else if (n2 == 4) {
                    int n4 = insets.left + dimension.width;
                    for (n2 = 0; n2 < this.getButtonOrder().length(); ++n2) {
                        char c = this.getButtonOrder().charAt(bl ? this.getButtonOrder().length() - n2 - 1 : n2);
                        if (c == 'A' || c == 'a') {
                            n4 = this.layoutButtonsRightAlign(this._affirmativeButtons, n4, n, dimension);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            n4 = this.layoutButtonsRightAlign(this._cancelButtons, n4, n, dimension);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            n4 = this.layoutButtonsRightAlign(this._helpButtons, n4, n, dimension);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        n4 = this.layoutButtonsRightAlign(this._otherButtons, n4, n, dimension);
                    }
                    n4 = insets.left;
                    for (n2 = 0; n2 < this.getOppositeButtonOrder().length(); ++n2) {
                        char c = this.getOppositeButtonOrder().charAt(bl ? n2 : this.getOppositeButtonOrder().length() - n2 - 1);
                        if (c == 'A' || c == 'a') {
                            n4 = this.layoutButtonsLeftAlign(this._affirmativeButtons, n4, n, dimension);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            n4 = this.layoutButtonsLeftAlign(this._cancelButtons, n4, n, dimension);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            n4 = this.layoutButtonsLeftAlign(this._helpButtons, n4, n, dimension);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        n4 = this.layoutButtonsLeftAlign(this._otherButtons, n4, n, dimension);
                    }
                } else if (n2 == 2) {
                    int n5 = insets.left;
                    for (n2 = 0; n2 < this.getButtonOrder().length(); ++n2) {
                        char c = this.getButtonOrder().charAt(bl ? n2 : this.getButtonOrder().length() - n2 - 1);
                        if (c == 'A' || c == 'a') {
                            n5 = this.layoutButtonsLeftAlign(this._affirmativeButtons, n5, n, dimension);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            n5 = this.layoutButtonsLeftAlign(this._cancelButtons, n5, n, dimension);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            n5 = this.layoutButtonsLeftAlign(this._helpButtons, n5, n, dimension);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        n5 = this.layoutButtonsLeftAlign(this._otherButtons, n5, n, dimension);
                    }
                    n5 = insets.left + dimension.width;
                    for (n2 = 0; n2 < this.getOppositeButtonOrder().length(); ++n2) {
                        char c = this.getOppositeButtonOrder().charAt(bl ? this.getOppositeButtonOrder().length() - n2 - 1 : n2);
                        if (c == 'A' || c == 'a') {
                            n5 = this.layoutButtonsRightAlign(this._affirmativeButtons, n5, n, dimension);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            n5 = this.layoutButtonsRightAlign(this._cancelButtons, n5, n, dimension);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            n5 = this.layoutButtonsRightAlign(this._helpButtons, n5, n, dimension);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        n5 = this.layoutButtonsRightAlign(this._otherButtons, n5, n, dimension);
                    }
                }
            } else {
                n = insets.left;
                if (n2 == 1) {
                    int n6 = insets.top;
                    for (n2 = 0; n2 < this.getButtonOrder().length(); ++n2) {
                        char c = this.getButtonOrder().charAt(n2);
                        if (c == 'A' || c == 'a') {
                            n6 = this.layoutButtonsTopAlign(this._affirmativeButtons, n, n6, dimension);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            n6 = this.layoutButtonsTopAlign(this._cancelButtons, n, n6, dimension);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            n6 = this.layoutButtonsTopAlign(this._helpButtons, n, n6, dimension);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        n6 = this.layoutButtonsTopAlign(this._otherButtons, n, n6, dimension);
                    }
                    n6 = insets.top + dimension.height;
                    for (n2 = 0; n2 < this.getOppositeButtonOrder().length(); ++n2) {
                        char c = this.getOppositeButtonOrder().charAt(this.getOppositeButtonOrder().length() - n2 - 1);
                        if (c == 'A' || c == 'a') {
                            n6 = this.layoutButtonsBottomAlign(this._affirmativeButtons, n, n6, dimension);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            n6 = this.layoutButtonsBottomAlign(this._cancelButtons, n, n6, dimension);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            n6 = this.layoutButtonsBottomAlign(this._helpButtons, n, n6, dimension);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        n6 = this.layoutButtonsBottomAlign(this._otherButtons, n, n6, dimension);
                    }
                } else if (n2 == 3) {
                    int n7 = insets.top + dimension.height;
                    for (n2 = 0; n2 < this.getButtonOrder().length(); ++n2) {
                        char c = this.getButtonOrder().charAt(this.getButtonOrder().length() - n2 - 1);
                        if (c == 'A' || c == 'a') {
                            n7 = this.layoutButtonsBottomAlign(this._affirmativeButtons, n, n7, dimension);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            n7 = this.layoutButtonsBottomAlign(this._cancelButtons, n, n7, dimension);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            n7 = this.layoutButtonsBottomAlign(this._helpButtons, n, n7, dimension);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        n7 = this.layoutButtonsBottomAlign(this._otherButtons, n, n7, dimension);
                    }
                    n7 = insets.top;
                    for (n2 = 0; n2 < this.getOppositeButtonOrder().length(); ++n2) {
                        char c = this.getOppositeButtonOrder().charAt(n2);
                        if (c == 'A' || c == 'a') {
                            n7 = this.layoutButtonsTopAlign(this._affirmativeButtons, n, n7, dimension);
                            continue;
                        }
                        if (c == 'C' || c == 'c') {
                            n7 = this.layoutButtonsTopAlign(this._cancelButtons, n, n7, dimension);
                            continue;
                        }
                        if (c == 'H' || c == 'h') {
                            n7 = this.layoutButtonsTopAlign(this._helpButtons, n, n7, dimension);
                            continue;
                        }
                        if (c != 'O' && c != 'o') continue;
                        n7 = this.layoutButtonsTopAlign(this._otherButtons, n, n7, dimension);
                    }
                }
            }
            return;
        }
    }

    private int layoutButtonsRightAlign(List list, int n, int n2, Dimension dimension) {
        boolean bl = false;
        for (int i = this._target.getComponentCount() - 1; i >= 0; --i) {
            Component component = this._target.getComponent(i);
            if (!component.isVisible() || !list.contains(component)) continue;
            if (bl) {
                n -= this._buttonGap;
            }
            bl = true;
            int n3 = component.getPreferredSize().width;
            n3 = n3 > this._minWidth || ButtonPanelLayout.shouldKeepPreferredWidth(component) ? n3 : this._minWidth;
            component.setBounds(n - n3, n2, n3, dimension.height);
            n -= n3;
        }
        if (list.size() != 0 && bl) {
            n -= this._groupGap;
        }
        return n;
    }

    private int layoutButtonsLeftAlign(List<Component> list, int n, int n2, Dimension dimension) {
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component component = this._target.getComponent(i);
            if (!component.isVisible() || !list.contains(component)) continue;
            int n3 = component.getPreferredSize().width;
            n3 = n3 > this._minWidth || ButtonPanelLayout.shouldKeepPreferredWidth(component) ? n3 : this._minWidth;
            component.setBounds(n, n2, n3, dimension.height);
            n += n3;
            if (i == list.size() - 1) continue;
            n += this._buttonGap;
        }
        if (list.size() != 0) {
            n += this._groupGap;
        }
        return n;
    }

    private int layoutButtonsBottomAlign(List<Component> list, int n, int n2, Dimension dimension) {
        boolean bl = false;
        for (int i = this._target.getComponentCount() - 1; i >= 0; --i) {
            Component component = this._target.getComponent(i);
            if (!component.isVisible() || !list.contains(component)) continue;
            bl = true;
            Dimension dimension2 = component.getPreferredSize();
            int n3 = dimension2.height;
            int n4 = dimension2.width;
            component.setBounds(ButtonPanelLayout.shouldKeepPreferredWidth(component) ? dimension.width - n4 + n : n, n2 - n3, ButtonPanelLayout.shouldKeepPreferredWidth(component) ? n4 : dimension.width, n3);
            n2 -= n3;
            if (i == 0) continue;
            n2 -= this._buttonGap;
        }
        if (list.size() != 0 && bl) {
            n2 -= this._groupGap;
        }
        return n2;
    }

    private int layoutButtonsTopAlign(List<Component> list, int n, int n2, Dimension dimension) {
        boolean bl = false;
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component component = this._target.getComponent(i);
            if (!component.isVisible() || !list.contains(component)) continue;
            bl = true;
            Dimension dimension2 = component.getPreferredSize();
            int n3 = dimension2.height;
            int n4 = dimension2.width;
            component.setBounds(ButtonPanelLayout.shouldKeepPreferredWidth(component) ? dimension.width - n4 + n : n, n2, ButtonPanelLayout.shouldKeepPreferredWidth(component) ? n4 : dimension.width, n3);
            n2 += n3;
            if (i == list.size() - 1) continue;
            n2 += this._buttonGap;
        }
        if (list.size() != 0 && bl) {
            n2 += this._groupGap;
        }
        return n2;
    }

    private static boolean shouldKeepPreferredWidth(Component component) {
        return component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("keepPreferredWidth"));
    }

    private void checkContainer(Container container) {
        if (this._target != container) {
            throw new AWTError("BorderPaneLayout can't be shared");
        }
        if (!(container instanceof ButtonPanel)) {
            throw new AWTError("Target is not a ButtonPanel");
        }
    }

    private static int getButtonCountof(List<Component> object) {
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Component component = (Component)object.next();
            if (!component.isVisible()) continue;
            ++n;
        }
        return n;
    }

    private void checkRequests() {
        int n = (ButtonPanelLayout.getButtonCountof(this._affirmativeButtons) == 0 ? 0 : 1) + (ButtonPanelLayout.getButtonCountof(this._otherButtons) == 0 ? 0 : 1) + (ButtonPanelLayout.getButtonCountof(this._cancelButtons) == 0 ? 0 : 1) + (ButtonPanelLayout.getButtonCountof(this._helpButtons) == 0 ? 0 : 1);
        int n2 = ButtonPanelLayout.getButtonCountof(this._affirmativeButtons) + ButtonPanelLayout.getButtonCountof(this._otherButtons) + ButtonPanelLayout.getButtonCountof(this._cancelButtons) + ButtonPanelLayout.getButtonCountof(this._helpButtons);
        if (this._xChildren == null || this._yChildren == null) {
            Serializable serializable;
            int n3;
            int n4;
            int n5 = n4 = this._target.getComponentCount();
            for (n3 = 0; n3 < n4; ++n3) {
                if (this._target.getComponent(n3).isVisible()) continue;
                --n5;
            }
            this._xChildren = new SizeRequirements[n5];
            this._yChildren = new SizeRequirements[n5];
            n3 = 0;
            for (n5 = 0; n5 < n4; ++n5) {
                Component component = this._target.getComponent(n5);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getMinimumSize();
                Dimension dimension2 = component.getPreferredSize();
                serializable = component.getMaximumSize();
                this._xChildren[n3] = new SizeRequirements(dimension.width, dimension2.width, serializable.width, component.getAlignmentX());
                this._yChildren[n3] = new SizeRequirements(dimension.height, dimension2.height, serializable.height, component.getAlignmentY());
                if (ButtonPanelLayout.shouldKeepPreferredWidth(this._target.getComponent(n5))) {
                    this._xChildren[n3].maximum = 0;
                }
                ++n3;
            }
            n5 = ButtonPanelLayout.resolveAxis(this._axis, this._target.getComponentOrientation());
            if (n5 == 0) {
                int n6;
                ButtonPanelLayout buttonPanelLayout;
                this._xTotal = SizeRequirements.getTiledSizeRequirements(this._xChildren);
                this._yTotal = SizeRequirements.getAlignedSizeRequirements(this._yChildren);
                this._maxWidth = SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])this._xChildren).maximum;
                if (this._sizeConstraint == 0) {
                    buttonPanelLayout = this;
                    n6 = buttonPanelLayout._minButtonWidth;
                    if (this._maxWidth < n6) {
                        this._maxWidth = n6;
                    }
                    this._minWidth = this._maxWidth;
                } else {
                    buttonPanelLayout = this;
                    n6 = buttonPanelLayout._minButtonWidth;
                    this._minWidth = n6 == 0 ? 75 : n6;
                }
                SizeRequirements[] sizeRequirementsArray = this._xChildren;
                int n7 = this._xChildren.length;
                for (int i = 0; i < n7; ++i) {
                    serializable = sizeRequirementsArray[i];
                    if (((SizeRequirements)serializable).preferred >= this._minWidth) continue;
                    ((SizeRequirements)serializable).preferred = this._minWidth;
                }
                this._xTotal = SizeRequirements.getTiledSizeRequirements(this._xChildren);
                this._xTotal.preferred += (n - 1) * this._groupGap + (n2 - n) * this._buttonGap;
                this._xTotal.minimum += (n - 1) * this._groupGap + (n2 - n) * this._buttonGap;
                return;
            }
            this._xTotal = SizeRequirements.getAlignedSizeRequirements(this._xChildren);
            this._yTotal = SizeRequirements.getTiledSizeRequirements(this._yChildren);
            ButtonPanelLayout buttonPanelLayout = this;
            int n8 = buttonPanelLayout._minButtonWidth;
            this._maxWidth = n8 == 0 ? 75 : n8;
            this._minWidth = this._maxWidth;
            this._xTotal.preferred = this._maxWidth > this._xTotal.maximum ? this._maxWidth : this._xTotal.preferred;
            this._yTotal.preferred += (n - 1) * this._groupGap + (n2 - n) * this._buttonGap;
            this._yTotal.minimum += (n - 1) * this._groupGap + (n2 - n) * this._buttonGap;
        }
    }

    private static int resolveAxis(int n, ComponentOrientation componentOrientation) {
        block1: {
            block0: {
                if (n != 2) break block0;
                n = componentOrientation.isHorizontal() ? 0 : 1;
                break block1;
            }
            if (n != 3) break block1;
            n = componentOrientation.isHorizontal() ? 1 : 0;
        }
        return n;
    }

    public final void setGroupGap(int n) {
        this._groupGap = n;
        this.invalidateLayout(this._target);
    }

    public final void setButtonGap(int n) {
        this._buttonGap = n;
        this.invalidateLayout(this._target);
    }

    public final void setSizeConstraint(int n) {
        this._sizeConstraint = n;
        this.invalidateLayout(this._target);
    }

    public final int getMinButtonWidth() {
        return this._minButtonWidth;
    }

    public final void setMinButtonWidth(int n) {
        this._minButtonWidth = n;
        this.invalidateLayout(this._target);
    }

    public final String getButtonOrder() {
        if (this._buttonOrder == null) {
            return "";
        }
        return this._buttonOrder;
    }

    public final void setButtonOrder(String string) {
        this._buttonOrder = string;
        this.invalidateLayout(this._target);
    }

    public final String getOppositeButtonOrder() {
        if (this._oppositeButtonOrder == null) {
            return "";
        }
        return this._oppositeButtonOrder;
    }

    public final void setOppositeButtonOrder(String string) {
        this._oppositeButtonOrder = string;
        this.invalidateLayout(this._target);
    }
}

