/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateConverter
implements ObjectConverter {
    public static final ConverterContext DATETIME_CONTEXT = new ConverterContext("DateTime");
    public static final ConverterContext TIME_CONTEXT = new ConverterContext("Time");
    private DateFormat _shortFormat = SimpleDateFormat.getDateInstance(3);
    private DateFormat _mediumFormat = SimpleDateFormat.getDateInstance(2);
    private DateFormat _longFormat = SimpleDateFormat.getDateInstance(1);
    private DateFormat _defaultFormat = SimpleDateFormat.getDateInstance(2);
    private DateFormat _shortDatetimeFormat = SimpleDateFormat.getDateTimeInstance(3, 3);
    private DateFormat _mediumDatetimeFormat = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat _longDatetimeFormat = SimpleDateFormat.getDateTimeInstance(1, 1);
    private DateFormat _defaultDatetimeFormat = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat _shortTimeFormat = SimpleDateFormat.getTimeInstance(3);
    private DateFormat _mediumTimeFormat = SimpleDateFormat.getTimeInstance(2);
    private DateFormat _longTimeFormat = SimpleDateFormat.getTimeInstance(1);
    private DateFormat _defaultTimeFormat = SimpleDateFormat.getTimeInstance(2);

    public synchronized String toString(Object object, ConverterContext converterContext) {
        Cloneable cloneable;
        if (object == null) {
            return "";
        }
        if (object instanceof Calendar) {
            cloneable = ((Calendar)object).getTimeZone();
            object = ((Calendar)object).getTime();
        } else if (object instanceof Date) {
            cloneable = Calendar.getInstance();
            ((Calendar)cloneable).setTime((Date)object);
            cloneable = ((Calendar)cloneable).getTimeZone();
        } else {
            cloneable = TimeZone.getDefault();
        }
        if (object instanceof Date || object instanceof Number) {
            if (converterContext != null) {
                ConverterContext converterContext2 = converterContext;
                if (null instanceof DateFormat) {
                    converterContext2 = converterContext;
                    return ((DateFormat)null).format(object);
                }
            }
            if (DATETIME_CONTEXT.equals(converterContext)) {
                this._defaultDatetimeFormat.setTimeZone((TimeZone)cloneable);
                return this._defaultDatetimeFormat.format(object);
            }
            if (TIME_CONTEXT.equals(converterContext)) {
                this._defaultTimeFormat.setTimeZone((TimeZone)cloneable);
                return this._defaultTimeFormat.format(object);
            }
            this._defaultFormat.setTimeZone((TimeZone)cloneable);
            return this._defaultFormat.format(object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public synchronized Object fromString(String string, ConverterContext converterContext) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            ConverterContext converterContext2;
            if (converterContext != null) {
                converterContext2 = converterContext;
            }
            converterContext2 = null;
            if (null instanceof DateFormat) {
                return ((DateFormat)((Object)converterContext2)).parse(string);
            }
            if (DATETIME_CONTEXT.equals(converterContext)) {
                return this._defaultDatetimeFormat.parse(string);
            }
            if (TIME_CONTEXT.equals(converterContext)) {
                return this._defaultTimeFormat.parse(string);
            }
            return this._defaultFormat.parse(string);
        }
        catch (ParseException parseException) {
            if (DATETIME_CONTEXT.equals(converterContext)) {
                try {
                    return this._shortDatetimeFormat.parse(string);
                }
                catch (ParseException parseException2) {
                    try {
                        return this._mediumDatetimeFormat.parse(string);
                    }
                    catch (ParseException parseException3) {
                        try {
                            return this._longDatetimeFormat.parse(string);
                        }
                        catch (ParseException parseException4) {
                            return string;
                        }
                    }
                }
            }
            if (TIME_CONTEXT.equals(converterContext)) {
                try {
                    return this._shortTimeFormat.parse(string);
                }
                catch (ParseException parseException5) {
                    try {
                        return this._mediumTimeFormat.parse(string);
                    }
                    catch (ParseException parseException6) {
                        try {
                            return this._longTimeFormat.parse(string);
                        }
                        catch (ParseException parseException7) {
                            return string;
                        }
                    }
                }
            }
            try {
                return this._shortFormat.parse(string);
            }
            catch (ParseException parseException8) {
                try {
                    return this._mediumFormat.parse(string);
                }
                catch (ParseException parseException9) {
                    try {
                        return this._longFormat.parse(string);
                    }
                    catch (ParseException parseException10) {
                        return string;
                    }
                }
            }
        }
    }

    public final boolean supportFromString$5f33f571() {
        return true;
    }

    static {
        new ConverterContext("Date");
    }
}

